/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.queryplus;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.queryplus.AbstractQueryPlusStatementBuilder;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.config.expression.ParameterResolver;
import java.util.List;

public class TraceStatementBuilder
extends AbstractQueryPlusStatementBuilder {
    protected final OPToken f_tokenDelegate;

    public TraceStatementBuilder(OPToken tokenDelegate) {
        this.f_tokenDelegate = tokenDelegate;
    }

    @Override
    public TraceQueryPlusStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        AtomicTerm atomicTerm = (AtomicTerm)term.termAt(1);
        if ("on".equals(atomicTerm.getValue())) {
            return new TraceQueryPlusStatement(true);
        }
        if ("off".equals(atomicTerm.getValue())) {
            return new TraceQueryPlusStatement(false);
        }
        throw new CohQLException("Invalid trace command - valid syntax is: " + this.getSyntax());
    }

    @Override
    public String getSyntax() {
        return "TRACE (ON | OFF)";
    }

    @Override
    public String getDescription() {
        return "Controls tracing mode. This shows information that can help with debugging";
    }

    @Override
    public AbstractQueryPlusStatementBuilder.AbstractOPToken instantiateOpToken() {
        return new TraceCommandOPToken();
    }

    public class TraceQueryPlusStatement
    extends AbstractQueryPlusStatementBuilder.AbstractStatement {
        protected boolean m_fTrace;

        protected TraceQueryPlusStatement(boolean fTrace) {
            this.m_fTrace = fTrace;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            ctx.setTraceEnabled(this.m_fTrace);
            return StatementResult.NULL_RESULT;
        }
    }

    public class TraceCommandOPToken
    extends AbstractQueryPlusStatementBuilder.AbstractOPToken {
        public TraceCommandOPToken() {
            super("trace", OPToken.IDENTIFIER_NODE, "traceCommand");
        }

        @Override
        public Term nud(OPParser parser) {
            OPScanner scanner = parser.getScanner();
            String action = scanner.getCurrentAsString();
            if ("on".equals(action) || "off".equals(action) || TraceStatementBuilder.this.f_tokenDelegate == null) {
                scanner.advance();
                return Terms.newTerm(this.getFunctor(), AtomicTerm.createString(action));
            }
            return TraceStatementBuilder.this.f_tokenDelegate.nud(parser);
        }

        @Override
        public Term led(OPParser parser, Term termLeft) {
            if (TraceStatementBuilder.this.f_tokenDelegate == null) {
                return super.led(parser, termLeft);
            }
            return TraceStatementBuilder.this.f_tokenDelegate.led(parser, termLeft);
        }
    }
}

