/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.List;

public class ForceRecoveryStatementBuilder
extends AbstractStatementBuilder<ForceRecoveryStatement> {
    public static final ForceRecoveryStatementBuilder INSTANCE = new ForceRecoveryStatementBuilder();

    @Override
    public ForceRecoveryStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sServiceName = ForceRecoveryStatementBuilder.atomicStringValueOf(term.findAttribute("service"));
        if (sServiceName == null || sServiceName.isEmpty()) {
            throw new CohQLException("Service name required for force recovery");
        }
        return new ForceRecoveryStatement(sServiceName == null || sServiceName.isEmpty() ? null : sServiceName);
    }

    @Override
    public String getSyntax() {
        return "FORCE RECOVERY 'service'";
    }

    @Override
    public String getDescription() {
        return "Proceed with recovery despite the dynamic quorum policy objections.\nThis may lead to the partial or full data loss at the corresponding\ncache service.";
    }

    public static class ForceRecoveryStatement
    extends AbstractStatement {
        private final String f_sServiceName;

        public ForceRecoveryStatement(String sServiceName) {
            this.f_sServiceName = sServiceName;
        }

        @Override
        public String getExecutionConfirmation(ExecutionContext ctx) {
            return "This operation may result in partial or full data loss. \nAre you sure you want to force recovery of this service '" + this.f_sServiceName + "'? (y/n): ";
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            PersistenceToolsHelper helper = PersistenceToolsHelper.ensurePersistenceToolsHelper(ctx);
            PrintWriter out = ctx.getWriter();
            try {
                if (!helper.serviceExists(this.f_sServiceName)) {
                    throw new CohQLException("Service '" + this.f_sServiceName + "' does not exist");
                }
                out.println("Forcing Recovery '" + this.f_sServiceName + "'");
                out.flush();
                helper.invokeOperation("forceRecovery", this.f_sServiceName, new Object[0], new String[0]);
                out.println("Recovery forced");
                out.flush();
            }
            catch (Exception e) {
                throw PersistenceToolsHelper.ensureCohQLException(e, "Error in FORCE RECOVERY");
            }
            return new DefaultStatementResult("Success", true);
        }

        @Override
        public void showPlan(PrintWriter out) {
        }
    }
}

