/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.List;

public class ListArchiverStatementBuilder
extends AbstractStatementBuilder<ListArchiverStatement> {
    public static final ListArchiverStatementBuilder INSTANCE = new ListArchiverStatementBuilder();

    @Override
    public ListArchiverStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sServiceName = ListArchiverStatementBuilder.atomicStringValueOf(term.findAttribute("service"));
        if (sServiceName == null || sServiceName.isEmpty()) {
            throw new CohQLException("Service name required for LIST ARCHIVER");
        }
        return new ListArchiverStatement(sServiceName == null || sServiceName.isEmpty() ? null : sServiceName);
    }

    @Override
    public String getSyntax() {
        return "LIST ARCHIVER 'service'";
    }

    @Override
    public String getDescription() {
        return "List the archiver configured for a given service.";
    }

    public static class ListArchiverStatement
    extends AbstractStatement {
        private final String f_sServiceName;

        public ListArchiverStatement(String sServiceName) {
            this.f_sServiceName = sServiceName;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            String oResult;
            PersistenceToolsHelper helper = PersistenceToolsHelper.ensurePersistenceToolsHelper(ctx);
            try {
                if (!helper.serviceExists(this.f_sServiceName)) {
                    throw new CohQLException("Service '" + this.f_sServiceName + "' does not exist");
                }
                oResult = helper.getArchiver(this.f_sServiceName);
            }
            catch (Exception e) {
                throw PersistenceToolsHelper.ensureCohQLException(e, "Error in LIST ARCHIVER");
            }
            return new DefaultStatementResult(oResult, true);
        }

        @Override
        public void showPlan(PrintWriter out) {
        }
    }
}

