/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dslquery.statement.persistence.AbstractSnapshotStatement;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.List;

public class RemoveSnapshotStatementBuilder
extends AbstractStatementBuilder<RemoveSnapshotStatement> {
    public static final RemoveSnapshotStatementBuilder INSTANCE = new RemoveSnapshotStatementBuilder();

    @Override
    public RemoveSnapshotStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sServiceName = RemoveSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("service"));
        String sSnapshotName = RemoveSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("snapshotname"));
        boolean fArchived = "true".equals(RemoveSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("archived")));
        if (sSnapshotName == null || sSnapshotName.isEmpty()) {
            throw new CohQLException("Snapshot name required for remove snapshot");
        }
        if (sServiceName == null || sServiceName.isEmpty()) {
            throw new CohQLException("Service name required for remove snapshot");
        }
        return new RemoveSnapshotStatement(sSnapshotName, sServiceName, fArchived);
    }

    @Override
    public String getSyntax() {
        return "REMOVE [ARCHIVED] SNAPSHOT 'snapshot-name' 'service'";
    }

    @Override
    public String getDescription() {
        return "Remove a snapshot for and individual service. If the ARCHIVED keyword is used\nthen an archived snapshot of the name will be removed.";
    }

    public static class RemoveSnapshotStatement
    extends AbstractSnapshotStatement {
        final boolean f_fArchived;

        public RemoveSnapshotStatement(String sSnapshotName, String sServiceName, boolean fArchive) {
            super(RemoveSnapshotStatement.replaceDateMacros(sSnapshotName), sServiceName);
            this.f_fArchived = fArchive;
        }

        @Override
        public String getExecutionConfirmation(ExecutionContext ctx) {
            return "Are you sure you want to remove" + (this.f_fArchived ? "archived " : "") + " snapshot called '" + this.f_sSnapshotName + "' for service '" + this.f_sServiceName + "'? (y/n): ";
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            PersistenceToolsHelper helper = PersistenceToolsHelper.ensurePersistenceToolsHelper(ctx);
            PrintWriter out = ctx.getWriter();
            try {
                if (this.f_fArchived) {
                    this.validateServiceExists(helper);
                    this.validateArchivedSnapshotExistsForService(helper);
                    helper.ensureReady(ctx, this.f_sServiceName);
                    out.println("Removing archived snapshot '" + this.f_sSnapshotName + "' for service '" + this.f_sServiceName + "'");
                    out.flush();
                    helper.invokeOperationWithWait("removeArchivedSnapshot", this.f_sSnapshotName, this.f_sServiceName);
                } else {
                    this.validateServiceExists(helper);
                    this.validateSnapshotExistsForService(helper);
                    helper.ensureReady(ctx, this.f_sServiceName);
                    out.println("Removing snapshot '" + this.f_sSnapshotName + "' for service '" + this.f_sServiceName + "'");
                    out.flush();
                    helper.invokeOperationWithWait("removeSnapshot", this.f_sSnapshotName, this.f_sServiceName);
                }
            }
            catch (Exception e) {
                throw PersistenceToolsHelper.ensureCohQLException(e, "Error in REMOVE SNAPSHOT");
            }
            return new DefaultStatementResult("Success", true);
        }
    }
}

