/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dslquery.statement.persistence.AbstractSnapshotStatement;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.List;

public class RetrieveSnapshotStatementBuilder
extends AbstractStatementBuilder<RetrieveSnapshotStatement> {
    public static final RetrieveSnapshotStatementBuilder INSTANCE = new RetrieveSnapshotStatementBuilder();

    @Override
    public RetrieveSnapshotStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sServiceName = RetrieveSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("service"));
        String sSnapshotName = RetrieveSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("snapshotname"));
        boolean fVerbose = "true".equals(RetrieveSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("overwrite")));
        if (sSnapshotName == null || sSnapshotName.isEmpty()) {
            throw new CohQLException("Snapshot name required for retrieve snapshot");
        }
        if (sServiceName == null || sServiceName.isEmpty()) {
            throw new CohQLException("Service name required for retrieve snapshot");
        }
        return new RetrieveSnapshotStatement(sSnapshotName, sServiceName, fVerbose);
    }

    @Override
    public String getSyntax() {
        return "RETRIEVE ARCHIVED SNAPSHOT 'snapshot-name' 'service' [OVERWIRTE]";
    }

    @Override
    public String getDescription() {
        return "Retrieve an archived snapshot for an individual service from a centralized\nlocation using the archiver configured for the service. If a local snapshot\nexists with the same name an error is thrown unless OVERWRITE option is used";
    }

    public static class RetrieveSnapshotStatement
    extends AbstractSnapshotStatement {
        private final boolean f_fOverwrite;

        public RetrieveSnapshotStatement(String sSnapshotName, String sServiceName, boolean fOverwrite) {
            super(RetrieveSnapshotStatement.replaceDateMacros(sSnapshotName), sServiceName);
            this.f_fOverwrite = fOverwrite;
        }

        @Override
        public String getExecutionConfirmation(ExecutionContext ctx) {
            return this.getConfirmationMessage("retrieve");
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            PersistenceToolsHelper helper = PersistenceToolsHelper.ensurePersistenceToolsHelper(ctx);
            PrintWriter out = ctx.getWriter();
            try {
                this.validateServiceExists(helper);
                this.validateArchivedSnapshotExistsForService(helper);
                helper.ensureReady(ctx, this.f_sServiceName);
                if (helper.snapshotExists(this.f_sServiceName, this.f_sSnapshotName)) {
                    if (this.f_fOverwrite) {
                        out.println("Removing existing local snapshot '" + this.f_sSnapshotName + "' for service '" + this.f_sServiceName + "' because OVERWRITE option was specified.");
                        out.flush();
                        helper.invokeOperationWithWait("removeSnapshot", this.f_sSnapshotName, this.f_sServiceName);
                        out.println("Local snapshot removed");
                        out.flush();
                    } else {
                        throw new CohQLException("A snapshot named '" + this.f_sSnapshotName + "' already exists for service '" + this.f_sServiceName + "'.\nPlease remove it if you want to retrieve the snapshot or use the OVERWRITE option.");
                    }
                }
                out.println("Retrieving snapshot '" + this.f_sSnapshotName + "' for service '" + this.f_sServiceName + "'");
                out.flush();
                helper.invokeOperationWithWait("retrieveArchivedSnapshot", this.f_sSnapshotName, this.f_sServiceName);
            }
            catch (Exception e) {
                throw PersistenceToolsHelper.ensureCohQLException(e, "Error in RETRIEVE SNAPSHOT");
            }
            return new DefaultStatementResult("Success", true);
        }
    }
}

