/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.token.persistence;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.token.SQLOPToken;
import com.tangosol.coherence.dsltools.precedence.OPException;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;

public class SQLRemoveSnapshotOPToken
extends SQLOPToken {
    public static final String FUNCTOR = "sqlRemoveSnapshot";

    public SQLRemoveSnapshotOPToken(String id) {
        super(id, IDENTIFIER_NODE);
    }

    @Override
    public Term nud(OPParser p) {
        OPScanner s = p.getScanner();
        boolean fArchived = false;
        if (s.advanceWhenMatching("archived")) {
            fArchived = true;
        }
        if (s.advanceWhenMatching("snapshot")) {
            if (s.isEndOfStatement()) {
                throw new CohQLException("Snapshot name required for REMOVE SNAPSHOT");
            }
            Term termSnapshot = Terms.newTerm("snapshotname", AtomicTerm.createString(s.getCurrentAsStringWithAdvance()));
            if (s.isEndOfStatement()) {
                throw new OPException("Service name required for REMOVE SNAPSHOT");
            }
            Term termService = Terms.newTerm("service", AtomicTerm.createString(s.getCurrentAsStringWithAdvance()));
            Term termArchive = Terms.newTerm("archived", AtomicTerm.createString(fArchived ? "true" : "false"));
            return Terms.newTerm(FUNCTOR, termSnapshot, termService, termArchive);
        }
        throw new OPException("Expected SNAPSHOT but found " + s.getCurrentAsString());
    }
}

