/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.token.persistence;

import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.token.SQLOPToken;
import com.tangosol.coherence.dsltools.precedence.OPException;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;

public class SQLValidateSnapshotOPToken
extends SQLOPToken {
    public static final String FUNCTOR = "sqlValidateSnapshot";

    public SQLValidateSnapshotOPToken(String id) {
        super(id, IDENTIFIER_NODE);
    }

    @Override
    public Term nud(OPParser p) {
        OPScanner s = p.getScanner();
        boolean fArchive = s.advanceWhenMatching("archived");
        String sCommand = "VALIDATE ARCHIVED SNAPSHOT";
        if (s.advanceWhenMatching("snapshot")) {
            Term termType = Terms.newTerm("type", AtomicTerm.createString(fArchive ? "archived" : "snapshot"));
            if (fArchive) {
                Term termSnapshotName = PersistenceToolsHelper.getNextTerm(s, "snapshotname", "Snapshot Name", "VALIDATE ARCHIVED SNAPSHOT");
                Term termServiceName = PersistenceToolsHelper.getNextTerm(s, "servicename", "Service Name", "VALIDATE ARCHIVED SNAPSHOT");
                Term termVerbose = Terms.newTerm("verbose", AtomicTerm.createString(s.advanceWhenMatching("verbose") ? "true" : "false"));
                return Terms.newTerm(FUNCTOR, new Term[]{termSnapshotName, termServiceName, termVerbose, termType});
            }
            String sNext = s.peekNextAsString();
            if (sNext == null || sNext != null && "VERBOSE".equals(sNext.toUpperCase())) {
                Term termSnapshotDir = Terms.newTerm("snapshotdirectory", AtomicTerm.createString(s.getCurrentAsStringWithAdvance()));
                Term termVerbose = Terms.newTerm("verbose", AtomicTerm.createString(s.advanceWhenMatching("verbose") ? "true" : "false"));
                return Terms.newTerm(FUNCTOR, termSnapshotDir, termVerbose, termType);
            }
            Term termSnapshotName = PersistenceToolsHelper.getNextTerm(s, "snapshotname", "Snapshot Name", "VALIDATE ARCHIVED SNAPSHOT");
            Term termServiceName = PersistenceToolsHelper.getNextTerm(s, "servicename", "Service Name", "VALIDATE ARCHIVED SNAPSHOT");
            Term termVerbose = Terms.newTerm("verbose", AtomicTerm.createString(s.advanceWhenMatching("verbose") ? "true" : "false"));
            return Terms.newTerm(FUNCTOR, termSnapshotName, termServiceName, termVerbose, termType);
        }
        throw new OPException("Expected SNAPSHOT but found " + s.getCurrentAsString());
    }
}

