/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dsltools.termtrees;

import com.tangosol.coherence.dsltools.termtrees.TermWalker;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Term
implements Iterable<Term> {
    public abstract String getFunctor();

    public abstract Term termAt(int var1);

    public abstract Term[] children();

    public abstract Term withChild(Term var1);

    public abstract boolean termEqual(Term var1);

    public abstract String fullFormString();

    public boolean isLeaf() {
        return true;
    }

    public boolean isAtom() {
        return true;
    }

    public boolean isNumber() {
        return false;
    }

    public int length() {
        return this.children().length;
    }

    public Term findChild(String sFunctor) {
        for (Term t : this.children()) {
            if (!sFunctor.equals(t.getFunctor())) continue;
            return t;
        }
        return null;
    }

    public Term findAttribute(String sFunctor) {
        for (Term t : this.children()) {
            if (!sFunctor.equals(t.getFunctor()) || t.length() != 1) continue;
            return t.termAt(1);
        }
        return null;
    }

    public boolean childrenTermEqual(Term t) {
        Term[] aOtherTerms;
        if (t == null) {
            return false;
        }
        Term[] aMyTerms = this.children();
        int count = aMyTerms.length;
        if (count != (aOtherTerms = t.children()).length) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        for (int i = 0; i < count; ++i) {
            if (aMyTerms[i].termEqual(aOtherTerms[i])) continue;
            return false;
        }
        return true;
    }

    public boolean headChildrenTermEqual(Term t) {
        Term[] aOtherTerms;
        if (t == null) {
            return false;
        }
        if (t.isAtom()) {
            return false;
        }
        Term[] aMyTerms = this.children();
        int count = aMyTerms.length;
        if (count > (aOtherTerms = t.children()).length) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        for (int i = 0; i < count; ++i) {
            if (aMyTerms[i].termEqual(aOtherTerms[i])) continue;
            return false;
        }
        return true;
    }

    public void accept(TermWalker walker) {
        walker.acceptTerm(this.getFunctor(), this);
    }

    @Override
    public Iterator<Term> iterator() {
        return new TermIterator(this);
    }

    public class TermIterator
    implements Iterator<Term> {
        private final Term f_termParent;
        private int m_nIndex;

        public TermIterator(Term termParent) {
            this.f_termParent = termParent;
            this.m_nIndex = 1;
        }

        @Override
        public boolean hasNext() {
            return this.m_nIndex <= this.f_termParent.length();
        }

        @Override
        public Term next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Attempt to read past end of Term Iterator");
            }
            return this.f_termParent.termAt(this.m_nIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Term Iterator does not support remove");
        }
    }
}

