/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.processor;

import com.tangosol.coherence.memcached.Response;
import com.tangosol.coherence.memcached.processor.PutProcessor;
import com.tangosol.coherence.memcached.server.DataHolder;
import com.tangosol.coherence.memcached.server.MemcachedHelper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AppendPrependProcessor
extends PutProcessor
implements ExternalizableLite,
PortableObject {
    protected byte[] m_abDelta;
    protected boolean m_fAppend;

    public AppendPrependProcessor() {
    }

    public AppendPrependProcessor(byte[] obDelta, long lVersion, boolean fAppend, boolean fBinaryPassThru) {
        super(null, 0, lVersion, 0, fBinaryPassThru);
        this.m_abDelta = obDelta;
        this.m_fAppend = fAppend;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        BinaryEntry binaryEntry = MemcachedHelper.getBinaryEntry(entry);
        Binary binValue = binaryEntry.getBinaryValue();
        if (binValue == null) {
            return Response.ResponseCode.KEYNF;
        }
        BackingMapManagerContext mgrCtx = binaryEntry.getBackingMapContext().getManagerContext();
        DataHolder holder = MemcachedHelper.convertToDataHolder(binValue, mgrCtx, this.m_fBinaryPassThru);
        byte[] abValueOld = holder.getValue();
        ByteBuffer buf = ByteBuffer.allocate(abValueOld.length + this.m_abDelta.length);
        if (this.m_fAppend) {
            buf.put(abValueOld);
            buf.put(this.m_abDelta);
        } else {
            buf.put(this.m_abDelta);
            buf.put(abValueOld);
        }
        this.m_abValue = buf.array();
        this.m_nFlag = holder.getFlag();
        return super.process(entry);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        int len = in.readInt();
        if (len > 0) {
            this.m_abDelta = new byte[len];
            in.readFully(this.m_abDelta);
        }
        this.m_fAppend = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        if (this.m_abDelta == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.m_abDelta.length);
            out.write(this.m_abDelta);
        }
        out.writeBoolean(this.m_fAppend);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_abDelta = in.readByteArray(10);
        this.m_fAppend = in.readBoolean(11);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeByteArray(10, this.m_abDelta);
        out.writeBoolean(11, this.m_fAppend);
    }
}

