/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.processor;

import com.tangosol.coherence.memcached.Response;
import com.tangosol.coherence.memcached.server.DataHolder;
import com.tangosol.coherence.memcached.server.MemcachedHelper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PutProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    protected byte[] m_abValue;
    protected int m_nFlag;
    protected long m_lVersion;
    protected int m_nExpiry;
    protected boolean m_fBinaryPassThru;

    public PutProcessor() {
    }

    public PutProcessor(byte[] abValue, int nFlag, long lVersion, int nExpiry, boolean fBinaryPassThru) {
        this.m_abValue = abValue;
        this.m_nFlag = nFlag;
        this.m_lVersion = lVersion;
        this.m_nExpiry = nExpiry;
        this.m_fBinaryPassThru = fBinaryPassThru;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        DataHolder oHolder;
        BinaryEntry binaryEntry = MemcachedHelper.getBinaryEntry(entry);
        Binary binValue = binaryEntry.getBinaryValue();
        BackingMapManagerContext ctxMgr = binaryEntry.getBackingMapContext().getManagerContext();
        long lVersion = this.m_lVersion;
        DataHolder dataHolder = oHolder = binValue != null ? MemcachedHelper.convertToDataHolder(binValue, ctxMgr, this.m_fBinaryPassThru) : null;
        if (lVersion != 0L) {
            if (oHolder == null) {
                return Response.ResponseCode.KEYNF;
            }
            if (oHolder.getVersion() != lVersion) {
                return Response.ResponseCode.KEYEXISTS;
            }
        }
        lVersion = oHolder != null ? oHolder.getVersion() + 1L : (lVersion = lVersion + 1L);
        binaryEntry.updateBinaryValue(this.getDecoratedBinary(ctxMgr, lVersion));
        if (this.m_nExpiry > 0) {
            binaryEntry.expire(this.m_nExpiry);
        }
        return lVersion;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int len = in.readInt();
        if (len > 0) {
            this.m_abValue = new byte[len];
            in.readFully(this.m_abValue);
        }
        this.m_nFlag = in.readInt();
        this.m_lVersion = in.readLong();
        this.m_nExpiry = in.readInt();
        this.m_fBinaryPassThru = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        if (this.m_abValue == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.m_abValue.length);
            out.write(this.m_abValue);
        }
        out.writeInt(this.m_nFlag);
        out.writeLong(this.m_lVersion);
        out.writeInt(this.m_nExpiry);
        out.writeBoolean(this.m_fBinaryPassThru);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_abValue = in.readByteArray(0);
        this.m_nFlag = in.readInt(1);
        this.m_lVersion = in.readLong(2);
        this.m_nExpiry = in.readInt(3);
        this.m_fBinaryPassThru = in.readBoolean(4);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeByteArray(0, this.m_abValue);
        out.writeInt(1, this.m_nFlag);
        out.writeLong(2, this.m_lVersion);
        out.writeInt(3, this.m_nExpiry);
        out.writeBoolean(4, this.m_fBinaryPassThru);
    }

    protected Binary getDecoratedBinary(BackingMapManagerContext mgrCtx, long lVersion) {
        Binary bin = this.m_fBinaryPassThru ? new Binary(this.m_abValue) : (Binary)mgrCtx.getValueToInternalConverter().convert(this.m_abValue);
        BinaryWriteBuffer bufDeco = new BinaryWriteBuffer(12, 12);
        try {
            WriteBuffer.BufferOutput out = bufDeco.getBufferOutput();
            out.writeInt(this.m_nFlag);
            out.writeLong(lVersion);
            return (Binary)mgrCtx.addInternalValueDecoration(bin, 13, bufDeco.toBinary());
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }
}

