/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.server;

import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.internal.net.socketbus.SharedBuffer;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.ByteSequence;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class DisposableReadBuffer
implements ReadBuffer,
Disposable {
    protected SharedBuffer.Segment[] m_aSegment;
    protected ReadBuffer m_delegate;

    public DisposableReadBuffer(SharedBuffer.Segment[] aSegment) {
        this.m_aSegment = aSegment;
        this.m_delegate = aSegment.length == 1 ? new ByteBufferReadBuffer(aSegment[0].get()) : new MultiBufferReadBuffer(DisposableReadBuffer.createReadBuffer(aSegment));
    }

    @Override
    public int length() {
        return this.m_delegate.length();
    }

    @Override
    public byte byteAt(int of) {
        return this.m_delegate.byteAt(of);
    }

    @Override
    public void copyBytes(int ofBegin, int ofEnd, byte[] abDest, int ofDest) {
        this.m_delegate.copyBytes(ofBegin, ofEnd, abDest, ofDest);
    }

    @Override
    public ReadBuffer.BufferInput getBufferInput() {
        return this.m_delegate.getBufferInput();
    }

    @Override
    public ReadBuffer getReadBuffer(int of, int cb) {
        return this.m_delegate.getReadBuffer(of, cb);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.m_delegate.writeTo(out);
    }

    @Override
    public void writeTo(OutputStream out, int of, int cb) throws IOException {
        this.m_delegate.writeTo(out, of, cb);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.m_delegate.writeTo(out);
    }

    @Override
    public void writeTo(DataOutput out, int of, int cb) throws IOException {
        this.m_delegate.writeTo(out, of, cb);
    }

    @Override
    public void writeTo(ByteBuffer buf) {
        this.m_delegate.writeTo(buf);
    }

    @Override
    public void writeTo(ByteBuffer buf, int of, int cb) throws IOException {
        this.m_delegate.writeTo(buf, of, cb);
    }

    @Override
    public byte[] toByteArray() {
        return this.m_delegate.toByteArray();
    }

    @Override
    public byte[] toByteArray(int of, int cb) {
        return this.m_delegate.toByteArray(of, cb);
    }

    @Override
    public Binary toBinary() {
        return this.m_delegate.toBinary();
    }

    @Override
    public Binary toBinary(int of, int cb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.m_delegate.toByteBuffer();
    }

    @Override
    public ByteBuffer toByteBuffer(int of, int cb) {
        return this.m_delegate.toByteBuffer(of, cb);
    }

    @Override
    public ByteSequence subSequence(int ofStart, int ofEnd) {
        return this.m_delegate.subSequence(ofStart, ofEnd);
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        SharedBuffer.Segment[] aSegment = this.m_aSegment;
        int c = aSegment.length;
        for (int i = 0; i < c; ++i) {
            aSegment[i].dispose();
        }
    }

    protected static ReadBuffer[] createReadBuffer(SharedBuffer.Segment[] aSegment) {
        int cSegments = aSegment.length;
        ReadBuffer[] aBuf = new ReadBuffer[cSegments];
        for (int i = 0; i < cSegments; ++i) {
            aBuf[i] = new ByteBufferReadBuffer(aSegment[i].get());
        }
        return aBuf;
    }
}

