/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.server;

import com.tangosol.coherence.memcached.server.DataHolder;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import java.io.IOException;
import java.util.Date;

public abstract class MemcachedHelper {
    protected static final int MAX_RELATIVE_EXPIRY_TIME = 2592000;
    protected static final String UTF8 = "utf-8";

    public static int calculateExpiry(int nExpiry) {
        return nExpiry <= 2592000 ? nExpiry * 1000 : Math.max(0, (int)(new Date(nExpiry).getTime() - System.currentTimeMillis()));
    }

    public static Binary decorateBinary(Binary bin, int nFlag, long lVersion) {
        BinaryWriteBuffer bufDeco = new BinaryWriteBuffer(12, 12);
        try {
            WriteBuffer.BufferOutput out = bufDeco.getBufferOutput();
            out.writeInt(nFlag);
            out.writeLong(lVersion);
            return ExternalizableHelper.decorate(bin, 13, bufDeco.toBinary());
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static DataHolder convertToDataHolder(Binary bin, BackingMapManagerContext mgrCtx, boolean fBinaryPassThru) {
        byte[] abValue = null;
        int nFlag = 0;
        long lVersion = 0L;
        try {
            if (ExternalizableHelper.isDecorated(bin, 13)) {
                Binary buffer = bin;
                ReadBuffer bufDeco = ExternalizableHelper.getDecoration((ReadBuffer)buffer, 13);
                ReadBuffer.BufferInput bufInput = bufDeco.getBufferInput();
                Binary binValue = (Binary)ExternalizableHelper.getUndecorated((ReadBuffer)buffer);
                nFlag = bufInput.readInt();
                lVersion = bufInput.readLong();
                abValue = fBinaryPassThru ? binValue.toByteArray() : (byte[])mgrCtx.getValueFromInternalConverter().convert(binValue);
            } else {
                abValue = bin.toByteArray();
            }
        }
        catch (IOException ioe) {
            throw Base.ensureRuntimeException(ioe);
        }
        return new DataHolder(abValue, nFlag, lVersion);
    }

    public static String getString(byte[] abValue) {
        try {
            return new String(abValue, UTF8);
        }
        catch (IOException ioe) {
            throw Base.ensureRuntimeException(ioe);
        }
    }

    public static BinaryEntry getBinaryEntry(InvocableMap.Entry entry) {
        try {
            return (BinaryEntry)entry;
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("The MemcachedAcceptor is only supported by the DistributedCache");
        }
    }
}

