/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.UtfConstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClassConstant
extends Constant
implements Constants {
    private static final String CLASS = "ClassConstant";
    private UtfConstant m_utf;
    private int m_iRef;

    protected ClassConstant() {
        super(7);
    }

    public ClassConstant(String sClass) {
        this(new UtfConstant(sClass.replace('.', '/')));
    }

    public ClassConstant(UtfConstant constant) {
        this();
        if (constant == null) {
            throw new IllegalArgumentException("ClassConstant:  Value cannot be null!");
        }
        this.m_utf = constant;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_iRef = stream.readUnsignedShort();
    }

    @Override
    protected void postdisassemble(ConstantPool pool) {
        UtfConstant constUtf = this.m_utf;
        if (constUtf == null) {
            constUtf = this.m_utf = (UtfConstant)pool.getConstant(this.m_iRef);
            constUtf.postdisassemble(pool);
        }
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_utf);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeShort(pool.findConstant(this.m_utf));
    }

    @Override
    public int compareTo(Object obj) {
        ClassConstant that = (ClassConstant)obj;
        return this.m_utf.compareTo(that.m_utf);
    }

    @Override
    public String toString() {
        return "(Class)->" + (this.m_utf == null ? "[" + this.m_iRef + ']' : this.m_utf.toString());
    }

    @Override
    public String format() {
        String sClass = this.m_utf.format();
        return sClass.replace('/', '.');
    }

    @Override
    public boolean equals(Object obj) {
        try {
            ClassConstant that = (ClassConstant)obj;
            return this == that || this.getClass() == that.getClass() && this.m_utf.equals(that.m_utf);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getJavaName() {
        return this.m_utf.getValue().replace('/', '.');
    }

    public String getValue() {
        return this.m_utf.getValue();
    }

    public UtfConstant getValueConstant() {
        return this.m_utf;
    }
}

