/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConstantValueAttribute
extends Attribute
implements Constants {
    private static final String CLASS = "ConstantValueAttribute";
    private Constant m_constant;
    private boolean m_fModified;

    protected ConstantValueAttribute(VMStructure context) {
        super(context, "ConstantValue");
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        this.m_constant = pool.getConstant(stream.readUnsignedShort());
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(super.getNameConstant());
        pool.registerConstant(this.m_constant);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        stream.writeInt(2);
        stream.writeShort(pool.findConstant(this.m_constant));
    }

    @Override
    public boolean isModified() {
        return this.m_fModified;
    }

    @Override
    protected void resetModified() {
        this.m_fModified = false;
    }

    @Override
    public String toString() {
        return super.getName() + '=' + this.m_constant.toString();
    }

    @Override
    public boolean equals(Object obj) {
        try {
            ConstantValueAttribute that = (ConstantValueAttribute)obj;
            return this == that || this.getClass() == that.getClass() && this.m_constant.equals(that.m_constant);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public Constant getConstant() {
        return this.m_constant;
    }

    public void setConstant(Constant constant) {
        this.m_constant = constant;
        this.m_fModified = true;
    }
}

