/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DoubleConstant
extends Constant
implements Constants {
    private static final String CLASS = "DoubleConstant";
    private double m_dflVal;

    protected DoubleConstant() {
        super(6);
    }

    public DoubleConstant(double dflVal) {
        this();
        this.m_dflVal = dflVal;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_dflVal = stream.readDouble();
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeDouble(this.m_dflVal);
    }

    @Override
    public int compareTo(Object obj) {
        DoubleConstant that = (DoubleConstant)obj;
        double dflThis = this.m_dflVal;
        double dflThat = that.m_dflVal;
        return dflThis < dflThat ? -1 : (dflThis > dflThat ? 1 : 0);
    }

    @Override
    public String toString() {
        return "(Double) " + this.m_dflVal;
    }

    @Override
    public String format() {
        return String.valueOf(this.m_dflVal);
    }

    @Override
    public boolean equals(Object obj) {
        try {
            DoubleConstant that = (DoubleConstant)obj;
            return this == that || this.getClass() == that.getClass() && this.m_dflVal == that.m_dflVal;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public double getValue() {
        return this.m_dflVal;
    }
}

