/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.InterfaceConstant;
import com.tangosol.dev.assembler.Method;
import com.tangosol.dev.assembler.OpConst;
import com.tangosol.dev.assembler.OpDeclare;
import java.io.DataOutput;
import java.io.IOException;

public class Invokeinterface
extends OpConst
implements Constants {
    private static final String CLASS = "Invokeinterface";

    public Invokeinterface(InterfaceConstant constant) {
        super(185, constant);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        InterfaceConstant constant = (InterfaceConstant)super.getConstant();
        String[] asType = Method.toTypes(constant.getType());
        int cTypes = asType.length;
        int cArgs = 1;
        for (int i = 1; i < cTypes; ++i) {
            char chType = asType[i].charAt(0);
            cArgs += OpDeclare.getJavaWidth(chType);
        }
        stream.writeByte(185);
        stream.writeShort(pool.findConstant(constant));
        stream.writeByte(cArgs);
        stream.writeByte(0);
    }

    @Override
    protected void calculateSize(ConstantPool pool) {
        this.setSize(5);
    }

    @Override
    public int getStackChange() {
        InterfaceConstant constant = (InterfaceConstant)this.getConstant();
        return -1 - constant.getTotalParameterSize() + constant.getVariableSize(0);
    }
}

