/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Ishr;
import com.tangosol.dev.assembler.L2i;
import com.tangosol.dev.assembler.Lshr;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.ShiftExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.util.ErrorList;

public class RightShiftExpression
extends ShiftExpression {
    private static final String CLASS = "RightShiftExpression";

    public RightShiftExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant()) {
            return super.compile(ctx, code, fReached, errlist);
        }
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        left.compile(ctx, code, fReached, errlist);
        right.compile(ctx, code, fReached, errlist);
        if (right.getType() == LONG) {
            code.add(new L2i());
        }
        if (left.getType() == LONG) {
            code.add(new Lshr());
        } else {
            code.add(new Ishr());
        }
        return fReached;
    }

    @Override
    public Object getValue() {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        Number nbrLeft = (Number)left.getValue();
        Number nbrRight = (Number)right.getValue();
        switch (left.getType().getTypeString().charAt(0)) {
            case 'I': {
                return nbrLeft.intValue() >> nbrRight.intValue();
            }
            case 'J': {
                return nbrLeft.longValue() >> nbrRight.intValue();
            }
        }
        throw new IllegalStateException();
    }
}

