/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.SyntaxException;
import com.tangosol.dev.compiler.java.Constants;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TokenConstants;
import com.tangosol.dev.compiler.java.Tokenizer;
import com.tangosol.util.Base;
import com.tangosol.util.ErrorList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class ScriptParser
extends Base
implements Constants,
TokenConstants {
    private static final String CLASS = "ScriptParser";
    private static final boolean DEBUG = "JAVA.PARSER".equalsIgnoreCase(System.getProperty("DEBUG"));
    public static final String STATIC_INIT = "<clinit>()";
    public static final String IMPORTS = "_imports()";
    protected static final Properties OPTIONS = new Properties();
    protected Tokenizer m_toker;
    protected Token m_token;
    protected String[] m_asLines;
    protected Map m_map;
    protected Map m_mapParam;
    protected String m_sPackage;
    protected String m_sImports;
    protected Stack m_stackClass = new Stack();

    protected void init() {
        this.m_toker = null;
        this.m_token = null;
        this.m_asLines = null;
        this.m_map = new HashMap();
        this.m_mapParam = new HashMap();
        this.m_sPackage = null;
        this.m_sImports = null;
        this.m_stackClass = new Stack();
    }

    public synchronized Map parse(String sScript) {
        return this.parse(sScript, null);
    }

    public synchronized Map parse(String sScript, Map mapParam) {
        block4: {
            this.init();
            if (mapParam != null) {
                this.m_mapParam = mapParam;
            }
            if (sScript == null) {
                throw new IllegalArgumentException("ScriptParser.compile:  Script required!");
            }
            sScript = ScriptParser.replace(sScript, "\r\n", "\n");
            sScript = sScript.replace('\r', '\n');
            this.m_asLines = ScriptParser.parseDelimitedString(sScript, '\n');
            try {
                this.m_toker = new Tokenizer(sScript, new ErrorList(), OPTIONS);
                this.m_token = this.next();
                this.parseCompilationUnit();
            }
            catch (Exception e) {
                if (!DEBUG) break block4;
                ScriptParser.err("An exception occurred parsing the .java file:");
                ScriptParser.err(e);
            }
        }
        return this.m_map;
    }

    public static void main(String[] asArgs) {
        try {
            InputStream stream;
            String sClass = asArgs[0];
            ClassLoader loader = Class.forName(sClass).getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if ((stream = loader.getResourceAsStream(sClass.replace('.', '/') + ".java")) == null) {
                ScriptParser.out("No source for: " + sClass);
                return;
            }
            byte[] ab = new byte[1000000];
            int cb = ScriptParser.read(stream, ab);
            stream.close();
            String sScript = new String(ab, 0, cb);
            Map map = new ScriptParser().parse(sScript);
            for (Map.Entry entry : map.entrySet()) {
                ScriptParser.out();
                ScriptParser.out(entry.getKey());
                ScriptParser.out("    {");
                ScriptParser.out(ScriptParser.indentString((String)entry.getValue(), "    "));
                ScriptParser.out("    }");
            }
        }
        catch (Exception e) {
            ScriptParser.out("Exception occurred in test: " + e);
            ScriptParser.out(e);
        }
    }

    protected void parseCompilationUnit() throws CompilerException {
        String sPackage = this.parsePackageDeclaration();
        this.m_sPackage = sPackage.length() == 0 ? "" : sPackage + '.';
        String sImports = this.parseImportDeclarations();
        if (sImports.length() > 0) {
            this.m_sImports = sImports;
        }
        this.parseTypeDeclarations();
    }

    protected String parsePackageDeclaration() throws CompilerException {
        String sPackage = "";
        if (this.peek(31) != null) {
            sPackage = this.parseQualifiedName();
            this.match(56);
        }
        return sPackage;
    }

    protected String parseImportDeclarations() throws CompilerException {
        Token tokMark = this.mark();
        while (this.peek(24) != null) {
            this.parseQualifiedName(true);
            this.match(56);
        }
        return this.snip(tokMark, this.mark());
    }

    protected String parseQualifiedName() throws CompilerException {
        return this.parseQualifiedName(false);
    }

    protected String parseQualifiedName(boolean fAllowStar) throws CompilerException {
        Token tokName;
        StringBuffer sb = new StringBuffer();
        boolean fFirst = true;
        do {
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append('.');
            }
            tokName = null;
            if (fAllowStar) {
                tokName = this.peek(61);
            }
            if (tokName == null) {
                tokName = this.match(105);
            }
            sb.append(tokName.getText());
        } while (tokName.id != 61 && this.peek(58) != null);
        return sb.toString();
    }

    protected void parseTypeDeclarations() throws CompilerException {
        while (this.hasCurrent()) {
            if (this.peek(56) != null) continue;
            this.parseClassOrInterfaceDeclaration();
        }
    }

    protected void parseClassOrInterfaceDeclaration() throws CompilerException {
        this.parseModifiers();
        switch (this.m_token.id) {
            case 9: {
                this.match(9);
                Token tokName = this.match(105);
                if (this.peek(16) != null) {
                    this.parseQualifiedName();
                }
                if (this.peek(23) != null) {
                    do {
                        this.parseQualifiedName();
                    } while (this.peek(57) != null);
                }
                this.parseClassOrInterfaceBody(tokName);
                break;
            }
            case 27: {
                this.match(27);
                Token tokName = this.match(105);
                if (this.peek(16) != null) {
                    do {
                        this.parseQualifiedName();
                    } while (this.peek(57) != null);
                }
                this.parseClassOrInterfaceBody(tokName);
                break;
            }
            default: {
                throw new SyntaxException();
            }
        }
    }

    protected void parseModifiers() throws CompilerException {
        block3: while (true) {
            switch (this.m_token.id) {
                case 1: 
                case 17: 
                case 29: 
                case 32: 
                case 33: 
                case 34: 
                case 37: 
                case 38: 
                case 41: 
                case 45: 
                case 48: {
                    this.next();
                    continue block3;
                }
            }
            break;
        }
    }

    protected void parseClassOrInterfaceBody(Token tokName) throws CompilerException {
        Stack stack = this.m_stackClass;
        stack.push(tokName.getText());
        try {
            if (this.m_sImports != null) {
                this.setScript(IMPORTS, this.m_sImports);
            }
            this.match(52);
            block10: while (true) {
                switch (this.m_token.id) {
                    case 56: {
                        this.next();
                        continue block10;
                    }
                    case 52: {
                        this.parseStatic();
                        continue block10;
                    }
                    case 37: {
                        if (this.next().id == 52) {
                            this.parseStatic();
                        }
                    }
                    case 1: 
                    case 17: 
                    case 29: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 38: 
                    case 41: 
                    case 45: 
                    case 48: {
                        this.parseModifiers();
                    }
                    case 3: 
                    case 5: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 36: 
                    case 47: 
                    case 105: {
                        this.parseMember();
                        continue block10;
                    }
                }
                break;
            }
            this.match(53);
        }
        finally {
            stack.pop();
        }
    }

    protected void parseStatic() throws CompilerException {
        String sScript = this.parseMethodBody();
        this.addStatic(sScript);
    }

    protected void parseMember() throws CompilerException {
        switch (this.m_token.id) {
            case 105: {
                Token tokType = this.current();
                if (this.m_token.id == 50) {
                    this.parseMethodDeclaratorRest("<init>");
                    break;
                }
                while (this.peek(58) != null) {
                    tokType = this.match(105);
                }
                while (this.peek(54) != null) {
                    this.match(55);
                }
                Token tokName = this.match(105);
                if (this.m_token.id == 50) {
                    this.parseMethodDeclaratorRest(tokName.getText());
                    break;
                }
                while (this.current().id != 56) {
                }
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 14: 
            case 19: 
            case 26: 
            case 28: 
            case 36: {
                Token tokType = this.current();
                while (this.peek(54) != null) {
                    this.match(55);
                }
                Token tokName = this.match(105);
                if (this.m_token.id == 50) {
                    this.parseMethodDeclaratorRest(tokName.getText());
                    break;
                }
                while (this.current().id != 56) {
                }
                break;
            }
            case 47: {
                Token tokType = this.current();
                Token tokName = this.match(105);
                this.parseMethodDeclaratorRest(tokName.getText());
                break;
            }
            case 9: 
            case 27: {
                this.parseClassOrInterfaceDeclaration();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String parseMethodBody() throws CompilerException {
        this.match(52);
        Token tokStart = this.mark();
        int cDepth = 1;
        while (true) {
            Token tok = this.current();
            switch (tok.id) {
                case 52: {
                    ++cDepth;
                    break;
                }
                case 53: {
                    if (--cDepth != 0) break;
                    Token tokBeyondEnd = tok;
                    return this.snip(tokStart, tokBeyondEnd);
                }
            }
        }
    }

    protected void parseMethodDeclaratorRest(String sMethod) throws CompilerException {
        ArrayList<String> listParam = new ArrayList<String>();
        StringBuffer sb = new StringBuffer(sMethod);
        sb.append('(');
        this.match(50);
        boolean fFirst = true;
        block4: while (true) {
            String sType;
            this.peek(17);
            switch (this.m_token.id) {
                case 105: {
                    sType = this.current().getText();
                    while (this.peek(58) != null) {
                        sType = this.current().getText();
                    }
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 14: 
                case 19: 
                case 26: 
                case 28: 
                case 36: {
                    sType = this.current().getText();
                    break;
                }
                default: {
                    break block4;
                }
            }
            while (this.peek(54) != null) {
                this.match(55);
                sType = sType + "[]";
            }
            listParam.add(this.match(105).getText());
            while (this.peek(54) != null) {
                this.match(55);
                sType = sType + "[]";
            }
            int of = sType.lastIndexOf(36);
            if (of >= 0) {
                sType = sType.substring(of + 1);
            }
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(sType);
            this.peek(57);
        }
        this.match(51);
        sb.append(')');
        String sSig = sb.toString();
        String[] asParam = listParam.toArray(new String[listParam.size()]);
        this.setParams(sSig, asParam);
        while (this.peek(54) != null) {
            this.match(55);
        }
        if (this.peek(44) != null) {
            while (this.m_token.id == 105) {
                this.parseQualifiedName();
                this.peek(57);
            }
        }
        if (this.peek(56) == null) {
            String sScript = this.parseMethodBody();
            this.setScript(sSig, sScript);
        }
    }

    String getClassName() {
        Stack stack = this.m_stackClass;
        ScriptParser.azzert(!stack.isEmpty());
        StringBuffer sb = new StringBuffer(this.m_sPackage);
        int c = stack.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append('$');
            }
            sb.append((String)stack.get(i));
        }
        return sb.toString();
    }

    void addStatic(String sScript) {
        String sOrig = this.getScript(STATIC_INIT);
        if (sOrig == null) {
            this.setScript(STATIC_INIT, sScript);
        } else {
            this.setScript(STATIC_INIT, sOrig + '\n' + sScript);
        }
    }

    String getScript(String sSig) {
        String sKey = this.getClassName() + '.' + sSig;
        return (String)this.m_map.get(sKey);
    }

    void setScript(String sSig, String sScript) {
        String sKey = this.getClassName() + '.' + sSig;
        this.m_map.put(sKey, sScript);
    }

    String[] getParams(String sSig) {
        String sKey = this.getClassName() + '.' + sSig;
        return (String[])this.m_mapParam.get(sKey);
    }

    void setParams(String sSig, String[] asParam) {
        String sKey = this.getClassName() + '.' + sSig;
        this.m_mapParam.put(sKey, asParam);
    }

    protected boolean hasCurrent() {
        return this.m_token != null;
    }

    protected Token current() throws CompilerException {
        Token current = this.m_token;
        this.next();
        return current;
    }

    protected boolean hasNext() {
        return this.m_toker.hasMoreTokens();
    }

    protected Token next() throws CompilerException {
        Tokenizer toker = this.m_toker;
        if (toker.hasMoreTokens()) {
            this.m_token = (Token)toker.nextToken();
            return this.m_token;
        }
        if (this.m_token == null) {
            throw new CompilerException();
        }
        this.m_token = null;
        return null;
    }

    protected Token match(int id) throws CompilerException {
        if (this.m_token.id != id) {
            throw new SyntaxException();
        }
        return this.current();
    }

    protected Token peek(int id) throws CompilerException {
        return this.m_token.id == id ? this.current() : null;
    }

    protected Token peek(int cat, int subcat) throws CompilerException {
        Token token = this.m_token;
        return token.cat == cat && token.subcat == subcat ? this.current() : null;
    }

    protected Token mark() {
        return this.m_token;
    }

    protected String snip(Token tokStart, Token tokBeyondEnd) {
        int ofStart;
        if (tokStart == tokBeyondEnd) {
            return "";
        }
        String[] asLines = this.m_asLines;
        int iStart = tokStart.getLine();
        int iEnd = tokBeyondEnd.getLine();
        int ofEnd = tokBeyondEnd.getOffset();
        if (iStart == iEnd) {
            String sLine = asLines[iStart];
            String sScript = sLine.substring(ofStart, ofEnd).trim();
            return sScript;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (ofStart > 0) {
            char ch;
            String sLine = asLines[iStart];
            for (ofStart = tokStart.getOffset(); ofStart > 0 && ((ch = sLine.charAt(ofStart - 1)) == ' ' || ch == '\t'); --ofStart) {
            }
        }
        list.add(asLines[iStart].substring(ofStart));
        for (int i = iStart + 1; i < iEnd; ++i) {
            list.add(asLines[i]);
        }
        if (ofEnd > 0) {
            list.add(asLines[iEnd].substring(0, ofEnd));
        }
        while (((String)list.get(0)).trim().length() == 0) {
            list.remove(0);
        }
        if (list.size() == 0) {
            return "";
        }
        while (((String)list.get(list.size() - 1)).trim().length() == 0) {
            list.remove(list.size() - 1);
        }
        int ofIndent = -1;
        int c = list.size();
        for (int i = 0; i < c; ++i) {
            String sLine = (String)list.get(i);
            if (sLine.trim().length() == 0) {
                list.set(i, "");
                continue;
            }
            if (sLine.indexOf(9) != -1) {
                sLine = ScriptParser.replace(sLine, "\t", "        ");
                list.set(i, sLine);
            }
            if (sLine.charAt(0) == ' ') {
                char[] ach = sLine.toCharArray();
                int cSpaces = 0;
                int cch = ach.length;
                for (int of = 0; of < cch && ach[of] == ' '; ++of) {
                    ++cSpaces;
                }
                if (ofIndent != -1 && cSpaces >= ofIndent) continue;
                ofIndent = cSpaces;
                continue;
            }
            ofIndent = 0;
        }
        StringBuffer sb = new StringBuffer();
        int c2 = list.size();
        for (int i = 0; i < c2; ++i) {
            String sLine = (String)list.get(i);
            if (i > 0) {
                sb.append('\n');
            }
            if (sLine.length() <= 0) continue;
            if (ofIndent > 0) {
                sLine = sLine.substring(ofIndent);
            }
            sb.append(sLine);
        }
        return sb.toString();
    }

    static {
        OPTIONS.put("java.tokenizer.comments", "true");
        OPTIONS.put("java.tokenizer.extensions", "false");
    }
}

