/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.component.Behavior;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.DataType;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.Trait;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ErrorList;
import java.beans.PropertyVetoException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class Throwee
extends Trait {
    public static final String ATTR_FROMMANUAL = "FromManual";
    public static final String ATTR_DATATYPE = "DataType";
    private static final String CLASS = "Throwee";
    protected static final String DESCRIPTOR = "Exception";
    private static final int SPECABLE_FLAGS = 1;
    private DataType m_dt;
    private int m_nFlags;

    protected Throwee(Behavior behavior, DataType dt) {
        super((Trait)behavior, 1);
        if (behavior == null) {
            throw new IllegalArgumentException("Throwee:  Containing behavior required.");
        }
        if (dt == null || !dt.isClass()) {
            throw new IllegalArgumentException("Throwee:  Illegal Throwee DataType (" + dt + ")");
        }
        this.m_dt = dt;
        this.m_nFlags = 2;
        if (!behavior.getComponent().isSignature()) {
            this.assignUID();
        }
    }

    protected Throwee(Throwee base, Behavior behavior, int nMode) {
        super((Trait)base, behavior, nMode);
        this.m_dt = base.m_dt;
        this.m_nFlags = 0;
    }

    protected Throwee(Behavior behavior, Throwee that) {
        super((Trait)behavior, that);
        this.m_dt = that.m_dt;
        this.m_nFlags = that.m_nFlags;
    }

    protected Throwee(Behavior behavior, DataInput stream, int nVersion) throws IOException {
        super((Trait)behavior, stream, nVersion);
        this.m_nFlags = stream.readInt();
        this.m_dt = DataType.getType(stream.readUTF());
    }

    protected Throwee(Trait parent, XmlElement xml, int nVersion) throws IOException {
        super(parent, xml, nVersion);
        String sType = Throwee.readString(xml.getElement("type"));
        if (sType == "") {
            throw new IOException("type is missing");
        }
        int nFlags = Throwee.readFlags(xml, "flags", 0);
        this.m_dt = DataType.getType(sType);
        this.m_nFlags = nFlags;
    }

    @Override
    protected synchronized void save(DataOutput stream) throws IOException {
        super.save(stream);
        stream.writeInt(this.m_nFlags);
        stream.writeUTF(this.m_dt.getTypeString());
    }

    @Override
    protected synchronized void save(XmlElement xml) throws IOException {
        xml.addElement("type").setString(this.m_dt.getTypeString());
        super.save(xml);
        Throwee.saveFlags(xml, "flags", this.m_nFlags, 0);
    }

    @Override
    protected Trait getBlankDerivedTrait(Trait parent, int nMode) {
        return new Throwee(this, (Behavior)parent, nMode);
    }

    @Override
    protected Trait resolve(Trait traitDelta, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        int nDeltaFlags;
        Throwee base = this;
        Throwee delta = (Throwee)this.resolveDelta(traitDelta, loader, errlist);
        Throwee derived = (Throwee)super.resolve(delta, parent, loader, errlist);
        int nBaseFlags = base.m_nFlags;
        int nDerivedFlags = nDeltaFlags = delta.m_nFlags;
        if (base.getMode() == 1) {
            int nBaseExists = nBaseFlags & 6;
            if (nBaseExists == 4 || nBaseExists == 6) {
                nDerivedFlags = 6;
            } else if ((nDeltaFlags & 1) == 0) {
                nDerivedFlags = 0;
            }
        } else if ((nDeltaFlags & 1) == 0 && (nBaseFlags & 1) != 0) {
            nDerivedFlags = nBaseFlags;
        }
        derived.m_nFlags = nDerivedFlags;
        if (delta.m_dt != base.m_dt) {
            Object[] aoParam = new Object[]{base.getBehavior().toString(), delta.m_dt.toString(), base.m_dt.toString(), derived.toPathString()};
            this.logError("RES-501", 2, aoParam, errlist);
        }
        derived.m_dt = base.m_dt;
        return derived;
    }

    @Override
    protected void finalizeResolve(Loader loader, ErrorList errlist) throws ComponentException {
        super.finalizeResolve(loader, errlist);
        this.m_nFlags &= 0xFFFFFFFE;
        if (this.isDeclaredAtThisLevel() && this.m_nFlags != 4) {
            this.m_nFlags = 2;
        }
    }

    @Override
    protected Trait extract(Trait traitBase, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Throwee derived = this;
        Throwee base = (Throwee)traitBase;
        Throwee delta = (Throwee)super.extract(base, parent, loader, errlist);
        delta.m_nFlags = !((derived.m_nFlags & 6) != 4 || base.m_nFlags != 2 && base.m_nFlags != 0 || base.getMode() != 1 && (derived.m_nFlags & 1) == 0) ? 5 : 0;
        if (derived.m_dt != base.m_dt) {
            Object[] aoParam = new Object[]{base.getBehavior().toString(), derived.m_dt.toString(), base.m_dt.toString(), derived.toPathString()};
            this.logError("EXT-501", 2, aoParam, errlist);
        }
        delta.m_dt = base.m_dt;
        return delta;
    }

    @Override
    protected boolean isDiscardable() {
        int nMode = this.getMode();
        if ((nMode == 2 || nMode == 3) && (this.m_nFlags & 1) != 0) {
            return false;
        }
        return super.isDiscardable();
    }

    @Override
    protected boolean isClassDiscardable(Trait base) {
        Throwee that = (Throwee)base;
        if (that == null || !this.isFromSuper()) {
            return false;
        }
        int nExistsThis = this.m_nFlags & 6;
        int nExistsThat = that.m_nFlags & 6;
        if (nExistsThis != nExistsThat) {
            boolean fThatThrowable;
            boolean fThisThrowable = nExistsThis == 2 || nExistsThis == 0;
            boolean bl = fThatThrowable = nExistsThat == 2 || nExistsThat == 0;
            if (fThisThrowable != fThatThrowable) {
                return false;
            }
        }
        return super.isClassDiscardable(base);
    }

    @Override
    protected synchronized void invalidate() {
        super.invalidate();
        this.m_dt = null;
    }

    @Override
    protected String getUniqueName() {
        return this.m_dt.getClassName();
    }

    @Override
    protected String getUniqueDescription() {
        return "Exception " + this.getUniqueName();
    }

    public Behavior getBehavior() {
        return (Behavior)this.getParentTrait();
    }

    protected int getExists() {
        return this.m_nFlags;
    }

    protected synchronized void setExists(int nExists) {
        this.m_nFlags = nExists & 6;
    }

    public boolean isFromImplements() {
        return this.isFromTraitDescriptor("Implements");
    }

    public Enumeration enumImplements() {
        return this.getOriginTraits("Implements");
    }

    public boolean isFromDispatches() {
        return this.isFromTraitDescriptor("Dispatches");
    }

    public Enumeration enumDispatches() {
        return this.getOriginTraits("Dispatches");
    }

    public boolean isFromIntegration() {
        return this.isFromTraitDescriptor("Integration");
    }

    public boolean isFromProperty() {
        return this.isFromTraitDescriptor("Property");
    }

    public boolean isFromManualSettable() {
        return this.isDeclaredAtThisLevel() && this.isFromNonManual() && this.isModifiable();
    }

    public void setFromManual(boolean fManual) throws PropertyVetoException {
        this.setFromManual(fManual, true);
    }

    protected synchronized void setFromManual(boolean fManual, boolean fVetoable) throws PropertyVetoException {
        boolean fPrev = this.isFromManual();
        if (fManual == fPrev) {
            return;
        }
        Boolean prev = Throwee.toBoolean(fPrev);
        Boolean value = Throwee.toBoolean(fManual);
        if (fVetoable) {
            if (!this.isFromManualSettable()) {
                this.readOnlyAttribute(ATTR_FROMMANUAL, prev, value);
            }
            this.fireVetoableChange(ATTR_FROMMANUAL, prev, value);
        }
        if (fManual) {
            this.setFromManual();
        } else {
            this.clearFromManual();
        }
        this.firePropertyChange(ATTR_FROMMANUAL, prev, value);
    }

    public boolean isThrowable() {
        int nExists = this.getExists();
        return nExists == 2 || nExists == 0;
    }

    public DataType getDataType() {
        return this.m_dt;
    }

    public boolean isDataTypeSettable() {
        return this.isModifiable() && !this.isFromNonManual();
    }

    public boolean isDataTypeLegal(DataType dt) {
        if (dt == null || !dt.isClass()) {
            return false;
        }
        if (dt == this.m_dt) {
            return true;
        }
        Throwee except = this.getBehavior().getException(dt.getClassName());
        return except == null || except == this;
    }

    public void setDataType(DataType dt) throws PropertyVetoException {
        this.setDataType(dt, true);
    }

    protected synchronized void setDataType(DataType dt, boolean fVetoable) throws PropertyVetoException {
        DataType dtPrev = this.m_dt;
        if (dt == dtPrev) {
            return;
        }
        if (fVetoable) {
            if (!this.isDataTypeSettable()) {
                this.readOnlyAttribute(ATTR_DATATYPE, dtPrev, dt);
            }
            if (!this.isDataTypeLegal(dt)) {
                this.illegalAttributeValue(ATTR_DATATYPE, dtPrev, dt);
            }
            this.fireVetoableChange(ATTR_DATATYPE, dtPrev, dt);
        }
        this.m_dt = dt;
        this.getBehavior().renameException(dtPrev.getClassName(), dt.getClassName());
        this.firePropertyChange(ATTR_DATATYPE, dtPrev, dt);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Throwee) {
            Throwee that = (Throwee)obj;
            return this == that || this.m_nFlags == that.m_nFlags && this.m_dt == that.m_dt && super.equals(that);
        }
        return false;
    }

    @Override
    public void dump(PrintWriter out, String sIndent) {
        boolean fDerOrMod = this.getMode() == 3 || this.getMode() == 2;
        out.println(sIndent + "Exception " + (this.m_dt == null ? "<null>" : this.m_dt.toString()));
        out.print(sIndent + "flags=0x" + Integer.toHexString(this.m_nFlags));
        out.println(" (" + Throwee.flagsDescription(this.m_nFlags, 1, fDerOrMod) + ')');
        super.dump(out, sIndent);
    }
}

