/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.disassembler;

import com.tangosol.dev.disassembler.Constant;
import com.tangosol.dev.disassembler.UtfConstant;
import java.io.DataInput;
import java.io.IOException;

public class Attribute {
    private int m_iName;
    private int m_cb;
    private byte[] m_ab;
    private Constant[] m_aconst;

    public static Attribute[] readAttributes(DataInput stream, Constant[] aconst) throws IOException {
        int cAttr = stream.readUnsignedShort();
        Attribute[] aAttr = new Attribute[cAttr];
        for (int i = 0; i < cAttr; ++i) {
            aAttr[i] = new Attribute(stream, aconst);
        }
        return aAttr;
    }

    public Attribute(DataInput stream, Constant[] aconst) throws IOException {
        this.m_iName = stream.readUnsignedShort();
        this.m_cb = stream.readInt();
        this.m_ab = new byte[this.m_cb];
        if (this.m_cb > 0) {
            stream.readFully(this.m_ab);
        }
        this.m_aconst = aconst;
    }

    public int getNameIndex() {
        return this.m_iName;
    }

    public String getName() {
        return ((UtfConstant)this.m_aconst[this.m_iName]).getText();
    }

    public byte[] getInfo() {
        return this.m_ab;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Attribute \"").append(this.getName()).append("\":  ").append(this.m_ab.length == 0 ? "<empty>" : "length=" + this.m_ab.length);
        return sb.toString();
    }
}

