/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.disassembler;

import java.io.ByteArrayInputStream;

class MarkedByteArrayInputStream
extends ByteArrayInputStream {
    protected int posPrev;
    protected int posStart;

    public MarkedByteArrayInputStream(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public MarkedByteArrayInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
        this.posPrev = this.pos;
        this.posStart = offset;
    }

    public int getMarkedOffset() {
        return this.posPrev - this.posStart;
    }

    public int getCurrentOffset() {
        return this.pos - this.posStart;
    }

    public byte[] getMarkedBytes() {
        int cb = this.pos - this.posPrev;
        byte[] ab = new byte[cb];
        System.arraycopy(this.buf, this.posPrev, ab, 0, cb);
        this.posPrev = this.pos;
        return ab;
    }
}

