/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.introspect;

import com.tangosol.dev.introspect.ResourceDiscoverer;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.util.Base;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractFilteredResourceDiscoverer<T>
implements ResourceDiscoverer<T>,
Filter,
ClassLoaderAware {
    protected ClassLoader m_loader;

    public boolean evaluate(Object o) {
        String sValue = o instanceof String ? (String)o : (o instanceof URL ? ((URL)o).getProtocol() : null);
        return sValue != null && this.getPermittedProtocols().contains(sValue);
    }

    @Override
    public Enumeration<URL> discover(String sExpression, T root) {
        return AbstractFilteredResourceDiscoverer.toURLs(this.discoverResource(sExpression, root));
    }

    @Override
    public Enumeration<URL> discover(String sExpression, Set<T> setRoot) {
        Collection<URI> colResults;
        if (setRoot == null || setRoot.isEmpty()) {
            colResults = this.discoverResource(sExpression, null);
        } else {
            colResults = new HashSet<URI>();
            for (T root : setRoot) {
                Collection<URI> colResult = this.discoverResource(sExpression, root);
                if (colResult == null || colResult.size() <= 0) continue;
                colResults.addAll(colResult);
            }
        }
        return AbstractFilteredResourceDiscoverer.toURLs(colResults);
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.m_loader == null ? (this.m_loader = Base.getContextClassLoader()) : this.m_loader;
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    protected abstract Set<String> getPermittedProtocols();

    public abstract Collection<URI> discoverResource(String var1, T var2);

    protected static Enumeration<URL> toURLs(Collection<URI> colURI) {
        return colURI == null || colURI.isEmpty() ? Collections.emptyEnumeration() : Collections.enumeration(ConverterCollections.getCollection(colURI, AbstractFilteredResourceDiscoverer::toURL, AbstractFilteredResourceDiscoverer::toURI));
    }

    protected static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    protected static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

