/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.introspect;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.dev.introspect.AbstractFilteredResourceDiscoverer;
import com.tangosol.dev.introspect.ResourceDiscoverer;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.SimpleEnumerator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class ClassPathResourceDiscoverer
extends AbstractFilteredResourceDiscoverer<String> {
    protected Set<String> m_setFileTypes = new HashSet<String>(Arrays.asList("class"));
    protected List<ResourceDiscoverer<URL>> m_listDiscoverers = new ArrayList<ResourceDiscoverer<URL>>(2);

    public ClassPathResourceDiscoverer() {
        this(null, null);
    }

    public ClassPathResourceDiscoverer(Set<String> setFileTypes, List<ResourceDiscoverer<URL>> listDiscoverers) {
        this.m_listDiscoverers = listDiscoverers == null ? this.m_listDiscoverers : listDiscoverers;
        this.m_setFileTypes = setFileTypes == null ? this.m_setFileTypes : setFileTypes;
        this.initialize();
    }

    @Override
    public Collection<URI> discoverResource(String sDiscriminator, String sExpression) {
        sExpression = sExpression == null ? "" : sExpression;
        HashSet<URI> setResources = new HashSet<URI>();
        String sAppendExpr = this.buildFileTypeExpression();
        try {
            Enumeration<URL> enumResources = this.findUrls(sDiscriminator, sExpression);
            while (enumResources.hasMoreElements()) {
                URL url = enumResources.nextElement();
                for (ResourceDiscoverer<URL> discoverer : this.getDiscovererChain()) {
                    if (discoverer instanceof Filter && !((Filter)((Object)discoverer)).evaluate(url)) continue;
                    Enumeration<URL> enumStringPaths = discoverer.discover(".*" + sExpression + ".*" + sAppendExpr, url);
                    while (enumStringPaths != null && enumStringPaths.hasMoreElements()) {
                        URI uri = ClassPathResourceDiscoverer.toURI(enumStringPaths.nextElement());
                        if (uri == null) continue;
                        setResources.add(uri);
                    }
                }
            }
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        return setResources;
    }

    @Override
    protected Set<String> getPermittedProtocols() {
        return new HashSet<String>();
    }

    protected String buildFileTypeExpression() {
        Set<String> setFileTypes = this.m_setFileTypes;
        StringBuilder sbldrExpr = new StringBuilder("(");
        Iterator<String> iterFileTypes = setFileTypes.iterator();
        while (iterFileTypes.hasNext()) {
            String sFileType = iterFileTypes.next();
            sbldrExpr.append("\\.").append(sFileType).append(iterFileTypes.hasNext() ? "|" : ")$");
        }
        return sbldrExpr.length() == 1 ? "" : sbldrExpr.toString();
    }

    protected Enumeration<URL> findUrls(String sDiscriminator, String sExpression) throws IOException {
        return this.getContextClassLoader().getResources(sDiscriminator == null || sDiscriminator.isEmpty() ? sExpression : sDiscriminator);
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        super.setContextClassLoader(loader);
        List<ResourceDiscoverer<URL>> listDiscoverers = this.getDiscovererChain();
        if (listDiscoverers == null) {
            return;
        }
        for (ResourceDiscoverer<URL> discoverer : listDiscoverers) {
            discoverer.setContextClassLoader(this.getContextClassLoader());
        }
    }

    public List<ResourceDiscoverer<URL>> getDiscovererChain() {
        return this.m_listDiscoverers;
    }

    public void setDiscoverers(List<ResourceDiscoverer<URL>> listDiscoverers) {
        Base.azzert(listDiscoverers != null, "ClassPathResourceDiscoverer requires a non-null set of child discoverers");
        this.m_listDiscoverers = listDiscoverers;
    }

    protected void initialize() {
        List<ResourceDiscoverer<URL>> listDiscoverers = this.m_listDiscoverers;
        if (listDiscoverers.size() == 0) {
            listDiscoverers.add(new FileBasedResourceDiscoverer());
            listDiscoverers.add(new JarFileBasedResourceDiscoverer());
        }
    }

    protected static class JarFileBasedResourceDiscoverer
    extends AbstractFilteredResourceDiscoverer<URL> {
        protected static final Set<String> s_setProtocols = new HashSet<String>(Arrays.asList("jar", "zip", "wsjar", "code-source"));

        protected JarFileBasedResourceDiscoverer() {
        }

        @Override
        protected Set<String> getPermittedProtocols() {
            return s_setProtocols;
        }

        @Override
        public Collection<URI> discoverResource(String sFileExpression, URL urlRoot) {
            HashSet<URI> setResources = new HashSet<URI>();
            Pattern regEx = Pattern.compile(sFileExpression);
            try {
                JarFile jarFile;
                URLConnection urlCon = urlRoot.openConnection();
                if (urlCon instanceof JarURLConnection) {
                    JarURLConnection jarUrl = (JarURLConnection)urlCon;
                    jarUrl.setUseCaches(false);
                    jarFile = jarUrl.getJarFile();
                } else {
                    String sFullLocation = urlRoot.getFile();
                    int iEmbeddedRef = sFullLocation.indexOf("!/");
                    String sLocation = iEmbeddedRef == -1 ? sFullLocation : sFullLocation.substring(0, iEmbeddedRef);
                    try {
                        jarFile = new JarFile(new URI(sLocation.replace(" ", "%20")).getSchemeSpecificPart());
                    }
                    catch (URISyntaxException e) {
                        int iColon = sLocation.indexOf(":");
                        jarFile = new JarFile(iColon == -1 || sLocation.substring(0, iColon).contains(File.separator) ? sLocation : sLocation.substring(iColon + 1));
                    }
                }
                Enumeration<JarEntry> enumEntries = jarFile.entries();
                while (enumEntries.hasMoreElements()) {
                    URI uri;
                    JarEntry entry = enumEntries.nextElement();
                    String sResource = entry.getName();
                    if (!regEx.matcher(sResource).matches() || (uri = JarFileBasedResourceDiscoverer.toURI(new URL(urlRoot, "/" + sResource))) == null) continue;
                    setResources.add(uri);
                }
            }
            catch (IOException e) {
                Logger.warn(String.format("JarFileBasedResourceDiscoverer could not open a connection to the resource [url: %s], hence this resource will not be used", urlRoot.toExternalForm()));
            }
            return setResources;
        }
    }

    protected static class FileBasedResourceDiscoverer
    extends AbstractFilteredResourceDiscoverer<URL> {
        protected static final Set<String> s_setProtocols = new HashSet<String>(Arrays.asList("file"));

        protected FileBasedResourceDiscoverer() {
        }

        @Override
        protected Set<String> getPermittedProtocols() {
            return s_setProtocols;
        }

        @Override
        public Collection<URI> discoverResource(String sFileExpression, URL urlRoot) {
            HashSet<URI> setResources = new HashSet<URI>();
            URI uriRoot = FileBasedResourceDiscoverer.toURI(urlRoot);
            if (uriRoot == null) {
                Logger.warn("FileBasedResourceDiscoverer requires a non-null and non-empty root directory");
                return setResources;
            }
            File root = this.ensureDirectory(new File(uriRoot));
            if (root == null) {
                return setResources;
            }
            if (root.isFile() && root.canRead()) {
                setResources.add(uriRoot);
                return setResources;
            }
            Pattern regEx = Pattern.compile(sFileExpression);
            this.findFiles(root, regEx, setResources);
            return setResources;
        }

        protected void findFiles(File root, final Pattern regEx, Set<URI> setResources) {
            File[] complyingFiles = root.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String sPath = pathname.getAbsolutePath();
                    return pathname.isDirectory() || regEx.matcher(sPath.contains("\\") ? sPath.replaceAll("\\\\", "/") : sPath).matches();
                }
            });
            for (int i = 0; i < complyingFiles.length; ++i) {
                File complyingFile = complyingFiles[i];
                if (complyingFile.isFile()) {
                    setResources.add(complyingFile.toURI());
                    continue;
                }
                if (!complyingFile.isDirectory() || this.ensureDirectory(complyingFile) == null) continue;
                this.findFiles(complyingFile, regEx, setResources);
            }
        }

        protected File ensureDirectory(File root) {
            if (!root.isDirectory()) {
                Logger.warn(String.format("FileBasedResourceDiscoverer root directory should be a valid directory [rootDir: %s]", root.getAbsolutePath()));
                return null;
            }
            if (!root.canRead()) {
                Logger.warn(String.format("FileBasedResourceDiscoverer root directory should be a readable directory [rootDir: %s]", root.getAbsolutePath()));
                return null;
            }
            return root;
        }
    }

    public static class InformedResourceDiscoverer
    extends ClassPathResourceDiscoverer {
        protected URL[] m_aUrl;

        public InformedResourceDiscoverer(URL[] aUrl) {
            this(null, null, aUrl);
        }

        public InformedResourceDiscoverer(Set<String> setFileTypes, List<ResourceDiscoverer<URL>> listDiscoverers, URL[] aUrl) {
            super(setFileTypes, listDiscoverers);
            this.m_aUrl = aUrl;
        }

        @Override
        protected Enumeration<URL> findUrls(String sDiscriminator, String sExpression) throws IOException {
            return new SimpleEnumerator<URL>(this.m_aUrl);
        }
    }
}

