/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.packager;

import com.tangosol.dev.packager.ClassReference;
import com.tangosol.dev.packager.ConstantPoolEntry;
import com.tangosol.dev.packager.PackagerClassEntry;
import com.tangosol.dev.packager.PackagerDependencyElement;
import com.tangosol.dev.packager.UnexpectedPackagerException;
import com.tangosol.util.Base;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PackagerDependencyClassElement
extends Base
implements Serializable,
PackagerDependencyElement {
    private String m_className;

    public PackagerDependencyClassElement(String className) {
        this.setClassName(className);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PackagerDependencyClassElement) {
            PackagerDependencyClassElement that = (PackagerDependencyClassElement)obj;
            return this.getClassName().equals(that.getClassName());
        }
        return false;
    }

    public int hashCode() {
        return this.getClassName().hashCode();
    }

    @Override
    public List getDependents(ClassLoader classLoader) {
        Hashtable collector = new Hashtable();
        try {
            for (ConstantPoolEntry constPoolEntry : ConstantPoolEntry.getClassConstants(this.m_className, classLoader)) {
                Object referencedObject;
                if (constPoolEntry == null || !((referencedObject = constPoolEntry.getReferencedObject()) instanceof ClassReference)) continue;
                ClassReference classRef = (ClassReference)referencedObject;
                this.addDependentClass(collector, classRef.getClassName());
            }
        }
        catch (IOException ioe) {
            PackagerDependencyClassElement.err("PDCE: Error getting class constants: " + ioe.getMessage());
            throw new UnexpectedPackagerException(ioe);
        }
        LinkedList list = new LinkedList();
        list.addAll(collector.values());
        return list;
    }

    private void addDependentClass(Hashtable collector, String className) {
        if (className.equals(this.m_className) || className.equals("boolean") || className.equals("byte") || className.equals("char") || className.equals("double") || className.equals("float") || className.equals("int") || className.equals("long") || className.equals("short") || className.equals("void")) {
            return;
        }
        if (collector.get(className) == null) {
            collector.put(className, new PackagerDependencyClassElement(className));
        }
    }

    @Override
    public List getPackagerEntries() {
        LinkedList<PackagerClassEntry> list = new LinkedList<PackagerClassEntry>();
        String packageName = null;
        int lastDot = this.m_className.lastIndexOf(46);
        if (lastDot > 0) {
            packageName = this.m_className.substring(0, lastDot);
        }
        list.add(new PackagerClassEntry(this.m_className));
        if (packageName != null) {
            // empty if block
        }
        return list;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public String toString() {
        return "PDCE[" + this.m_className + "]";
    }

    public static void main(String[] args) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            PackagerDependencyClassElement pdcElem = new PackagerDependencyClassElement(args[0]);
            List dependents = pdcElem.getDependents(classLoader);
            Iterator iter = dependents.iterator();
            while (iter.hasNext()) {
                PackagerDependencyClassElement.out("  " + iter.next());
            }
        }
        catch (Exception e) {
            PackagerDependencyClassElement.out(e);
        }
    }
}

