/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.codemodel;

import com.tangosol.internal.codemodel.JAssignment;
import com.tangosol.internal.codemodel.JAssignmentTarget;
import com.tangosol.internal.codemodel.JBreak;
import com.tangosol.internal.codemodel.JClass;
import com.tangosol.internal.codemodel.JConditional;
import com.tangosol.internal.codemodel.JContinue;
import com.tangosol.internal.codemodel.JDeclaration;
import com.tangosol.internal.codemodel.JDoLoop;
import com.tangosol.internal.codemodel.JExpression;
import com.tangosol.internal.codemodel.JForEach;
import com.tangosol.internal.codemodel.JForLoop;
import com.tangosol.internal.codemodel.JFormatter;
import com.tangosol.internal.codemodel.JGenerable;
import com.tangosol.internal.codemodel.JInvocation;
import com.tangosol.internal.codemodel.JLabel;
import com.tangosol.internal.codemodel.JMethod;
import com.tangosol.internal.codemodel.JMods;
import com.tangosol.internal.codemodel.JReturn;
import com.tangosol.internal.codemodel.JStatement;
import com.tangosol.internal.codemodel.JSwitch;
import com.tangosol.internal.codemodel.JThrow;
import com.tangosol.internal.codemodel.JTryBlock;
import com.tangosol.internal.codemodel.JType;
import com.tangosol.internal.codemodel.JVar;
import com.tangosol.internal.codemodel.JWhileLoop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBlock
implements JGenerable,
JStatement {
    private final List<Object> content = new ArrayList<Object>();
    private boolean bracesRequired = true;
    private boolean indentRequired = true;
    private int pos;

    public JBlock() {
        this(true, true);
    }

    public JBlock(boolean bracesRequired, boolean indentRequired) {
        this.bracesRequired = bracesRequired;
        this.indentRequired = indentRequired;
    }

    public List<Object> getContents() {
        return Collections.unmodifiableList(this.content);
    }

    private <T> T insert(T statementOrDeclaration) {
        this.content.add(this.pos, statementOrDeclaration);
        ++this.pos;
        return statementOrDeclaration;
    }

    public int pos() {
        return this.pos;
    }

    public int pos(int newPos) {
        int r = this.pos;
        if (newPos > this.content.size() || newPos < 0) {
            throw new IllegalArgumentException();
        }
        this.pos = newPos;
        return r;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public JVar decl(JType type, String name) {
        return this.decl(0, type, name, null);
    }

    public JVar decl(JType type, String name, JExpression init) {
        return this.decl(0, type, name, init);
    }

    public JVar decl(int mods, JType type, String name, JExpression init) {
        JVar v = new JVar(JMods.forVar(mods), type, name, init);
        this.insert(v);
        this.bracesRequired = true;
        this.indentRequired = true;
        return v;
    }

    public JBlock assign(JAssignmentTarget lhs, JExpression exp) {
        this.insert(new JAssignment(lhs, exp));
        return this;
    }

    public JBlock assignPlus(JAssignmentTarget lhs, JExpression exp) {
        this.insert(new JAssignment(lhs, exp, "+"));
        return this;
    }

    public JInvocation invoke(JExpression expr, String method) {
        JInvocation i = new JInvocation(expr, method);
        this.insert(i);
        return i;
    }

    public JInvocation invoke(JExpression expr, JMethod method) {
        return this.insert(new JInvocation(expr, method));
    }

    public JInvocation staticInvoke(JClass type, String method) {
        return this.insert(new JInvocation(type, method));
    }

    public JInvocation invoke(String method) {
        return this.insert(new JInvocation((JExpression)null, method));
    }

    public JInvocation invoke(JMethod method) {
        return this.insert(new JInvocation((JExpression)null, method));
    }

    public JBlock add(JStatement s) {
        this.insert(s);
        return this;
    }

    public JConditional _if(JExpression expr) {
        return this.insert(new JConditional(expr));
    }

    public JForLoop _for() {
        return this.insert(new JForLoop());
    }

    public JWhileLoop _while(JExpression test) {
        return this.insert(new JWhileLoop(test));
    }

    public JSwitch _switch(JExpression test) {
        return this.insert(new JSwitch(test));
    }

    public JDoLoop _do(JExpression test) {
        return this.insert(new JDoLoop(test));
    }

    public JTryBlock _try() {
        return this.insert(new JTryBlock());
    }

    public void _return() {
        this.insert(new JReturn(null));
    }

    public void _return(JExpression exp) {
        this.insert(new JReturn(exp));
    }

    public void _throw(JExpression exp) {
        this.insert(new JThrow(exp));
    }

    public void _break() {
        this._break(null);
    }

    public void _break(JLabel label) {
        this.insert(new JBreak(label));
    }

    public JLabel label(String name) {
        JLabel l = new JLabel(name);
        this.insert(l);
        return l;
    }

    public void _continue(JLabel label) {
        this.insert(new JContinue(label));
    }

    public void _continue() {
        this._continue(null);
    }

    public JBlock block() {
        JBlock b = new JBlock();
        b.bracesRequired = false;
        b.indentRequired = false;
        return this.insert(b);
    }

    public JStatement directStatement(final String source) {
        JStatement s = new JStatement(){

            public void state(JFormatter f) {
                f.p(source).nl();
            }
        };
        this.add(s);
        return s;
    }

    @Override
    public void generate(JFormatter f) {
        if (this.bracesRequired) {
            f.p('{').nl();
        }
        if (this.indentRequired) {
            f.i();
        }
        this.generateBody(f);
        if (this.indentRequired) {
            f.o();
        }
        if (this.bracesRequired) {
            f.p('}');
        }
    }

    void generateBody(JFormatter f) {
        for (Object o : this.content) {
            if (o instanceof JDeclaration) {
                f.d((JDeclaration)o);
                continue;
            }
            f.s((JStatement)o);
        }
    }

    public JForEach forEach(JType varType, String name, JExpression collection) {
        return this.insert(new JForEach(varType, name, collection));
    }

    @Override
    public void state(JFormatter f) {
        f.g(this);
        if (this.bracesRequired) {
            f.nl();
        }
    }
}

