/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.codemodel;

import com.tangosol.internal.codemodel.JBlock;
import com.tangosol.internal.codemodel.JExpr;
import com.tangosol.internal.codemodel.JExpression;
import com.tangosol.internal.codemodel.JFormatter;
import com.tangosol.internal.codemodel.JOp;
import com.tangosol.internal.codemodel.JStatement;

public class JConditional
implements JStatement {
    private JExpression test = null;
    private JBlock _then = new JBlock();
    private JBlock _else = null;

    JConditional(JExpression test) {
        this.test = test;
    }

    public JBlock _then() {
        return this._then;
    }

    public JBlock _else() {
        if (this._else == null) {
            this._else = new JBlock();
        }
        return this._else;
    }

    public JConditional _elseif(JExpression boolExp) {
        return this._else()._if(boolExp);
    }

    public void state(JFormatter f) {
        if (this.test == JExpr.TRUE) {
            this._then.generateBody(f);
            return;
        }
        if (this.test == JExpr.FALSE) {
            this._else.generateBody(f);
            return;
        }
        if (JOp.hasTopOp(this.test)) {
            f.p("if ").g(this.test);
        } else {
            f.p("if (").g(this.test).p(')');
        }
        f.g(this._then);
        if (this._else != null) {
            f.p("else").g(this._else);
        }
        f.nl();
    }
}

