/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.jandex;

import com.tangosol.internal.jandex.Index;
import com.tangosol.internal.jandex.IndexWriterImpl;
import com.tangosol.internal.jandex.IndexWriterV1;
import com.tangosol.internal.jandex.IndexWriterV2;
import com.tangosol.internal.jandex.UnsupportedVersion;
import java.io.IOException;
import java.io.OutputStream;

public final class IndexWriter {
    private final OutputStream out;

    public IndexWriter(OutputStream out) {
        this.out = out;
    }

    public int write(Index index) throws IOException {
        return this.write(index, 9);
    }

    @Deprecated
    public int write(Index index, byte version) throws IOException {
        return this.write(index, version & 0xFF);
    }

    public int write(Index index, int version) throws IOException {
        IndexWriterImpl writer = this.getWriter(version);
        if (writer == null) {
            throw new UnsupportedVersion("Version: " + version);
        }
        return writer.write(index, version);
    }

    private IndexWriterImpl getWriter(int version) {
        if (version >= 1 && version <= 3) {
            return new IndexWriterV1(this.out);
        }
        if (version >= 6 && version <= 9) {
            return new IndexWriterV2(this.out);
        }
        return null;
    }
}

