/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.jandex;

import com.tangosol.internal.jandex.AnnotationInstance;
import com.tangosol.internal.jandex.Index;
import java.io.File;
import java.util.List;

public final class Result {
    private final Index index;
    private final int annotations;
    private final int instances;
    private final int classes;
    private final int bytes;
    private final String name;
    private final File outputFile;

    Result(Index index, String name, int bytes, File outputFile) {
        this.index = index;
        this.annotations = index.annotations.size();
        this.instances = this.countInstances(index);
        this.classes = index.classes.size();
        this.bytes = bytes;
        this.name = name;
        this.outputFile = outputFile;
    }

    private int countInstances(Index index) {
        int c = 0;
        for (List<AnnotationInstance> list : index.annotations.values()) {
            c += list.size();
        }
        return c;
    }

    public Index getIndex() {
        return this.index;
    }

    public int getAnnotations() {
        return this.annotations;
    }

    public int getBytes() {
        return this.bytes;
    }

    public int getClasses() {
        return this.classes;
    }

    public int getInstances() {
        return this.instances;
    }

    public String getName() {
        return this.name;
    }

    public File getOutputFile() {
        return this.outputFile;
    }
}

