/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.metrics;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.metrics.BaseMBeanMetric;
import com.tangosol.internal.metrics.MetricsMBeanAttributeFilter;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.net.management.Registry;
import com.tangosol.net.metrics.MBeanMetric;
import com.tangosol.net.metrics.MetricsRegistryAdapter;
import com.tangosol.util.Base;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;

public class MetricSupport {
    private static final MetricsMBeanAttributeFilter ATTRIBUTE_FILTER = new MetricsMBeanAttributeFilter();
    private static final String PLATFORM_MEMORY_TYPE = "type=Platform,Domain=java.lang,subType=Memory";
    private static final String PLATFORM_OS_TYPE = "type=Platform,Domain=java.lang,subType=OperatingSystem";
    private static final String PLATFORM_GC = "type=Platform,Domain=java.lang,subType=GarbageCollector";
    private static final String METRIC_PREFIX_HEAP_AFTER_GC = "Coherence.Memory.HeapAfterGC.";
    private static final String FEDERATION_ORIGIN_TYPE = "type=Federation,subType=Origin";
    private static final String FEDERATION_DESTINATION_TYPE = "type=Federation,subType=Destination";
    public static final Set<String> OBJECT_NAME_TAG_EXCLUDES = new HashSet<String>(Arrays.asList("type", "subType", "responsibility", "UUID", "Domain"));
    private static final List<String> LIST_TAG_TYPES = Arrays.asList("String", "boolean", "java.lang.String", "java.lang.Boolean");
    private static final Set<String> METRIC_ATTRIBUTE_TYPES = new HashSet<String>(Arrays.asList("long", "int", "double", "float", Long.class.getName(), Integer.class.getName(), Double.class.getName(), Float.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName()));
    private static final List<String> LIST_SKIP_ATTRIBUTES = Arrays.asList("ObjectName", "Verbose", "Valid");
    private static final String REGEX_TAG = "[^a-zA-Z0-9]";
    private static final String UNDER_SCORE = "_";
    private static final String ESC_QUOTE = "\\\\\"";
    private static final String QUOTE = "\"";
    private static final Set<ObjectName> f_setPlatfromMBeans = MetricSupport.getPlatformPatterns();
    private static final Map<ObjectName, String> s_mapMetricPrefix = MetricSupport.getMetricNamePrefixMap();
    public static final String GLOBAL_TAG_CLUSTER = "cluster";
    public static final String GLOBAL_TAG_SITE = "site";
    public static final String GLOBAL_TAG_MACHINE = "machine";
    public static final String GLOBAL_TAG_MEMBER = "member";
    public static final String GLOBAL_TAG_ROLE = "role";
    private final List<MetricsRegistryAdapter> f_listRegistry;
    private final boolean f_fHasRegistries;
    private final Map<ObjectName, Set<MBeanMetric>> f_mapMetric;
    private final Supplier<MBeanServerProxy> f_suppMBeanServerProxy;
    private final Supplier<Registry> f_suppRegistry;
    private final Set<String> f_setRegistered = new HashSet<String>();
    private boolean f_fMemoryRegistered;

    public MetricSupport() {
        this(() -> CacheFactory.getCluster().getManagement());
    }

    MetricSupport(Supplier<Registry> supplier, List<MetricsRegistryAdapter> adapters) {
        this(supplier, () -> adapters);
    }

    MetricSupport(Supplier<Registry> supplier, Supplier<List<MetricsRegistryAdapter>> adaptersSupplier) {
        this.f_suppRegistry = supplier;
        this.f_suppMBeanServerProxy = () -> this.f_suppRegistry.get().getMBeanServerProxy().local();
        this.f_listRegistry = adaptersSupplier.get();
        this.f_fHasRegistries = !this.f_listRegistry.isEmpty();
        this.f_mapMetric = new HashMap<ObjectName, Set<MBeanMetric>>();
    }

    MetricSupport(Supplier<Registry> supplier) {
        this(supplier, () -> {
            ArrayList<MetricsRegistryAdapter> list = new ArrayList<MetricsRegistryAdapter>();
            ClassLoader[] classLoaders = new ClassLoader[]{Base.getContextClassLoader(), MetricsRegistryAdapter.class.getClassLoader()};
            int len = classLoaders.length;
            for (int i = 0; i < len; ++i) {
                ClassLoader loader = classLoaders[i];
                try {
                    ServiceLoader<MetricsRegistryAdapter> serviceLoader = ServiceLoader.load(MetricsRegistryAdapter.class, loader);
                    for (MetricsRegistryAdapter metricsRegistry : serviceLoader) {
                        list.add(metricsRegistry);
                    }
                    break;
                }
                catch (Throwable t) {
                    list.clear();
                    if (!Logger.isEnabled(2)) continue;
                    String msg = "Error loading MetricRegistryAdapter using the %s classloader:";
                    if (i == 0) {
                        Logger.warn(String.format(msg, "context"), t);
                        Logger.warn("Attempting to load adapters using the fallback classloader.");
                        continue;
                    }
                    Logger.warn(String.format(msg, "fallback"), t);
                    Logger.warn("Metrics failed to initialize.");
                    continue;
                }
            }
            return list;
        });
    }

    public boolean hasRegistries() {
        return this.f_fHasRegistries;
    }

    public void register(String sMBeanName) {
        if (this.f_fHasRegistries) {
            if (sMBeanName.startsWith("type=Cluster") || sMBeanName.startsWith("type=Management") || sMBeanName.startsWith("type=EMDiscoveryIntegration")) {
                return;
            }
            MBeanServerProxy proxy = this.f_suppMBeanServerProxy.get();
            if (sMBeanName.startsWith("type=Node")) {
                this.registerInternal(this.f_suppRegistry.get().ensureGlobalName("type=Cluster"), proxy);
            }
            this.registerInternal(sMBeanName, proxy);
        }
    }

    public synchronized void remove(String sMBeanName) {
        Set<MBeanMetric> setMetric;
        if (this.f_fHasRegistries && this.f_setRegistered.remove(sMBeanName) && (setMetric = this.f_mapMetric.remove(this.createObjectName(sMBeanName))) != null) {
            for (MBeanMetric metric : setMetric) {
                for (MetricsRegistryAdapter adapter : this.f_listRegistry) {
                    try {
                        adapter.remove(metric.getIdentifier());
                    }
                    catch (Throwable e) {
                        Logger.warn("Caught exception removing metrics for " + sMBeanName + " from " + adapter + ": " + e.getLocalizedMessage());
                    }
                }
            }
        }
    }

    private synchronized void registerInternal(String sMBeanName, MBeanServerProxy proxy) {
        if (this.f_setRegistered.contains(sMBeanName)) {
            return;
        }
        this.ensureMemoryMetrics(this.f_listRegistry);
        this.f_setRegistered.add(sMBeanName);
        MBeanInfo mBeanInfo = proxy.getMBeanInfo(sMBeanName);
        Set<MBeanMetric> setMetric = this.getMetrics(sMBeanName, mBeanInfo, proxy);
        if (setMetric.size() > 0) {
            this.f_mapMetric.put(this.createObjectName(sMBeanName), setMetric);
            for (MetricsRegistryAdapter adapter : this.f_listRegistry) {
                for (MBeanMetric metric : setMetric) {
                    try {
                        adapter.register(metric);
                    }
                    catch (Throwable e) {
                        Logger.warn("Caught exception registering metric " + metric.getIdentifier() + " with " + adapter + ": " + e.getLocalizedMessage());
                    }
                }
            }
        }
    }

    private ObjectName createObjectName(String sMBeanName) {
        try {
            sMBeanName = MBeanHelper.ensureDomain(sMBeanName);
            return new ObjectName(MBeanHelper.quoteCanonical(sMBeanName));
        }
        catch (MalformedObjectNameException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    Set<MBeanMetric> getMetrics(String sMBeanName, MBeanInfo mBeanInfo, MBeanServerProxy proxy) {
        MBeanAttributeInfo[] aAttributeInfo = mBeanInfo.getAttributes();
        ObjectName objectName = this.createObjectName(sMBeanName);
        HashMap<String, MBeanAttributeInfo> mapMetricValues = new HashMap<String, MBeanAttributeInfo>();
        HashMap<String, String> mapTagAttributes = new HashMap<String, String>();
        if (this.isPlatformMBean(objectName)) {
            this.getMetricsForPlatformMBean(aAttributeInfo, objectName, mapMetricValues, mapTagAttributes);
        } else {
            this.getMetricsForCoherenceMBean(aAttributeInfo, mapMetricValues, mapTagAttributes);
        }
        HashSet<MBeanMetric> setMetric = new HashSet<MBeanMetric>();
        if (!mapMetricValues.isEmpty()) {
            Map<String, String> mapTag = this.createMetricTags(sMBeanName, proxy, objectName, mapTagAttributes);
            for (Map.Entry entry : mapMetricValues.entrySet()) {
                List<MBeanMetric> list = this.getMetricsForAttribute(sMBeanName, objectName, mBeanInfo, (MBeanAttributeInfo)entry.getValue(), mapTag);
                setMetric.addAll(list);
            }
        }
        return setMetric;
    }

    private void getMetricsForCoherenceMBean(MBeanAttributeInfo[] aAttributeInfo, Map<String, MBeanAttributeInfo> mapMetricValues, Map<String, String> mapTagAttributes) {
        for (MBeanAttributeInfo attributeInfo : aAttributeInfo) {
            if (!ATTRIBUTE_FILTER.evaluate(attributeInfo)) continue;
            String sTagName = MetricSupport.getMetric("metrics.tag", attributeInfo);
            if (sTagName != null) {
                if (sTagName.equals("_default")) {
                    sTagName = attributeInfo.getName();
                }
                if ((sTagName = sTagName.replaceAll(REGEX_TAG, UNDER_SCORE)).equals("senior_member_id")) continue;
                mapTagAttributes.put(sTagName, attributeInfo.getName());
                continue;
            }
            mapMetricValues.put(attributeInfo.getName(), attributeInfo);
        }
    }

    private void getMetricsForPlatformMBean(MBeanAttributeInfo[] aAttributeInfo, ObjectName objectName, Map<String, MBeanAttributeInfo> mapMetricValues, Map<String, String> mapTagAttributes) {
        if (f_setPlatfromMBeans.stream().anyMatch(pattern -> pattern.apply(objectName))) {
            for (MBeanAttributeInfo attributeInfo : aAttributeInfo) {
                String sName = attributeInfo.getName();
                String sType = attributeInfo.getType();
                if (sType.startsWith("[") || LIST_SKIP_ATTRIBUTES.contains(sName)) continue;
                if (LIST_TAG_TYPES.contains(sType)) {
                    mapTagAttributes.put(sName, sName);
                    continue;
                }
                mapMetricValues.put(sName, attributeInfo);
            }
        }
    }

    private List<MBeanMetric> getMetricsForAttribute(String sMBeanName, ObjectName objectName, MBeanInfo mBeanInfo, MBeanAttributeInfo attributeInfo, Map<String, String> mapTag) {
        String[] asLabels;
        ArrayList<MBeanMetric> listMetric = new ArrayList<MBeanMetric>();
        String sAttribType = attributeInfo.getType();
        MBeanMetric.Scope scope = this.getRegistryType(mBeanInfo, objectName);
        String sAttributeName = attributeInfo.getName();
        Descriptor descriptor = attributeInfo.getDescriptor();
        String[] stringArray = asLabels = descriptor == null ? null : (String[])descriptor.getFieldValue("metric.labels");
        if (attributeInfo instanceof OpenMBeanAttributeInfo) {
            OpenMBeanAttributeInfo openInfo = (OpenMBeanAttributeInfo)((Object)attributeInfo);
            OpenType<?> openType = openInfo.getOpenType();
            if (openType instanceof CompositeType) {
                Function<MBeanServerProxy, CompositeData> function = mbsp -> (CompositeData)mbsp.getAttribute(sMBeanName, sAttributeName);
                listMetric.addAll(this.getMetricsForCompositeType(sMBeanName, objectName, attributeInfo, mapTag, scope, function, (CompositeType)openType));
            }
        } else if (!TabularDataSupport.class.getName().equals(sAttribType)) {
            Map<String, String> mapMetricTag;
            String sMetricName = this.createMetricName(objectName, attributeInfo);
            String sDescription = attributeInfo.getDescription();
            if (asLabels == null || asLabels.length == 0) {
                mapMetricTag = mapTag;
            } else {
                mapMetricTag = new HashMap<String, String>(mapTag);
                for (int i = 0; i < asLabels.length; ++i) {
                    String sKey = asLabels[i++];
                    if (i >= asLabels.length) continue;
                    mapMetricTag.put(sKey, asLabels[i]);
                }
            }
            MBeanMetric metric = this.createSimpleMetric(sMBeanName, sMetricName, sAttributeName, scope, mapMetricTag, sDescription);
            if (this.shouldInclude(metric)) {
                listMetric.add(metric);
            }
        }
        return listMetric;
    }

    private boolean shouldInclude(MBeanMetric metric) {
        Object oValue = metric.getValue();
        if (oValue != null) {
            return true;
        }
        return metric.getName().startsWith("Coherence.Cache.") && !metric.getName().startsWith("Coherence.Cache.Store") && !metric.getName().startsWith("Coherence.Cache.Queue");
    }

    private List<MBeanMetric> getMetricsForCompositeType(String sMBeanName, ObjectName objectName, MBeanAttributeInfo attributeInfo, Map<String, String> mapTag, MBeanMetric.Scope scope, Function<MBeanServerProxy, CompositeData> supplierParent, CompositeType openType) {
        ArrayList<MBeanMetric> list = new ArrayList<MBeanMetric>();
        for (String sKey : openType.keySet()) {
            OpenType<?> type = openType.getType(sKey);
            if (type instanceof SimpleType) {
                if (!METRIC_ATTRIBUTE_TYPES.contains(type.getTypeName())) continue;
                String sMetricName = this.createMetricName(objectName, attributeInfo) + '.' + sKey;
                String sHelp = attributeInfo.getDescription();
                list.add(this.createCompositeMetric(sMBeanName, sMetricName, supplierParent, sKey, scope, mapTag, sHelp));
                continue;
            }
            if (type instanceof TabularData || !(type instanceof CompositeData)) continue;
            Function<MBeanServerProxy, CompositeData> supplier = mbs -> {
                CompositeData data = (CompositeData)supplierParent.apply((MBeanServerProxy)mbs);
                return data == null ? null : (CompositeData)data.get(sKey);
            };
            list.addAll(this.getMetricsForCompositeType(sMBeanName, objectName, attributeInfo, mapTag, scope, supplier, (CompositeType)type));
        }
        return list;
    }

    private MBeanMetric createSimpleMetric(String sMBeanName, String sMetricName, String sAttribute, MBeanMetric.Scope scope, Map<String, String> mapTag, String sHelp) {
        MBeanMetric.Identifier identifier = new MBeanMetric.Identifier(scope, sMetricName, mapTag);
        return new SimpleMetric(identifier, sMBeanName, sAttribute, sHelp, this.f_suppMBeanServerProxy);
    }

    private MBeanMetric createCompositeMetric(String sMBeanName, String sMetricName, Function<MBeanServerProxy, CompositeData> supplierParent, String sKey, MBeanMetric.Scope scope, Map<String, String> mapTag, String sHelp) {
        MBeanMetric.Identifier identifier = new MBeanMetric.Identifier(scope, sMetricName, mapTag);
        return new CompositeMetric(identifier, sMBeanName, supplierParent, sKey, sHelp, this.f_suppMBeanServerProxy);
    }

    private MBeanMetric.Scope getRegistryType(MBeanInfo mBeanInfo, ObjectName objectName) {
        Object sType = mBeanInfo.getDescriptor().getFieldValue("metric.scope");
        if (sType == null) {
            return this.isPlatformMBean(objectName) ? MBeanMetric.Scope.VENDOR : MBeanMetric.Scope.APPLICATION;
        }
        try {
            return MBeanMetric.Scope.valueOf(String.valueOf(sType));
        }
        catch (IllegalArgumentException e) {
            return MBeanMetric.Scope.APPLICATION;
        }
    }

    private String createMetricName(ObjectName objectName, MBeanAttributeInfo attributeInfo) {
        String sMetricName = MetricSupport.getMetric("metrics.value", attributeInfo);
        String sPrefix = s_mapMetricPrefix.entrySet().stream().filter(e -> ((ObjectName)e.getKey()).apply(objectName)).map(Map.Entry::getValue).findFirst().orElse(null);
        if (sPrefix == null) {
            sPrefix = "Coherence." + objectName.getKeyProperty("type");
        }
        if (sMetricName == null || sMetricName.isEmpty() || sMetricName.equals("_default")) {
            sMetricName = attributeInfo.getName();
        }
        if (!sPrefix.endsWith(".")) {
            sPrefix = sPrefix + ".";
        }
        return sPrefix + sMetricName;
    }

    private Map<String, String> createMetricTags(String sMBeanName, MBeanServerProxy proxy, ObjectName objectName, Map<String, String> mapTagAttributes) {
        HashMap<String, String> mapTag = new HashMap<String, String>();
        Cluster cluster = CacheFactory.getCluster();
        Member member = cluster.getLocalMember();
        if (cluster.isRunning()) {
            mapTag.put(GLOBAL_TAG_CLUSTER, cluster.getClusterName());
        }
        if (!sMBeanName.startsWith("type=Cluster") && objectName.getKeyProperty("responsibility") == null) {
            mapTag.put(GLOBAL_TAG_SITE, member.getSiteName());
            mapTag.put(GLOBAL_TAG_MACHINE, member.getMachineName());
            mapTag.put(GLOBAL_TAG_MEMBER, member.getMemberName());
            mapTag.put(GLOBAL_TAG_ROLE, member.getRoleName());
        }
        objectName.getKeyPropertyList().entrySet().stream().filter(e -> !OBJECT_NAME_TAG_EXCLUDES.contains(e.getKey())).forEach(e -> this.addTag(mapTag, (String)e.getKey(), e.getValue()));
        for (Map.Entry<String, String> entry : mapTagAttributes.entrySet()) {
            Object oTag = proxy.getAttribute(sMBeanName, entry.getValue());
            this.addTag(mapTag, entry.getKey(), oTag);
        }
        return mapTag;
    }

    private void addTag(Map<String, String> mapTag, String sKey, Object oValue) {
        if (MetricSupport.isValueSet(oValue)) {
            sKey = MetricSupport.ensureStartsWithLowercase(sKey);
            String sValue = String.valueOf(oValue).replaceAll(QUOTE, ESC_QUOTE);
            if ("service".equals(sKey)) {
                sKey = "coherence_service";
            }
            if (mapTag.containsKey(sKey) && !sValue.equals(mapTag.get(sKey))) {
                sKey = "tag_" + sKey;
            }
            mapTag.put(sKey, sValue);
        }
    }

    private static String ensureStartsWithLowercase(String s) {
        return Character.isLowerCase(s.charAt(0)) ? s : Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private static boolean isValueSet(Object oValue) {
        if (oValue == null) {
            return false;
        }
        if (oValue instanceof Number) {
            return ((Number)oValue).longValue() != -1L;
        }
        if (oValue instanceof String) {
            String sValue = (String)oValue;
            return sValue.length() > 0 && !sValue.equals("Not configured") && !sValue.equalsIgnoreCase("n/a");
        }
        return true;
    }

    private static String getMetric(String sMetricFieldName, MBeanAttributeInfo attrInfo) {
        Descriptor descriptor = attrInfo.getDescriptor();
        Object oMetricsFieldValue = descriptor == null ? null : descriptor.getFieldValue(sMetricFieldName);
        return oMetricsFieldValue instanceof String ? (String)oMetricsFieldValue : null;
    }

    private static Set<ObjectName> getPlatformPatterns() {
        try {
            HashSet<ObjectName> set = new HashSet<ObjectName>();
            set.add(new ObjectName("*:type=Platform,Domain=java.lang,subType=Memory,*"));
            set.add(new ObjectName("*:type=Platform,Domain=java.lang,subType=OperatingSystem,*"));
            set.add(new ObjectName("*:type=Platform,Domain=java.lang,subType=GarbageCollector,*"));
            return set;
        }
        catch (MalformedObjectNameException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    private static Map<ObjectName, String> getMetricNamePrefixMap() {
        HashMap<ObjectName, String> map = new HashMap<ObjectName, String>();
        map.put(MetricSupport.createPattern(FEDERATION_ORIGIN_TYPE), "Coherence.Federation.Origin.");
        map.put(MetricSupport.createPattern(FEDERATION_DESTINATION_TYPE), "Coherence.Federation.Destination.");
        map.put(MetricSupport.createPattern(PLATFORM_MEMORY_TYPE), "Coherence.Memory.");
        map.put(MetricSupport.createPattern(PLATFORM_OS_TYPE), "Coherence.OS.");
        map.put(MetricSupport.createPattern(PLATFORM_GC), "Coherence.GC.");
        return map;
    }

    private static ObjectName createPattern(String sType) {
        try {
            return new ObjectName(String.format("*:%s,*", sType));
        }
        catch (MalformedObjectNameException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    private boolean isPlatformMBean(ObjectName objectName) {
        return "Platform".equals(objectName.getKeyProperty("type")) && "java.lang".equals(objectName.getKeyProperty("Domain"));
    }

    private synchronized void ensureMemoryMetrics(List<MetricsRegistryAdapter> listRegistry) {
        if (this.f_fMemoryRegistered || listRegistry.isEmpty()) {
            return;
        }
        this.f_fMemoryRegistered = true;
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (bean.getType() != MemoryType.HEAP) continue;
            String sMBeanName = bean.getObjectName().getCanonicalName();
            String sDescr = "Memory pool heap usage after GC ";
            MBeanServerProxy proxy = this.f_suppMBeanServerProxy.get();
            HashMap<String, String> mapTagAttributes = new HashMap<String, String>();
            Map<String, String> mapTag = this.createMetricTags(sMBeanName, proxy, bean.getObjectName(), mapTagAttributes);
            mapTag.put("name", bean.getName());
            MBeanMetric.Identifier idUsed = new MBeanMetric.Identifier(MBeanMetric.Scope.VENDOR, "Coherence.Memory.HeapAfterGC.Used", mapTag);
            MBeanMetric.Identifier idMax = new MBeanMetric.Identifier(MBeanMetric.Scope.VENDOR, "Coherence.Memory.HeapAfterGC.Max", mapTag);
            MBeanMetric.Identifier idCommitted = new MBeanMetric.Identifier(MBeanMetric.Scope.VENDOR, "Coherence.Memory.HeapAfterGC.Committed", mapTag);
            MBeanMetric.Identifier idInit = new MBeanMetric.Identifier(MBeanMetric.Scope.VENDOR, "Coherence.Memory.HeapAfterGC.Initial", mapTag);
            MemoryAfterGCMetric metricUsed = new MemoryAfterGCMetric(idUsed, sDescr + "(used)", bean, MemoryUsage::getUsed);
            MemoryAfterGCMetric metricMax = new MemoryAfterGCMetric(idMax, sDescr + "(max)", bean, MemoryUsage::getMax);
            MemoryAfterGCMetric metricCommitted = new MemoryAfterGCMetric(idCommitted, sDescr + "(committed)", bean, MemoryUsage::getCommitted);
            MemoryAfterGCMetric metricInit = new MemoryAfterGCMetric(idInit, sDescr + "(initial)", bean, MemoryUsage::getInit);
            for (MetricsRegistryAdapter adapter : listRegistry) {
                adapter.register(metricUsed);
                adapter.register(metricMax);
                adapter.register(metricCommitted);
                adapter.register(metricInit);
            }
        }
    }

    class MemoryAfterGCMetric
    extends BaseMetric {
        private final MemoryPoolMXBean f_bean;
        private final Function<MemoryUsage, Number> f_function;

        public MemoryAfterGCMetric(MBeanMetric.Identifier id, String sDescr, MemoryPoolMXBean bean, Function<MemoryUsage, Number> fn) {
            super(id, bean.getObjectName().getCanonicalName(), sDescr);
            this.f_bean = bean;
            this.f_function = fn;
        }

        @Override
        Object getAttributeValue() {
            MemoryUsage usage = this.f_bean.getCollectionUsage();
            return usage == null ? (Number)null : (Number)this.f_function.apply(usage);
        }
    }

    class CompositeMetric
    extends BaseMetric {
        private final Supplier<MBeanServerProxy> f_suppMBeanServerProxy;
        private final Function<MBeanServerProxy, CompositeData> f_supplierParent;
        private String f_sKey;

        CompositeMetric(MBeanMetric.Identifier identifier, String sMbean, Function<MBeanServerProxy, CompositeData> supplierParent, String sKey, String sDescription, Supplier<MBeanServerProxy> supplier) {
            super(identifier, sMbean, sDescription);
            this.f_supplierParent = supplierParent;
            this.f_sKey = sKey;
            this.f_suppMBeanServerProxy = supplier;
        }

        @Override
        Object getAttributeValue() {
            CompositeData data = this.f_supplierParent.apply(this.f_suppMBeanServerProxy.get());
            return data == null ? null : data.get(this.f_sKey);
        }
    }

    class SimpleMetric
    extends BaseMetric {
        private final Supplier<MBeanServerProxy> f_suppMBeanServerProxy;
        private final String f_sAttribute;

        SimpleMetric(MBeanMetric.Identifier identifier, String sMbean, String sAttribute, String sDescription, Supplier<MBeanServerProxy> supplier) {
            super(identifier, sMbean, sDescription);
            this.f_sAttribute = sAttribute;
            this.f_suppMBeanServerProxy = supplier;
        }

        @Override
        Object getAttributeValue() {
            return this.f_suppMBeanServerProxy.get().getAttribute(this.getMBeanName(), this.f_sAttribute);
        }
    }

    abstract class BaseMetric
    extends BaseMBeanMetric {
        BaseMetric(MBeanMetric.Identifier identifier, String sMBeanName, String sDescription) {
            super(identifier, sMBeanName, sDescription);
        }

        abstract Object getAttributeValue();

        @Override
        public Object getValue() {
            try {
                Object oValue = this.getAttributeValue();
                if (oValue instanceof Date) {
                    oValue = ((Date)oValue).getTime();
                }
                return MetricSupport.isValueSet(oValue) ? oValue : null;
            }
            catch (IllegalArgumentException e) {
                try {
                    MetricSupport.this.remove(this.getMBeanName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            catch (Exception e) {
                CacheFactory.err("Caught exception getting metric value for " + this.getIdentifier());
                CacheFactory.err(e);
                return null;
            }
        }
    }
}

