/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.tangosol.internal.net.LegacyXmlTcpDatagramSocketDependencies;
import com.tangosol.internal.net.ssl.LegacyXmlSSLSocketProviderDependencies;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.TcpDatagramSocketProvider;
import com.tangosol.run.xml.XmlElement;
import java.util.Iterator;
import java.util.List;

public class LegacyXmlSocketProviderFactoryDependencies
extends SocketProviderFactory.DefaultDependencies {
    protected XmlElement m_xml;
    public static final String XML_NAME = "socket-providers";
    public static final String XML_PROVIDER_NAME = "socket-provider";

    public LegacyXmlSocketProviderFactoryDependencies(XmlElement xml) {
        if (xml == null) {
            throw new IllegalArgumentException("Missing configuration");
        }
        if (xml.getName().equals(XML_NAME)) {
            Iterator iter = xml.getElements(XML_PROVIDER_NAME);
            while (iter.hasNext()) {
                XmlElement xmlSub = (XmlElement)iter.next();
                String sId = xmlSub.getSafeAttribute("id").getString();
                if (sId.length() == 0) {
                    throw new IllegalArgumentException("id attribute required for: " + xmlSub);
                }
                if (!xmlSub.getName().equals(XML_PROVIDER_NAME)) {
                    throw new IllegalArgumentException("unknown element: " + xmlSub);
                }
                this.parseConfig(sId, xmlSub);
            }
        } else {
            throw new IllegalArgumentException("Invalid configuration: " + xml);
        }
    }

    public LegacyXmlSocketProviderFactoryDependencies(String providerId, XmlElement xml) {
        if (xml == null) {
            throw new IllegalArgumentException("Missing configuration");
        }
        if (!xml.getName().equals(XML_PROVIDER_NAME)) {
            throw new IllegalArgumentException("Invalid configuration: " + xml);
        }
        this.parseConfig(providerId, xml);
    }

    @Deprecated
    public static String getProviderId(XmlElement xml) {
        String sRef;
        if (xml == null) {
            return null;
        }
        if (xml.getElementList().isEmpty()) {
            sRef = xml.getString();
            if (sRef.length() == 0) {
                return null;
            }
        } else {
            return "";
        }
        return sRef;
    }

    protected void parseConfig(String id, XmlElement xml) {
        List listProviders = xml.getElementList();
        for (XmlElement xmlProvider : xml.getElementList()) {
            String sType = xmlProvider.getName();
            if (sType.equals(SocketProviderFactory.Dependencies.ProviderType.SYSTEM.getName())) {
                this.m_mapProvider.put(id, SocketProviderFactory.Dependencies.ProviderType.SYSTEM);
                continue;
            }
            if (sType.equals(SocketProviderFactory.Dependencies.ProviderType.TCP.getName())) {
                this.m_mapTCPDatagramDependencies.put(id, new LegacyXmlTcpDatagramSocketDependencies(xmlProvider));
                this.m_mapProvider.put(id, SocketProviderFactory.Dependencies.ProviderType.TCP);
                continue;
            }
            if (sType.equals(SocketProviderFactory.Dependencies.ProviderType.SSL.getName())) {
                this.m_mapSSLDependencies.put(id, new LegacyXmlSSLSocketProviderDependencies(xmlProvider, this));
                this.m_mapProvider.put(id, SocketProviderFactory.Dependencies.ProviderType.SSL);
                XmlElement xmlCat = xmlProvider.getElement("datagram-socket");
                if (xmlCat == null) continue;
                TcpDatagramSocketProvider.DefaultDependencies dependencies = new TcpDatagramSocketProvider.DefaultDependencies();
                XmlElement xmlSub = xmlCat.getElement("blocking");
                if (xmlSub != null) {
                    dependencies.setBlocking(xmlSub.getBoolean(true));
                }
                if ((xmlSub = xmlCat.getElement("advance-frequency")) != null) {
                    dependencies.setAdvanceFrequency(xmlSub.getInt());
                }
                this.m_mapTCPDatagramDependencies.put(id, dependencies);
                continue;
            }
            if (sType.equals(SocketProviderFactory.Dependencies.ProviderType.SDP.getName())) {
                this.m_mapProvider.put(id, SocketProviderFactory.Dependencies.ProviderType.SDP);
                continue;
            }
            throw new IllegalArgumentException("Unsupported socket provider: " + sType);
        }
    }
}

