/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.cluster;

import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.coherence.config.ParameterMacroExpressionParser;
import com.tangosol.coherence.config.builder.AddressProviderBuilder;
import com.tangosol.coherence.config.builder.ListBasedAddressProviderBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilderRegistry;
import com.tangosol.coherence.config.builder.ServiceFailurePolicyBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.coherence.config.xml.OperationalConfigNamespaceHandler;
import com.tangosol.coherence.config.xml.processor.AddressProviderBuilderProcessor;
import com.tangosol.coherence.config.xml.processor.SocketProviderProcessor;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.ChainedParameterResolver;
import com.tangosol.config.expression.ScopedParameterResolver;
import com.tangosol.config.expression.SystemEnvironmentParameterResolver;
import com.tangosol.config.expression.SystemPropertyParameterResolver;
import com.tangosol.config.xml.DefaultProcessingContext;
import com.tangosol.config.xml.DocumentProcessor;
import com.tangosol.config.xml.NamespaceHandler;
import com.tangosol.internal.net.InetAddressRangeFilter;
import com.tangosol.internal.net.LegacyXmlConfigHelper;
import com.tangosol.internal.net.cluster.DefaultClusterDependencies;
import com.tangosol.internal.net.cluster.DefaultMemberIdentity;
import com.tangosol.internal.net.cluster.LegacyXmlConfigurableQuorumPolicy;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.AddressProviderFactory;
import com.tangosol.net.CompositeAddressProvider;
import com.tangosol.net.ConfigurableAddressProviderFactory;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.internal.SubstitutionAddressProvider;
import com.tangosol.persistence.ConfigurableSnapshotArchiverFactory;
import com.tangosol.persistence.SnapshotArchiverFactory;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.SimpleResourceRegistry;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LegacyXmlClusterDependencies
extends DefaultClusterDependencies {
    public LegacyXmlClusterDependencies fromXml(XmlElement xml) {
        Base.azzert(xml.getName().equals("cluster-config"));
        DocumentProcessor.DefaultDependencies dependencies = new DocumentProcessor.DefaultDependencies(new OperationalConfigNamespaceHandler());
        SimpleResourceRegistry resourceRegistry = new SimpleResourceRegistry();
        ScopedParameterResolver resolver = AccessController.doPrivileged(new PrivilegedAction<ScopedParameterResolver>(){

            @Override
            public ScopedParameterResolver run() {
                return new ScopedParameterResolver(new ChainedParameterResolver(new SystemPropertyParameterResolver(), new SystemEnvironmentParameterResolver()));
            }
        });
        dependencies.setResourceRegistry(resourceRegistry);
        dependencies.setDefaultParameterResolver(resolver);
        dependencies.setExpressionParser(ParameterMacroExpressionParser.INSTANCE);
        dependencies.setClassLoader(Base.getContextClassLoader());
        DefaultProcessingContext ctxClusterConfig = new DefaultProcessingContext(dependencies, xml);
        NamespaceHandler handler = dependencies.getDefaultNamespaceHandler();
        if (handler != null) {
            ctxClusterConfig.ensureNamespaceHandler("", handler);
        }
        ctxClusterConfig.addCookie(ParameterizedBuilderRegistry.class, this.getBuilderRegistry());
        ctxClusterConfig.addCookie(DefaultClusterDependencies.class, this);
        XmlElement xmlPasswordProviders = xml.getSafeElement("password-providers");
        DefaultProcessingContext ctxPasswordProviders = new DefaultProcessingContext(ctxClusterConfig, xmlPasswordProviders);
        ctxPasswordProviders.processDocument(xmlPasswordProviders);
        ctxPasswordProviders.close();
        XmlElement xmlSocketProviders = xml.getSafeElement("socket-providers");
        DefaultProcessingContext ctxSocketProviders = new DefaultProcessingContext(ctxClusterConfig, xmlSocketProviders);
        ctxSocketProviders.processDocument(xmlSocketProviders);
        ctxSocketProviders.close();
        DefaultMemberIdentity memberIdentity = new DefaultMemberIdentity();
        this.configureMemberIdentity(xml, memberIdentity);
        this.configureMulticastListener(xml);
        this.configureAddressProviders(xml);
        XmlElement xmlUnicastSocketProvider = xml.getSafeElement("unicast-listener").getSafeElement("socket-provider");
        DefaultProcessingContext ctxUnicastSocketProvider = new DefaultProcessingContext(ctxClusterConfig, xmlUnicastSocketProvider);
        SocketProviderBuilder builder = new SocketProviderProcessor().process(ctxUnicastSocketProvider, xmlUnicastSocketProvider);
        this.setUnicastSocketProviderBuilder(builder);
        this.configureUnicastListener(xml, memberIdentity);
        this.setMemberIdentity(memberIdentity);
        this.configureTcpRingListener(xml);
        this.configureShutdownListener(xml);
        this.configureServiceGuardian(xml);
        this.configurePacketSpeaker(xml);
        this.configurePacketPublisher(xml);
        this.configureIncomingMessageHandler(xml);
        this.configureOutgoingMessageHandler(xml);
        this.configureAuthorizedHosts(xml);
        this.configureServices(xml);
        this.configureFilters(xml);
        this.configureSnapshotArchivers(xml);
        this.configureClusterQuorumPolicy(xml);
        String sEdition = xml.getSafeElement("edition-name").getString("CE");
        this.setEdition(this.translateEditionName(sEdition));
        String sMode = xml.getSafeElement("license-mode").getString("dev");
        this.setMode(this.translateModeName(sMode));
        XmlElement xmlStorageAuthorizers = xml.getSafeElement("storage-authorizers");
        DefaultProcessingContext ctxStorageAuthorizers = new DefaultProcessingContext(ctxClusterConfig, xmlStorageAuthorizers);
        ctxStorageAuthorizers.processDocument(xmlStorageAuthorizers);
        XmlElement xmlSerializers = xml.getSafeElement("serializers");
        DefaultProcessingContext ctxSerializers = new DefaultProcessingContext(ctxClusterConfig, xmlSerializers);
        ctxSerializers.processDocument(xmlSerializers);
        XmlElement xmlEnv = xml.getSafeElement("persistence-environments");
        DefaultProcessingContext ctxPersistenceEnvironments = new DefaultProcessingContext(ctxClusterConfig, xmlEnv);
        ctxPersistenceEnvironments.processDocument(xmlEnv);
        ctxUnicastSocketProvider.close();
        ctxSerializers.close();
        ctxStorageAuthorizers.close();
        ctxPersistenceEnvironments.close();
        ctxClusterConfig.close();
        return this;
    }

    private void configureMemberIdentity(XmlElement xml, DefaultMemberIdentity memberIdentity) {
        XmlElement xmlCat = xml.getSafeElement("member-identity");
        memberIdentity.setClusterName(xmlCat.getSafeElement("cluster-name").getString(memberIdentity.getClusterName()));
        memberIdentity.setSiteName(xmlCat.getSafeElement("site-name").getString(memberIdentity.getSiteName()));
        memberIdentity.setRackName(xmlCat.getSafeElement("rack-name").getString(memberIdentity.getRackName()));
        memberIdentity.setMachineName(xmlCat.getSafeElement("machine-name").getString(memberIdentity.getMachineName()));
        memberIdentity.setProcessName(xmlCat.getSafeElement("process-name").getString(memberIdentity.getProcessName()));
        memberIdentity.setMemberName(xmlCat.getSafeElement("member-name").getString(memberIdentity.getMemberName()));
        memberIdentity.setRoleName(xmlCat.getSafeElement("role-name").getString(memberIdentity.getRoleName()));
        memberIdentity.setPriority(xmlCat.getSafeElement("priority").getInt(memberIdentity.getPriority()));
    }

    private void configureMulticastListener(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("multicast-listener");
        this.setGroupInterface(this.resolveGroupInterface(xmlCat.getSafeElement("interface").getString("")));
        this.setGroupAddress(this.resolveGroupAddress(xmlCat.getSafeElement("address").getString("239.192.0.0")));
        this.setGroupPort(xmlCat.getSafeElement("port").getInt(this.getGroupPort()));
        this.setGroupTimeToLive(xmlCat.getSafeElement("time-to-live").getInt(this.getGroupTimeToLive()));
        XmlElement xmlSub = xmlCat.getSafeElement("packet-buffer");
        XmlElement xmlVal = xmlSub.getElement("maximum-packets");
        if (xmlVal == null) {
            this.setGroupBufferSize((int)Base.parseMemorySize(xmlSub.getSafeElement("size").getString(Integer.toString(this.getGroupBufferSize()))));
        } else {
            this.setGroupBufferSize(-xmlVal.getInt());
            if (xmlSub.getElement("size") != null) {
                throw new IllegalArgumentException("cannot specify maximum-packets and size within packet-buffer");
            }
        }
        this.setGroupListenerPriority(xmlCat.getSafeElement("priority").getInt(this.getGroupListenerPriority()));
        this.setClusterAnnounceTimeoutMillis(xmlCat.getSafeElement("join-timeout-milliseconds").getInt(this.getClusterAnnounceTimeoutMillis()));
        this.setPublisherGroupThreshold(xmlCat.getSafeElement("multicast-threshold-percent").getInt(this.getPublisherGroupThreshold()));
    }

    private void configureUnicastListener(XmlElement xml, DefaultMemberIdentity memberIdentity) {
        XmlElement xmlCat = xml.getSafeElement("unicast-listener");
        this.setUnicastSocketProviderXml(xmlCat.getSafeElement("socket-provider"));
        this.setReliableTransport(xmlCat.getSafeElement("reliable-transport").getString(this.getReliableTransport()));
        this.setTcpDatagramSocketOptions(SocketOptions.load(xmlCat.getSafeElement("socket-options")));
        memberIdentity.setMachineId(Integer.parseInt(xmlCat.getSafeElement("machine-id").getString("0")));
        String sAddr = xmlCat.getSafeElement("address").getString();
        if (sAddr != null && !sAddr.trim().isEmpty()) {
            try {
                this.setLocalAddress(InetAddressHelper.getLocalAddress(sAddr));
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("unresolvable localhost " + sAddr, e);
            }
        }
        this.setLocalPort(xmlCat.getSafeElement("port").getInt(this.getLocalPort()));
        XmlElement xmlValue = xmlCat.getSafeElement("port-auto-adjust");
        String sPortAuto = xmlValue.getString().trim();
        if (sPortAuto.length() > 0 && Character.isDigit(sPortAuto.charAt(0))) {
            this.setLocalPortAutoAdjust(xmlValue.getInt(this.getLocalPortAutoAdjust()));
        } else {
            this.setLocalPortAutoAdjust(xmlValue.getBoolean(this.isLocalPortAutoAdjust()));
        }
        XmlElement xmlSub = xmlCat.getSafeElement("packet-buffer");
        XmlElement xmlVal = xmlSub.getElement("maximum-packets");
        if (xmlVal == null) {
            this.setLocalBufferSize((int)Base.parseMemorySize(xmlSub.getSafeElement("size").getString(Integer.toString(this.getLocalBufferSize()))));
        } else {
            this.setLocalBufferSize(-xmlVal.getInt());
            if (xmlSub.getElement("size") != null) {
                throw new IllegalArgumentException("cannot specify maximum-packets and size within packet-buffer");
            }
        }
        this.setLocalListenerPriority(xmlCat.getSafeElement("priority").getInt(this.getLocalListenerPriority()));
        this.setWellKnownAddresses(this.createWkaAddressProvider(xmlCat.getSafeElement("well-known-addresses")));
        String sAddrDiscovery = xmlCat.getSafeElement("discovery-address").getString();
        if (sAddrDiscovery != null && !sAddrDiscovery.trim().isEmpty()) {
            try {
                this.setLocalDiscoveryAddress(InetAddressHelper.getLocalAddress(sAddrDiscovery));
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("unresolvable discovery address " + sAddrDiscovery, e);
            }
        }
    }

    private void configureTcpRingListener(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("tcp-ring-listener");
        this.setTcpRingEnabled(xmlCat.getSafeElement("enabled").getBoolean(this.isTcpRingEnabled()));
        this.setIpMonitorTimeoutMillis(XmlHelper.parseTime(xmlCat, "ip-timeout", this.getIpMonitorTimeoutMillis()));
        this.setIpMonitorAttempts(xmlCat.getSafeElement("ip-attempts").getInt(this.getIpMonitorAttempts()));
        this.setTcpBacklog(xmlCat.getSafeElement("listen-backlog").getInt(this.getTcpBacklog()));
        this.setIpMonitorPriority(xmlCat.getSafeElement("priority").getInt(this.getIpMonitorPriority()));
        this.setTcpRingSocketOptions(SocketOptions.load(xmlCat.getSafeElement("socket-options")));
    }

    private void configureShutdownListener(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("shutdown-listener");
        String sShutdownOption = xmlCat.getSafeElement("enabled").getString();
        int nShutdownOption = this.getShutdownHookOption();
        if (sShutdownOption.equals("force") || sShutdownOption.equals("true")) {
            nShutdownOption = 1;
        } else if (sShutdownOption.equals("none") || sShutdownOption.equals("false")) {
            nShutdownOption = 0;
        } else if (sShutdownOption.equals("graceful")) {
            nShutdownOption = 2;
        }
        this.setShutdownHookOption(nShutdownOption);
    }

    private void configureServiceGuardian(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("service-guardian");
        XmlElement xmlSub = xmlCat.getSafeElement("service-failure-policy");
        ServiceFailurePolicyBuilder builder = LegacyXmlConfigHelper.parseServiceFailurePolicyBuilder(xmlSub);
        if (builder != null) {
            this.setServiceFailurePolicyBuilder(builder);
        }
        this.setGuardTimeoutMillis(xmlCat.getSafeElement("timeout-milliseconds").getLong(this.getGuardTimeoutMillis()));
    }

    private void configurePacketSpeaker(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("packet-speaker");
        this.setSpeakerEnabled(xmlCat.getSafeElement("enabled").getBoolean(this.isSpeakerEnabled()));
        XmlElement xmlSub = xmlCat.getSafeElement("volume-threshold");
        this.setSpeakerVolumeMinimum(xmlSub.getSafeElement("minimum-packets").getInt(this.getSpeakerVolumeMinimum()));
        this.setSpeakerPriority(xmlCat.getSafeElement("priority").getInt(this.getSpeakerPriority()));
    }

    private void configurePacketPublisher(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("packet-publisher");
        XmlElement xmlSub = xmlCat.getSafeElement("packet-size");
        this.setPacketMaxLength(xmlSub.getSafeElement("maximum-length").getInt(this.getPacketMaxLength()));
        this.setPacketPreferredLength(xmlSub.getSafeElement("preferred-length").getInt(this.getPacketPreferredLength()));
        xmlSub = xmlCat.getSafeElement("packet-delivery");
        this.setPublisherResendDelayMillis(xmlSub.getSafeElement("resend-milliseconds").getInt(this.getPublisherResendDelayMillis()));
        this.setPublisherResendTimeoutMillis(xmlSub.getSafeElement("timeout-milliseconds").getInt(this.getPublisherResendTimeoutMillis()));
        this.setClusterHeartbeatDelayMillis(xmlSub.getSafeElement("heartbeat-milliseconds").getInt(this.getClusterHeartbeatDelayMillis()));
        XmlElement xmlSub2 = xmlSub.getSafeElement("flow-control");
        this.setFlowControlEnabled(xmlSub2.getSafeElement("enabled").getBoolean(this.isFlowControlEnabled()));
        this.setLostPacketThreshold(xmlSub2.getSafeElement("pause-detection/maximum-packets").getInt(this.getLostPacketThreshold()));
        XmlElement xmlVal = xmlSub2.getSafeElement("outstanding-packets");
        this.setOutstandingPacketMaximum(xmlVal.getSafeElement("maximum-packets").getInt(this.getOutstandingPacketMaximum()));
        this.setOutstandingPacketMinimum(xmlVal.getSafeElement("minimum-packets").getInt(this.getOutstandingPacketMinimum()));
        xmlSub2 = xmlSub.getSafeElement("packet-bundling");
        String sTime = xmlSub2.getSafeElement("maximum-deferral-time").getString();
        if (sTime.length() > 0) {
            this.setPacketBundlingThresholdNanos(Base.parseTimeNanos(sTime));
        }
        this.setPacketBundlingAggression(xmlSub2.getSafeElement("aggression-factor").getDouble(this.getPacketBundlingAggression()));
        xmlSub = xmlCat.getSafeElement("notification-queueing");
        this.setPublisherAckDelayMillis(xmlSub.getSafeElement("ack-delay-milliseconds").getInt(this.getPublisherAckDelayMillis()));
        this.setPublisherNackDelayMillis(xmlSub.getSafeElement("nack-delay-milliseconds").getInt(this.getPublisherNackDelayMillis()));
        xmlSub = xmlCat.getSafeElement("traffic-jam");
        this.setPublisherCloggedCount(xmlSub.getSafeElement("maximum-packets").getInt(this.getPublisherCloggedCount()));
        this.setPublisherCloggedDelayMillis(xmlSub.getSafeElement("pause-milliseconds").getInt(this.getPublisherCloggedDelayMillis()));
        xmlSub = xmlCat.getSafeElement("packet-buffer");
        xmlVal = xmlSub.getElement("maximum-packets");
        if (xmlVal == null) {
            this.setPublisherSocketBufferSize((int)Base.parseMemorySize(xmlSub.getSafeElement("size").getString(Integer.toString(this.getPublisherSocketBufferSize()))));
        } else {
            this.setPublisherSocketBufferSize(-xmlVal.getInt());
            if (xmlSub.getElement("size") != null) {
                throw new IllegalArgumentException("cannot specify maximum-packets and size within packet-buffer");
            }
        }
        this.setPublisherPriority(xmlCat.getSafeElement("priority").getInt(this.getPublisherPriority()));
        this.setTcmpEnabled(xmlCat.getSafeElement("enabled").getBoolean(this.isTcmpEnabled()));
    }

    private void configureIncomingMessageHandler(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("incoming-message-handler");
        this.setClusterTimestampMaxVarianceMillis(xmlCat.getSafeElement("maximum-time-variance").getInt(this.getClusterTimestampMaxVarianceMillis()));
        this.setReceiverNackEnabled(xmlCat.getSafeElement("use-nack-packets").getBoolean(this.isReceiverNackEnabled()));
        this.setReceiverPriority(xmlCat.getSafeElement("priority").getInt(this.getReceiverPriority()));
    }

    private void configureOutgoingMessageHandler(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("outgoing-message-handler");
        SafeLinkedList listFilter = new SafeLinkedList();
        listFilter.addAll(this.parseFilterList(xmlCat));
        this.setFilterList(listFilter);
    }

    private void configureAuthorizedHosts(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("authorized-hosts");
        XmlElement xmlVal = xmlCat.getElement("host-filter");
        if (xmlVal != null && !XmlHelper.isEmpty(xmlVal)) {
            this.setAuthorizedHostFilter((Filter)XmlHelper.createInstance(xmlVal, null, null, Filter.class));
            return;
        }
        InetAddressRangeFilter filter = new InetAddressRangeFilter();
        boolean fFilterAdded = false;
        Iterator iter = xmlCat.getElements("host-address");
        while (iter.hasNext()) {
            xmlVal = (XmlElement)iter.next();
            if (!this.addAuthorizedHostsToFilter(filter, xmlVal.getString(), null)) continue;
            fFilterAdded = true;
        }
        iter = xmlCat.getElements("host-range");
        while (iter.hasNext()) {
            xmlVal = (XmlElement)iter.next();
            if (!this.addAuthorizedHostsToFilter(filter, xmlVal.getSafeElement("from-address").getString(), xmlVal.getSafeElement("to-address").getString())) continue;
            fFilterAdded = true;
        }
        if (fFilterAdded) {
            this.setAuthorizedHostFilter(filter);
        }
    }

    private void configureServices(XmlElement xml) {
        LiteMap<String, String> mapService = new LiteMap<String, String>();
        LiteMap<String, List<String>> mapServiceFilter = new LiteMap<String, List<String>>();
        Iterator iter = xml.getSafeElement("services").getElements("service");
        while (iter.hasNext()) {
            XmlElement xmlService = (XmlElement)iter.next();
            String sType = xmlService.getSafeElement("service-type").getString();
            String sComponent = xmlService.getSafeElement("service-component").getString();
            mapService.put(sType, sComponent);
            mapServiceFilter.put(sType, this.parseFilterList(xmlService));
        }
        this.setServiceMap(mapService);
        this.setServiceFilterMap(mapServiceFilter);
    }

    private void configureFilters(XmlElement xml) {
        LiteMap<String, WrapperStreamFactory> mapFilter = new LiteMap<String, WrapperStreamFactory>();
        Iterator iter = xml.getSafeElement("filters").getElements("filter");
        while (iter.hasNext()) {
            XmlElement xmlFilter = (XmlElement)iter.next();
            this.addFilterToMap(xmlFilter, mapFilter);
        }
        this.setFilterMap(mapFilter);
    }

    private void configureSnapshotArchivers(XmlElement xml) {
        LiteMap<String, SnapshotArchiverFactory> mapSnapshotArchivers = new LiteMap<String, SnapshotArchiverFactory>();
        for (XmlElement xmlSnapshotArchivers : xml.getSafeElement("snapshot-archivers").getElementList()) {
            String sName = xmlSnapshotArchivers.getSafeAttribute("id").getString();
            ConfigurableSnapshotArchiverFactory factory = new ConfigurableSnapshotArchiverFactory();
            factory.setConfig(xmlSnapshotArchivers);
            mapSnapshotArchivers.put(sName, factory);
        }
        this.setSnapshotArchiverMap(mapSnapshotArchivers);
    }

    private void configureAddressProviders(XmlElement xml) {
        AddressProviderFactory factoryCluster;
        LiteMap<String, AddressProviderFactory> mapAddressProvider = new LiteMap<String, AddressProviderFactory>();
        if (this.createWkaAddressProvider(xml.getSafeElement("unicast-listener").getSafeElement("well-known-addresses")) == null) {
            ListBasedAddressProviderBuilder factoryMulticast = new ListBasedAddressProviderBuilder();
            factoryMulticast.add(this.getGroupAddress().getHostAddress(), this.getGroupPort());
            factoryCluster = factoryMulticast;
        } else {
            factoryCluster = SubstitutionAddressProvider.createFactory(LegacyXmlConfigHelper.parseAddressProvider("well-known-addresses", xml.getSafeElement("unicast-listener"), mapAddressProvider), this.getGroupPort());
        }
        mapAddressProvider.put("cluster-discovery", factoryCluster);
        Iterator iter = xml.getSafeElement("address-providers").getElements("address-provider");
        while (iter.hasNext()) {
            XmlElement xmlAddressProvider = (XmlElement)iter.next();
            String sName = xmlAddressProvider.getSafeAttribute("id").getString();
            XmlElement xmlLocalAddress = xmlAddressProvider.getElement("local-address");
            if (mapAddressProvider.containsKey(sName)) {
                throw new ConfigurationException("address provider '" + sName + "' has already been defined", "remove duplicate provider definition");
            }
            if (xmlLocalAddress == null) {
                ConfigurableAddressProviderFactory factory = new ConfigurableAddressProviderFactory();
                factory.setConfig(xmlAddressProvider);
                mapAddressProvider.put(sName, factory);
                continue;
            }
            AddressProviderBuilder addressProviderBuilder = AddressProviderBuilderProcessor.newLocalAddressProviderBuilder(xmlLocalAddress);
        }
        this.setAddressProviderMap(mapAddressProvider);
    }

    private void configureClusterQuorumPolicy(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("cluster-quorum-policy");
        this.setClusterActionPolicyBuilder(new LegacyXmlConfigurableQuorumPolicy().createPolicyBuilder(xmlCat, null, Base.getContextClassLoader()));
    }

    private boolean addAuthorizedHostsToFilter(InetAddressRangeFilter filter, String sAddrFrom, String sAddrTo) {
        InetAddress addrTo;
        InetAddress addrFrom;
        if (sAddrFrom == null || sAddrFrom.length() == 0) {
            if (sAddrTo != null && sAddrTo.length() != 0) {
                this.ensureAuthorizedHostFilter();
                Base.azzertFailed("Both <from-ip> and <to-ip> elements must be specified");
            }
            return false;
        }
        try {
            addrFrom = InetAddress.getByName(sAddrFrom);
            addrTo = sAddrTo == null ? addrFrom : InetAddress.getByName(sAddrTo);
        }
        catch (UnknownHostException e) {
            Base.trace("Unresolvable authorized host will be ignored: " + e);
            return false;
        }
        filter.addRange(addrFrom, addrTo);
        return true;
    }

    private void addFilterToMap(XmlElement xmlFilter, Map<String, WrapperStreamFactory> mapFilter) {
        String sClass = xmlFilter.getSafeElement("filter-class").getString();
        String sName = xmlFilter.getSafeElement("filter-name").getString();
        if (sName.length() == 0) {
            sName = xmlFilter.getSafeAttribute("id").getString();
        }
        SimpleElement xmlConfig = new SimpleElement("filter");
        XmlElement xmlInstance = xmlConfig.ensureElement("instance");
        xmlInstance.ensureElement("class-name").setString(sClass);
        XmlElement xmlParams = xmlFilter.getElement("init-params");
        if (xmlParams != null) {
            xmlInstance.getElementList().add(xmlParams);
        }
        try {
            WrapperStreamFactory factory = (WrapperStreamFactory)XmlHelper.createInstance(xmlConfig, Base.getContextClassLoader(), null, WrapperStreamFactory.class);
            mapFilter.put(sName, factory);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Error instantiating Filter with name: " + sName);
        }
    }

    private AddressProvider createWkaAddressProvider(XmlElement xml) {
        AddressProviderFactory factory = LegacyXmlConfigHelper.parseAddressProvider(xml, this.getAddressProviderMap());
        AddressProvider provider = new SubstitutionAddressProvider(factory.createAddressProvider(null), this.getGroupPort());
        if (!(provider instanceof Set)) {
            CompositeAddressProvider providerComposite = new CompositeAddressProvider();
            providerComposite.addProvider(provider);
            provider = providerComposite;
        }
        return ((Set)((Object)provider)).isEmpty() ? null : provider;
    }

    private void ensureAuthorizedHostFilter() {
        Filter filter = this.getAuthorizedHostFilter();
        if (filter == null) {
            this.setAuthorizedHostFilter(new InetAddressRangeFilter());
        }
    }

    private List<String> parseFilterList(XmlElement xml) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = xml.getSafeElement("use-filters").getElements("filter-name");
        while (iter.hasNext()) {
            String sName = ((XmlElement)iter.next()).getString();
            if (sName.length() <= 0) continue;
            list.add(sName);
        }
        return list.size() == 0 ? Collections.EMPTY_LIST : list;
    }

    private InetAddress resolveGroupAddress(String sAddr) {
        InetAddress addr = null;
        if (sAddr != null && sAddr.trim().length() > 0) {
            try {
                addr = InetAddress.getByName(sAddr);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Address=" + sAddr);
            }
        }
        return addr;
    }

    private InetAddress resolveGroupInterface(String sAddr) {
        InetAddress addr = null;
        if (sAddr != null && sAddr.trim().length() > 0) {
            try {
                addr = InetAddresses.getLocalAddress(sAddr);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Interface=" + sAddr);
            }
        }
        return addr;
    }

    private int translateEditionName(String sName) {
        Base.checkNotNull(sName, "Edition name");
        String[] asNames = new String[]{"DC", "RTC", "SE", "CE", "EE", "GE"};
        for (int i = 0; i < asNames.length; ++i) {
            if (!asNames[i].equalsIgnoreCase(sName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid edition name " + sName);
    }

    private int translateModeName(String sName) {
        Base.checkNotNull(sName, "Mode ");
        String[] names = new String[]{"eval", "dev", "prod"};
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(sName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid mode " + sName);
    }
}

