/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.management;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.service.grid.DefaultProxyServiceDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlProxyServiceHelper;
import com.tangosol.internal.net.service.grid.ProxyServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.HttpAcceptorDependencies;
import com.tangosol.net.Cluster;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.Service;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class HttpHelper {
    public static final int DEFAULT_MANAGEMENT_OVER_REST_PORT = 30000;

    public static URL composeURL(String sHost, int nPort) throws MalformedURLException {
        return HttpHelper.composeURL(sHost, nPort, "http");
    }

    public static URL composeURL(String sHost, int nPort, String sProtocol) throws MalformedURLException {
        return new URL(sProtocol, sHost, nPort, "/management/coherence/cluster");
    }

    public static String getServiceName() {
        return "ManagementHttpProxy";
    }

    public static boolean isHttpCapable(ClassLoader classLoader) {
        try {
            classLoader.loadClass("com.tangosol.coherence.management.internal.ManagementResourceConfig");
        }
        catch (Throwable t) {
            Logger.finest("One or more libraries are missing for management over HTTP: " + t);
            return false;
        }
        return true;
    }

    public static boolean startService(Cluster cluster) {
        ClassLoader classLoader = cluster.getContextClassLoader();
        if (HttpHelper.isHttpCapable(classLoader)) {
            ProxyServiceDependencies deps = null;
            try {
                String sConfigFile = "management-http-config.xml";
                URL urlConfig = classLoader.getResource(sConfigFile);
                if (urlConfig == null) {
                    throw new IllegalStateException("Unable to locate " + sConfigFile + " which should be resolvable from the coherence-management module on the class path.");
                }
                XmlDocument xml = XmlHelper.loadXml(urlConfig);
                XmlHelper.replaceSystemProperties(xml, "system-property");
                deps = LegacyXmlProxyServiceHelper.fromXml(xml, new DefaultProxyServiceDependencies(), (OperationalContext)((Object)cluster), classLoader);
                Service service = cluster.ensureService(HttpHelper.getServiceName(), "Proxy");
                service.setDependencies(deps);
                service.start();
                return true;
            }
            catch (Throwable t) {
                Throwable tCause;
                Throwable tOriginal = t instanceof RuntimeException ? Base.getOriginalException((RuntimeException)t) : t;
                Throwable throwable = tCause = tOriginal.getCause() == null ? tOriginal : tOriginal.getCause();
                if (tCause instanceof ClassNotFoundException) {
                    Logger.err("Management over HTTP is not available most likely due to this member missing the necessary libraries to run the service. Handled exception: " + tCause.getClass().getCanonicalName() + ": " + tCause.getLocalizedMessage());
                    return false;
                }
                HttpAcceptorDependencies depsHttpAcceptor = (HttpAcceptorDependencies)deps.getAcceptorDependencies();
                Logger.err("failed to start service " + HttpHelper.getServiceName() + " at address " + depsHttpAcceptor.getLocalAddress() + ":" + depsHttpAcceptor.getLocalPort() + " due to " + tCause.getClass().getSimpleName() + " : " + tCause.getLocalizedMessage());
                return false;
            }
        }
        Logger.err("Management over HTTP is not available most likely due to missing classes");
        return false;
    }
}

