/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.management;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.management.AbstractMultiCollector;
import com.tangosol.internal.net.management.CacheMBeanAttribute;
import com.tangosol.internal.net.management.CompositeDataCollector;
import com.tangosol.internal.net.management.MBeanAttribute;
import com.tangosol.internal.net.management.ServiceMBeanAttribute;
import com.tangosol.internal.net.management.TabularDataCollector;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Member;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.Base;
import com.tangosol.util.SetMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.NeverFilter;
import com.tangosol.util.filter.RegexFilter;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollectors;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collector;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularDataSupport;

public class MBeanCollectorFunction
implements Remote.Function<MBeanServer, Map<String, Object>> {
    protected static final char SERVICE_CACHE_SEPARATOR = '!';
    protected static final Remote.Comparator<Object> COMPARABLE_COMPARATOR = (o1, o2) -> {
        if (!(o1 instanceof Comparable)) {
            throw new IllegalArgumentException("Comparable type required for collector");
        }
        return ((Comparable)o1).compareTo(o2);
    };
    protected static final ValueExtractor<Object, Long> TO_LONG_FUNCTION = o -> o instanceof Number ? ((Number)o).longValue() : Long.parseLong(String.valueOf(o));
    protected static final ValueExtractor<Object, Integer> TO_INT_FUNCTION = o -> o instanceof Number ? ((Number)o).intValue() : Integer.parseInt(String.valueOf(o));
    protected static final ValueExtractor<Object, Double> TO_DOUBLE_FUNCTION = o -> o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble(String.valueOf(o));
    protected static final Map<String, String> MBEAN_TYPES = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("cache", "type=Cache");
            this.put("storage", "type=StorageManager");
            this.put("service", "type=Service");
        }
    });
    protected static final String COLLECTOR_DESCRIPTOR = "rest.collector";
    protected final String f_sLocator;
    protected final String f_sAttribute;
    protected final String f_sCollector;
    protected final MBeanAccessor.QueryBuilder.ParsedQuery f_query;

    public MBeanCollectorFunction(String sLocator, String sAttribute, String sCollector, MBeanAccessor.QueryBuilder.ParsedQuery query) {
        this.f_sLocator = sLocator;
        this.f_sAttribute = sAttribute;
        this.f_sCollector = sCollector;
        this.f_query = query;
    }

    @Override
    public Map<String, Object> apply(MBeanServer mbs) {
        Set<ObjectName> colNames;
        boolean fAllAttributes = MBeanCollectorFunction.isOmitted(this.f_sAttribute);
        QueryExp query = this.createQuery();
        String sObjectQuery = this.f_query.getQuery();
        IdentityHashMap mapObjectNames = new IdentityHashMap(2);
        ObjectName objName = null;
        try {
            objName = new ObjectName(sObjectQuery);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Malformed ObjectName: '" + objName + "', Query: '" + query + '\'', e);
        }
        try {
            colNames = mbs.queryNames(objName, query);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Illegal query; ObjectName: '" + objName + "', Query: '" + query + '\'', e);
        }
        Iterator iterNames = colNames.iterator();
        if (iterNames.hasNext()) {
            try {
                MBeanInfo info = mbs.getMBeanInfo((ObjectName)iterNames.next());
                MBeanAttributeInfo[] aAttribute = info.getAttributes();
                HashSet<String> setAttributeName = new HashSet<String>(aAttribute.length);
                for (MBeanAttributeInfo attribute : aAttribute) {
                    setAttributeName.add(attribute.getName());
                }
                mapObjectNames.put(setAttributeName, colNames);
            }
            catch (InstanceNotFoundException ex) {
                Logger.log("MBeanCollector#apply(objName=" + objName + "): ignoring InstanceNotFoundException: " + ex.getMessage(), 6);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        if (!fAllAttributes) {
            Iterator iter = mapObjectNames.keySet().iterator();
            while (iter.hasNext()) {
                Set setAttributeName = (Set)iter.next();
                setAttributeName.retainAll(Collections.singletonList(this.f_sAttribute));
                if (!setAttributeName.isEmpty()) continue;
                iter.remove();
            }
            if (mapObjectNames.isEmpty()) {
                throw Base.ensureRuntimeException(new AttributeNotFoundException("Attribute \"" + this.f_sAttribute + "\" cannot be found"));
            }
        }
        Collector collector = MBeanCollectorFunction.createCollector(objName, this.f_sCollector, mbs);
        BiConsumer<Map, MBeanSnapshot> accumulator = collector.accumulator();
        Map mapResult = (Map)collector.supplier().get();
        MBeanSnapshot snapshot = new MBeanSnapshot();
        for (Map.Entry entry : mapObjectNames.entrySet()) {
            Set setAttributeNames = (Set)entry.getKey();
            for (ObjectName objectName : (Collection)entry.getValue()) {
                SetMap<String, Object> mapAttributes = new SetMap<String, Object>(setAttributeNames, sAttributeName -> {
                    try {
                        return mbs.getAttribute(objectName, (String)sAttributeName);
                    }
                    catch (InstanceNotFoundException ex) {
                        Logger.log("MBeanCollectorFunction#apply(objName=" + objectName + ",attribute=" + sAttributeName + "): ignoring InstanceNotFoundException: " + ex.getMessage(), 6);
                        return null;
                    }
                    catch (Exception e) {
                        throw Base.ensureRuntimeException(e);
                    }
                });
                accumulator.accept(mapResult, snapshot.reset(objectName, mapAttributes));
            }
        }
        mapResult = (Map)collector.finisher().apply(mapResult);
        return mapResult;
    }

    protected QueryExp createQuery() {
        String sNodeIdRegex = this.f_sLocator;
        if (MBeanCollectorFunction.isOmitted(sNodeIdRegex)) {
            return new MBeanHelper.QueryExpFilter(AlwaysFilter.INSTANCE());
        }
        try {
            if (sNodeIdRegex.matches(".*[A-Za-z]+.*")) {
                StringBuilder sb = new StringBuilder();
                String sDelim = "";
                Set<Member> setMembers = CacheFactory.ensureCluster().getMemberSet();
                for (Member member : setMembers) {
                    if (!member.getRoleName().matches(sNodeIdRegex)) continue;
                    sb.append(sDelim).append(member.getId());
                    sDelim = "|";
                }
                sNodeIdRegex = sb.toString();
            }
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid Regular Expression: '" + sNodeIdRegex + "'", e);
        }
        return new MBeanHelper.QueryExpFilter(sNodeIdRegex.isEmpty() ? NeverFilter.INSTANCE() : new RegexFilter(new ReflectionExtractor("getKeyProperty", new Object[]{"nodeId"}), sNodeIdRegex));
    }

    protected static <T extends Map<String, Object>> Collector<MBeanSnapshot, T, T> createCollector(ObjectName objName, String sCollector, MBeanServer mbs) {
        if (sCollector == null || sCollector.isEmpty()) {
            Class clzEnum;
            Supplier<Collector<Object, Object, Object>> supplier = RemoteCollectors::toList;
            String sType = objName.getKeyProperty("type");
            if (sType == null) {
                return new MultiAttributeCollector(supplier, null, mbs);
            }
            switch (sType) {
                case "Cache": {
                    clzEnum = CacheMBeanAttribute.class;
                    break;
                }
                case "Service": {
                    clzEnum = ServiceMBeanAttribute.class;
                    break;
                }
                default: {
                    supplier = null;
                    clzEnum = null;
                }
            }
            return new MultiAttributeCollector(supplier, clzEnum, mbs);
        }
        return new MultiAttributeCollector(() -> MBeanCollectorFunction.createAttributeCollector(sCollector));
    }

    public static Collector createAttributeCollector(String sCollector) {
        switch (sCollector.toLowerCase()) {
            case "all": {
                return RemoteCollectors.summarizingLong(TO_LONG_FUNCTION);
            }
            case "avg": {
                return RemoteCollectors.averagingLong(TO_LONG_FUNCTION);
            }
            case "count": {
                return RemoteCollectors.counting();
            }
            case "list": {
                return RemoteCollectors.toList();
            }
            case "max": {
                return RemoteCollectors.maxBy(COMPARABLE_COMPARATOR);
            }
            case "min": {
                return RemoteCollectors.minBy(COMPARABLE_COMPARATOR);
            }
            case "set": {
                return RemoteCollectors.toSet();
            }
            case "sum": {
                return RemoteCollectors.summingLong(TO_LONG_FUNCTION);
            }
            case "intsummary": {
                return RemoteCollectors.summarizingInt(TO_INT_FUNCTION);
            }
            case "longsummary": {
                return RemoteCollectors.summarizingLong(TO_LONG_FUNCTION);
            }
            case "doublesummary": {
                return RemoteCollectors.summarizingDouble(TO_DOUBLE_FUNCTION);
            }
        }
        throw new IllegalArgumentException("The specified collector is not recognized: " + sCollector);
    }

    protected static boolean isOmitted(String s) {
        return s == null || "*".equals(s) || "all".equals(s);
    }

    public static Collector createTypeBasedCollector(Object oValue) {
        if (oValue instanceof Integer) {
            return MBeanCollectorFunction.createAttributeCollector("intsummary");
        }
        if (oValue instanceof Long) {
            return MBeanCollectorFunction.createAttributeCollector("longsummary");
        }
        if (oValue instanceof Double) {
            return MBeanCollectorFunction.createAttributeCollector("doublesummary");
        }
        if (oValue instanceof Float) {
            return MBeanCollectorFunction.createAttributeCollector("doublesummary");
        }
        if (oValue instanceof CompositeData) {
            return new CompositeDataCollector();
        }
        if (oValue instanceof TabularDataSupport) {
            return new TabularDataCollector();
        }
        if (oValue instanceof String) {
            return MBeanCollectorFunction.createAttributeCollector("list");
        }
        return null;
    }

    protected static class MultiAttributeCollector<T extends Map<String, Object>>
    extends AbstractMultiCollector {
        protected final Class<? extends Enum> f_clzEnum;
        protected final Supplier<Collector<Object, Object, Object>> f_supplierCollector;
        protected final MBeanServer f_server;

        protected MultiAttributeCollector(Supplier<Collector<Object, Object, Object>> supplierCollector) {
            this(supplierCollector, null, null);
        }

        protected MultiAttributeCollector(Supplier<Collector<Object, Object, Object>> supplierCollector, Class<? extends Enum> clzEnum, MBeanServer server) {
            this.f_clzEnum = clzEnum;
            this.f_supplierCollector = supplierCollector;
            this.f_server = server;
        }

        public BiConsumer<T, MBeanSnapshot> accumulator() {
            return (mapResult, snapshot) -> {
                for (Map.Entry<String, Object> entry : snapshot.getAttributes().entrySet()) {
                    String sAttribute = entry.getKey();
                    Object oValue = ATTRIBUTE_NULLIFIER.apply(entry.getValue());
                    if (oValue == null) continue;
                    Collector collector = (Collector)this.f_mapCollector.get(sAttribute);
                    if (collector == null) {
                        collector = this.findCollector(snapshot.getObjectName(), sAttribute, oValue);
                        if (collector == null) continue;
                        this.f_mapCollector.put(sAttribute, new CachedCollector(collector));
                        mapResult.put(sAttribute, collector.supplier().get());
                    }
                    collector.accumulator().accept(mapResult.get(sAttribute), oValue);
                }
            };
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return null;
        }

        protected Collector findCollector(ObjectName objName, String sAttribute, Object oAttributeValue) {
            MBeanAttribute enumAttr = this.getMBeanAttribute(sAttribute);
            if (enumAttr == null) {
                try {
                    MBeanAttributeInfo[] aAttribute;
                    MBeanInfo info = this.f_server == null ? null : this.f_server.getMBeanInfo(objName);
                    for (MBeanAttributeInfo attrInfo : aAttribute = info == null ? new MBeanAttributeInfo[]{} : info.getAttributes()) {
                        Collector collector;
                        if (!sAttribute.equals(attrInfo.getName())) continue;
                        String sCollector = (String)attrInfo.getDescriptor().getFieldValue(MBeanCollectorFunction.COLLECTOR_DESCRIPTOR);
                        Collector collector2 = collector = sCollector == null || sCollector.isEmpty() ? MBeanCollectorFunction.createTypeBasedCollector(oAttributeValue) : MBeanCollectorFunction.createAttributeCollector(sCollector);
                        if (collector == null) continue;
                        return collector;
                    }
                    return this.f_supplierCollector == null ? null : this.f_supplierCollector.get();
                }
                catch (InstanceNotFoundException ex) {
                    Logger.log("MBeanCollectorFunction#findCollector(objName=" + objName + "): ignoring InstanceNotFoundException: " + ex.getMessage(), 6);
                    return null;
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e);
                }
            }
            return enumAttr.isVisible() ? enumAttr.collector() : null;
        }

        protected MBeanAttribute getMBeanAttribute(String sName) {
            try {
                return this.f_clzEnum == null ? null : (MBeanAttribute)((Object)Enum.valueOf(this.f_clzEnum, sName));
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    public static class CachedCollector<T, A, R>
    implements Collector<T, A, R> {
        protected final Collector<T, A, R> f_collector;
        protected Supplier<A> m_supplier;
        protected BiConsumer<A, T> m_accumulator;
        protected BinaryOperator<A> m_combiner;
        protected Function<A, R> m_finisher;

        public CachedCollector(Collector<T, A, R> collector) {
            Objects.requireNonNull(collector);
            this.f_collector = collector;
        }

        @Override
        public Supplier<A> supplier() {
            if (this.m_supplier == null) {
                this.m_supplier = this.f_collector.supplier();
            }
            return this.m_supplier;
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            if (this.m_accumulator == null) {
                this.m_accumulator = this.f_collector.accumulator();
            }
            return this.m_accumulator;
        }

        @Override
        public BinaryOperator<A> combiner() {
            if (this.m_combiner == null) {
                this.m_combiner = this.f_collector.combiner();
            }
            return this.m_combiner;
        }

        @Override
        public Function<A, R> finisher() {
            if (this.m_finisher == null) {
                this.m_finisher = this.f_collector.finisher();
            }
            return this.m_finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.f_collector.characteristics();
        }
    }

    protected static class MBeanSnapshot {
        protected ObjectName m_objName;
        protected Map<String, Object> m_mapAttributes;

        protected MBeanSnapshot() {
        }

        protected MBeanSnapshot reset(ObjectName objName, Map<String, Object> mapAttributes) {
            this.m_objName = objName;
            this.m_mapAttributes = mapAttributes;
            return this;
        }

        protected Map<String, Object> getAttributes() {
            return this.m_mapAttributes;
        }

        protected ObjectName getObjectName() {
            return this.m_objName;
        }
    }
}

