/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.metrics;

import com.tangosol.internal.net.metrics.Clock;
import com.tangosol.internal.net.metrics.EWMA;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class Meter {
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private final EWMA m1Rate = EWMA.oneMinuteEWMA();
    private final EWMA m5Rate = EWMA.fiveMinuteEWMA();
    private final EWMA m15Rate = EWMA.fifteenMinuteEWMA();
    private final LongAdder count = new LongAdder();
    private final long startTime;
    private final AtomicLong lastTick;
    private final Clock clock;

    public Meter() {
        this(Clock.system());
    }

    Meter(Clock clock) {
        this.startTime = clock.nanoTick();
        this.lastTick = new AtomicLong(this.startTime);
        this.clock = clock;
    }

    public void mark() {
        this.mark(1L);
    }

    public void mark(long n) {
        this.tickIfNecessary();
        this.count.add(n);
        this.m1Rate.update(n);
        this.m5Rate.update(n);
        this.m15Rate.update(n);
    }

    public long getCount() {
        return this.count.sum();
    }

    public double getFifteenMinuteRate() {
        this.tickIfNecessary();
        return this.m15Rate.getRate(TimeUnit.SECONDS);
    }

    public double getFiveMinuteRate() {
        this.tickIfNecessary();
        return this.m5Rate.getRate(TimeUnit.SECONDS);
    }

    public double getMeanRate() {
        if (this.getCount() == 0L) {
            return 0.0;
        }
        double elapsed = this.clock.nanoTick() - this.startTime;
        return (double)this.getCount() / elapsed * (double)TimeUnit.SECONDS.toNanos(1L);
    }

    public double getOneMinuteRate() {
        this.tickIfNecessary();
        return this.m1Rate.getRate(TimeUnit.SECONDS);
    }

    private void tickIfNecessary() {
        long newIntervalStartTick;
        long oldTick = this.lastTick.get();
        long newTick = this.clock.nanoTick();
        long age = newTick - oldTick;
        if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTick, newIntervalStartTick = newTick - age % TICK_INTERVAL)) {
            long requiredTicks = age / TICK_INTERVAL;
            for (long i = 0L; i < requiredTicks; ++i) {
                this.m1Rate.tick();
                this.m5Rate.tick();
                this.m15Rate.tick();
            }
        }
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getCount());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Meter that = (Meter)o;
        return this.getCount() == that.getCount();
    }
}

