/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.security;

import com.tangosol.internal.net.security.DefaultStandardDependencies;
import com.tangosol.internal.net.security.LegacyXmlSecurityHelper;
import com.tangosol.net.security.AccessController;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import javax.security.auth.callback.CallbackHandler;

public class LegacyXmlStandardHelper {
    public static DefaultStandardDependencies fromXml(XmlElement xml, DefaultStandardDependencies deps) {
        LegacyXmlSecurityHelper.fromXml(xml, deps);
        if (deps.isEnabled()) {
            XmlElement xmlAC = xml.getSafeElement("access-controller");
            XmlElement xmlCH = xml.getSafeElement("callback-handler");
            AccessController controller = (AccessController)LegacyXmlStandardHelper.newInstance(xmlAC);
            if (controller == null) {
                throw new RuntimeException("The 'access-controller' configuration element must be specified");
            }
            CallbackHandler handler = (CallbackHandler)LegacyXmlStandardHelper.newInstance(xmlCH);
            deps.setAccessController(controller);
            deps.setCallbackHandler(handler);
            deps.setLoginModuleName(xml.getSafeElement("login-module-name").getString(deps.getLoginModuleName()));
        }
        return deps;
    }

    private static Object newInstance(XmlElement xmlConfig) {
        String sClass = xmlConfig.getSafeElement("class-name").getString();
        if (sClass.length() > 0) {
            XmlElement xmlParams = xmlConfig.getSafeElement("init-params");
            Object[] aoParam = XmlHelper.parseInitParams(xmlParams);
            try {
                Class clz = ExternalizableHelper.loadClass(sClass, null, null);
                return ClassHelper.newInstance(clz, aoParam);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        return null;
    }
}

