/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.grid;

import com.tangosol.coherence.config.builder.ActionPolicyBuilder;
import com.tangosol.coherence.config.builder.ProxyServiceLoadBalancerBuilder;
import com.tangosol.coherence.config.builder.ServiceLoadBalancerBuilder;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.extend.proxy.CacheServiceProxyDependencies;
import com.tangosol.internal.net.service.extend.proxy.InvocationServiceProxyDependencies;
import com.tangosol.internal.net.service.grid.DefaultGridDependencies;
import com.tangosol.internal.net.service.grid.ProxyServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.AcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.DefaultTcpAcceptorDependencies;
import com.tangosol.util.Base;

public class DefaultProxyServiceDependencies
extends DefaultGridDependencies
implements ProxyServiceDependencies {
    private AcceptorDependencies m_acceptorDependencies = new DefaultTcpAcceptorDependencies();
    private CacheServiceProxyDependencies m_cacheServiceProxyDependencies;
    private InvocationServiceProxyDependencies m_invocationServiceProxyDependencies;
    private ServiceLoadBalancerBuilder m_bldrLoadBalancer = new ProxyServiceLoadBalancerBuilder(null, null);

    public DefaultProxyServiceDependencies() {
        this(null);
    }

    public DefaultProxyServiceDependencies(ProxyServiceDependencies deps) {
        super(deps);
        if (deps == null) {
            this.setWorkerThreadCountMin(1);
        } else {
            this.m_acceptorDependencies = deps.getAcceptorDependencies();
            this.m_bldrLoadBalancer = deps.getLoadBalancerBuilder();
            this.m_cacheServiceProxyDependencies = deps.getCacheServiceProxyDependencies();
            this.m_invocationServiceProxyDependencies = deps.getInvocationServiceProxyDependencies();
        }
    }

    @Override
    @Injectable(value="proxy-quorum-policy-scheme")
    public void setActionPolicyBuilder(ActionPolicyBuilder builder) {
        super.setActionPolicyBuilder(builder);
    }

    @Override
    public AcceptorDependencies getAcceptorDependencies() {
        return this.m_acceptorDependencies;
    }

    @Injectable(value="acceptor-config")
    public void setAcceptorDependencies(AcceptorDependencies deps) {
        this.m_acceptorDependencies = deps;
    }

    @Override
    public CacheServiceProxyDependencies getCacheServiceProxyDependencies() {
        return this.m_cacheServiceProxyDependencies;
    }

    @Injectable(value="proxy-config/cache-service-proxy")
    public void setCacheServiceProxyDependencies(CacheServiceProxyDependencies deps) {
        this.m_cacheServiceProxyDependencies = deps;
    }

    @Override
    public InvocationServiceProxyDependencies getInvocationServiceProxyDependencies() {
        return this.m_invocationServiceProxyDependencies;
    }

    @Injectable(value="proxy-config/invocation-service-proxy")
    public void setInvocationServiceProxyDependencies(InvocationServiceProxyDependencies deps) {
        this.m_invocationServiceProxyDependencies = deps;
    }

    @Override
    public ServiceLoadBalancerBuilder getLoadBalancerBuilder() {
        return this.m_bldrLoadBalancer;
    }

    @Injectable(value="load-balancer")
    public void setLoadBalancerBuilder(ServiceLoadBalancerBuilder bldrLoadBalancer) {
        this.m_bldrLoadBalancer = bldrLoadBalancer;
    }

    @Override
    public DefaultProxyServiceDependencies validate() {
        super.validate();
        Base.checkNotNull(this.getAcceptorDependencies(), "Acceptor");
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "{AcceptorDependencies=" + this.getAcceptorDependencies() + ", ActionPolicyBuilder=" + this.getActionPolicyBuilder() + ", CacheServiceProxyDependencies=" + this.getCacheServiceProxyDependencies() + ", InvocationServiceProxyDependencies=" + this.getInvocationServiceProxyDependencies() + ", LoadBalancerBuilder=" + this.getLoadBalancerBuilder() + "}";
    }
}

