/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.peer.acceptor;

import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.peer.DefaultPeerDependencies;
import com.tangosol.internal.net.service.peer.acceptor.AcceptorDependencies;
import com.tangosol.util.Base;

public abstract class AbstractAcceptorDependencies
extends DefaultPeerDependencies
implements AcceptorDependencies {
    private int m_cConnectionLimit;

    public AbstractAcceptorDependencies() {
        this(null);
    }

    public AbstractAcceptorDependencies(AcceptorDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_cConnectionLimit = deps.getConnectionLimit();
        }
    }

    @Override
    public int getConnectionLimit() {
        return this.m_cConnectionLimit;
    }

    @Injectable(value="connection-limit")
    public void setConnectionLimit(int cLimit) {
        this.m_cConnectionLimit = cLimit;
    }

    @Override
    public AbstractAcceptorDependencies validate() {
        super.validate();
        Base.azzert(this.getConnectionLimit() >= 0, "Connection limit cannot be less than 0");
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "{ConnectionLimit=" + this.getConnectionLimit() + "}";
    }
}

