/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicPublisher;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicSubscriber;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.CacheService;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.Service;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.net.topic.Publisher;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.Base;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.PartitionedFilter;
import java.util.Set;
import java.util.stream.Collectors;

public class PagedTopic<V>
implements NamedTopic<V>,
ClassLoaderAware {
    private final PagedTopicCaches f_pagedTopicCaches;

    public PagedTopic(PagedTopicCaches pagedTopicCaches) {
        this.f_pagedTopicCaches = pagedTopicCaches;
    }

    @Override
    public <U> Subscriber<U> createSubscriber(Subscriber.Option<? super V, U> ... options) {
        this.ensureActive();
        return new PagedTopicSubscriber<U>(this.f_pagedTopicCaches, options);
    }

    @Override
    public void destroySubscriberGroup(String sGroupName) {
        if (sGroupName == null) {
            throw new IllegalArgumentException("invalid group name");
        }
        PagedTopicSubscriber.destroy(this.f_pagedTopicCaches, SubscriberGroupId.withName(sGroupName));
    }

    @Override
    public Set<String> getSubscriberGroups() {
        int cParts = ((PartitionedService)((Object)this.f_pagedTopicCaches.Subscriptions.getCacheService())).getPartitionCount();
        PartitionSet setPart = new PartitionSet(cParts);
        setPart.add(Base.getRandom().nextInt(cParts));
        Set setSubs = this.f_pagedTopicCaches.Subscriptions.keySet(new PartitionedFilter(AlwaysFilter.INSTANCE(), setPart));
        return setSubs.stream().filter(key -> key.getGroupId().getMemberTimestamp() == 0L).map(key -> key.getGroupId().getGroupName()).collect(Collectors.toSet());
    }

    @Override
    public Publisher<V> createPublisher(Publisher.Option<? super V> ... options) {
        this.ensureActive();
        return new PagedTopicPublisher<V>(this.f_pagedTopicCaches, options);
    }

    @Override
    public void destroy() {
        this.f_pagedTopicCaches.destroy();
    }

    @Override
    public Service getService() {
        return this.getCacheService();
    }

    public CacheService getCacheService() {
        return this.f_pagedTopicCaches.getCacheService();
    }

    @Override
    public String getName() {
        return this.f_pagedTopicCaches.getTopicName();
    }

    @Override
    public void release() {
        if (this.f_pagedTopicCaches.isActive()) {
            this.f_pagedTopicCaches.close();
        }
    }

    @Override
    public boolean isActive() {
        return this.f_pagedTopicCaches.isActive();
    }

    @Override
    public boolean isDestroyed() {
        return this.f_pagedTopicCaches.isDestroyed();
    }

    @Override
    public boolean isReleased() {
        return this.f_pagedTopicCaches.isReleased();
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.f_pagedTopicCaches.getContextClassLoader();
    }

    @Override
    public void setContextClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagedTopic that = (PagedTopic)o;
        return !(this.f_pagedTopicCaches == null ? that.f_pagedTopicCaches != null : !this.f_pagedTopicCaches.equals(that.f_pagedTopicCaches));
    }

    public int hashCode() {
        return this.f_pagedTopicCaches != null ? this.f_pagedTopicCaches.hashCode() : 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(name=" + this.f_pagedTopicCaches.getTopicName() + ")";
    }

    protected void ensureActive() {
        if (!this.f_pagedTopicCaches.isActive()) {
            throw new IllegalStateException("This topic is no longer active");
        }
    }
}

