/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged;

import com.tangosol.internal.net.topic.impl.paged.Configuration;
import com.tangosol.internal.net.topic.impl.paged.model.NotificationKey;
import com.tangosol.internal.net.topic.impl.paged.model.Page;
import com.tangosol.internal.net.topic.impl.paged.model.Position;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.internal.net.topic.impl.paged.model.Usage;
import com.tangosol.internal.util.Primes;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.Serializer;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.Releasable;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.util.HashHelper;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class PagedTopicCaches
implements Closeable,
ClassLoaderAware {
    protected final String f_sTopicName;
    protected final CacheService f_cacheService;
    protected Set<NamedCache> f_setCaches;
    public final NamedCache<Page.Key, Page> Pages;
    public final NamedCache<Position, Object> Data;
    public final NamedCache<Subscription.Key, Subscription> Subscriptions;
    public final NamedCache<NotificationKey, int[]> Notifications;
    public final NamedCache<Usage.Key, Usage> Usages;

    public PagedTopicCaches(String sName, CacheService cacheService) {
        this(sName, cacheService, null);
    }

    public PagedTopicCaches(String sName, CacheService cacheService, BiFunction<String, ClassLoader, NamedCache> functionCache) {
        if (sName == null || sName.isEmpty()) {
            throw new IllegalArgumentException("The name argument cannot be null or empty String");
        }
        if (cacheService == null) {
            throw new IllegalArgumentException("The cacheService argument cannot be null");
        }
        if (functionCache == null) {
            functionCache = cacheService::ensureCache;
        }
        this.f_sTopicName = sName;
        this.f_cacheService = cacheService;
        this.Pages = functionCache.apply(Names.PAGES.cacheNameForTopicName(sName), this.f_cacheService.getContextClassLoader());
        this.Data = functionCache.apply(Names.CONTENT.cacheNameForTopicName(sName), this.f_cacheService.getContextClassLoader());
        this.Subscriptions = functionCache.apply(Names.SUBSCRIPTIONS.cacheNameForTopicName(sName), this.f_cacheService.getContextClassLoader());
        this.Notifications = functionCache.apply(Names.NOTIFICATIONS.cacheNameForTopicName(sName), this.f_cacheService.getContextClassLoader());
        this.Usages = functionCache.apply(Names.USAGE.cacheNameForTopicName(sName), this.f_cacheService.getContextClassLoader());
        this.f_setCaches = new HashSet<NamedCache>();
        HashSet<NamedCache> setCaches = this.f_setCaches;
        setCaches.add(this.Pages);
        setCaches.add(this.Data);
        setCaches.add(this.Subscriptions);
        setCaches.add(this.Notifications);
        setCaches.add(this.Usages);
    }

    public Serializer getSerializer() {
        return this.f_cacheService.getSerializer();
    }

    public void destroy() {
        this.close(true);
    }

    public boolean isActive() {
        return this.Pages.isActive();
    }

    public boolean isDestroyed() {
        return this.Pages.isDestroyed();
    }

    public boolean isReleased() {
        return this.Pages.isReleased();
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.f_cacheService.getContextClassLoader();
    }

    @Override
    public void setContextClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException();
    }

    public String getTopicName() {
        return this.f_sTopicName;
    }

    public int getBasePage() {
        return Math.abs(this.f_sTopicName.hashCode() % this.getPartitionCount());
    }

    public int getPartitionCount() {
        return ((PartitionedService)((Object)this.f_cacheService)).getPartitionCount();
    }

    public int getChannelCount() {
        return PagedTopicCaches.getChannelCount(this.getPartitionCount());
    }

    public static int getChannelCount(int cPartitions) {
        return Math.min(cPartitions, Primes.next((int)Math.sqrt(cPartitions)));
    }

    public int newNotifierId() {
        return 1 + ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
    }

    public Set<NotificationKey> getPartitionNotifierSet(int nNotifier) {
        HashSet<NotificationKey> setKey = new HashSet<NotificationKey>();
        int c = this.getPartitionCount();
        for (int i = 0; i < c; ++i) {
            setKey.add(new NotificationKey(i, nNotifier));
        }
        return setKey;
    }

    public int getUnitOfOrder(int nPartition) {
        return this.f_sTopicName.hashCode() + nPartition;
    }

    public CacheService getCacheService() {
        return this.f_cacheService;
    }

    public Configuration getConfiguration() {
        return this.f_cacheService.getResourceRegistry().getResource(Configuration.class, this.getTopicName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagedTopicCaches that = (PagedTopicCaches)o;
        return this.f_sTopicName.equals(that.f_sTopicName) && this.f_cacheService.equals(that.f_cacheService);
    }

    public int hashCode() {
        return HashHelper.hash(this.f_sTopicName, 31);
    }

    public String toString() {
        return "TopicCaches(name='" + this.f_sTopicName + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean fDestroy) {
        Consumer<NamedCache> function;
        Consumer<NamedCache> consumer = function = fDestroy ? NamedCollection::destroy : Releasable::release;
        if (this.f_setCaches != null) {
            PagedTopicCaches pagedTopicCaches = this;
            synchronized (pagedTopicCaches) {
                if (this.f_setCaches != null) {
                    this.f_setCaches.stream().forEach(function);
                    this.f_setCaches = null;
                }
            }
        }
    }

    public static class Names<K, V> {
        private static final Set<Names> s_setValues = new HashSet<Names>();
        public static final String METACACHE_PREFIX = "$meta$topic";
        public static final Names<Position, Object> CONTENT = new Names<Position, Object>("content", "$topic$", Position.class, Object.class, Storage.Data);
        public static final Names<Page.Key, Page> PAGES = new Names<Page.Key, Page>("pages", "$meta$topic$pages$", Page.Key.class, Page.class, Storage.MetaData);
        public static final Names<Subscription.Key, Subscription> SUBSCRIPTIONS = new Names<Subscription.Key, Subscription>("subscriptions", "$meta$topic$subscriptions$", Subscription.Key.class, Subscription.class, Storage.MetaData);
        public static final Names<NotificationKey, int[]> NOTIFICATIONS = new Names<NotificationKey, int[]>("notifications", "$meta$topic$notifications$", NotificationKey.class, int[].class, Storage.MetaData);
        public static final Names<Usage.Key, Usage> USAGE = new Names<Usage.Key, Usage>("usage", "$meta$topic$usage$", Usage.Key.class, Usage.class, Storage.Data);
        private final String f_sName;
        private final String f_sPrefix;
        private final Class<K> f_classKey;
        private final Class<V> f_classValue;
        private final TypeAssertion<K, V> f_typeAssertion;
        private final Storage f_storage;

        private Names(String sName, String sPrefix, Class<K> classKey, Class<V> classValue, Storage storage) {
            this.f_sName = sName;
            this.f_sPrefix = sPrefix;
            this.f_classKey = classKey;
            this.f_classValue = classValue;
            this.f_typeAssertion = TypeAssertion.withTypes(this.f_classKey, this.f_classValue);
            this.f_storage = storage;
            s_setValues.add(this);
        }

        public String cacheNameForTopicName(String sTopicName) {
            return this.f_sPrefix + sTopicName;
        }

        public static Names fromCacheName(String sCacheName) {
            for (Names pagedTopicCacheNames : Names.values()) {
                if (!sCacheName.startsWith(pagedTopicCacheNames.f_sPrefix)) continue;
                return pagedTopicCacheNames;
            }
            throw new IllegalArgumentException("Cache name " + sCacheName + " is not a valid TopicCacheName");
        }

        public static String getTopicName(String sCacheName) {
            for (Names pagedTopicCacheNames : Names.values()) {
                if (!sCacheName.startsWith(pagedTopicCacheNames.f_sPrefix)) continue;
                return sCacheName.substring(pagedTopicCacheNames.f_sPrefix.length());
            }
            return sCacheName;
        }

        public static Set<Names> values() {
            return Collections.unmodifiableSet(s_setValues);
        }

        public TypeAssertion<K, V> getTypeAssertion() {
            return this.f_typeAssertion;
        }

        public String getPrefix() {
            return this.f_sPrefix;
        }

        public Class<K> getKeyClass() {
            return this.f_classKey;
        }

        public Class<V> getValueClass() {
            return this.f_classValue;
        }

        public Storage getStorage() {
            return this.f_storage;
        }

        public boolean isInternal() {
            return Storage.MetaData.equals((Object)this.getStorage());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Names names = (Names)o;
            return this.f_sName.equals(names.f_sName);
        }

        public int hashCode() {
            return this.f_sName.hashCode();
        }

        public String toString() {
            return this.f_sName;
        }

        public static enum Storage {
            Data,
            MetaData;

        }
    }
}

