/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged;

import com.oracle.coherence.common.base.Converter;
import com.oracle.coherence.common.collections.Arrays;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.net.topic.impl.paged.Configuration;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.internal.net.topic.impl.paged.agent.OfferProcessor;
import com.tangosol.internal.net.topic.impl.paged.agent.PollProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.NotificationKey;
import com.tangosol.internal.net.topic.impl.paged.model.Page;
import com.tangosol.internal.net.topic.impl.paged.model.Position;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.internal.net.topic.impl.paged.model.Usage;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.Member;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapNotFoundException;
import com.tangosol.util.ObservableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;

public class PagedTopicPartition {
    public static final long PUBLISHER_NOTIFICATION_EXPIRY_MILLIS = new Duration(Config.getProperty("coherence.pagedTopic.publisherNotificationExpiry", "10s")).as(Duration.Magnitude.MILLI);
    protected final BackingMapManagerContext f_ctxManager;
    protected final String f_sName;
    protected final int f_nPartition;

    public PagedTopicPartition(BackingMapManagerContext ctxManager, String sName, int nPartition) {
        this.f_ctxManager = ctxManager;
        this.f_sName = sName;
        this.f_nPartition = nPartition;
    }

    public long initialiseTopic(BinaryEntry<Usage.Key, Usage> entry) {
        Usage usage = (Usage)entry.getValue();
        if (usage == null) {
            usage = new Usage();
        }
        if (usage.getPublicationTail() == -1L) {
            long lPage = Math.abs(this.f_sName.hashCode() % this.getPartitionCount());
            usage.setPublicationTail(lPage);
            entry.setValue(usage);
        }
        return usage.getPublicationTail();
    }

    public static PagedTopicPartition ensureTopic(BinaryEntry entry) {
        BackingMapContext ctx = entry.getBackingMapContext();
        return new PagedTopicPartition(ctx.getManagerContext(), PagedTopicCaches.Names.getTopicName(ctx.getCacheName()), ctx.getManagerContext().getKeyPartition(entry.getBinaryKey()));
    }

    protected OfferProcessor.Result onStartOfPage(int nChannel, long lPage, Page page, int nNotifyPostFull, int cElements, long cbCapServer, int cbCapPage) {
        this.cleanupNonDurableSubscribers(this.peekUsage(nChannel).getAnonymousSubscribers());
        if (!page.isSubscribed() && !this.getTopicConfiguration().isRetainConsumed()) {
            page.setSealed(true);
            this.removePageIfNotRetainingElements(nChannel, lPage);
            return new OfferProcessor.Result(OfferProcessor.Result.Status.PageSealed, cElements, cbCapPage);
        }
        if (cbCapServer > 0L && this.getStorageBytes() >= cbCapServer) {
            if (nNotifyPostFull != 0) {
                this.requestRemovalNotification(nNotifyPostFull, nChannel);
            }
            int c = this.getChannelCount();
            for (int i = 0; i < c; ++i) {
                Usage usage = this.peekUsage(i);
                long lTail = usage.getPartitionTail();
                if (lTail == -1L || lTail != usage.getPartitionHead()) continue;
                Page pageSeal = this.enlistPage(i, usage.getPartitionHead());
                pageSeal.setSealed(true);
                this.notifyAll(pageSeal.resetInsertionNotifiers());
            }
            return new OfferProcessor.Result(OfferProcessor.Result.Status.TopicFull, 0, cbCapPage);
        }
        return null;
    }

    public OfferProcessor.Result offerToPageTail(BinaryEntry<Page.Key, Page> entry, List<Binary> listElements, int nNotifyPostFull, boolean fSealPage) {
        int cbRemainingCapacity;
        OfferProcessor.Result result;
        Page page;
        int cbCapPageDyn;
        Page.Key keyPage = (Page.Key)entry.getKey();
        int nChannel = keyPage.getChannelId();
        long lPage = keyPage.getPageId();
        Configuration configuration = this.getTopicConfiguration();
        int cbCapPage = configuration.getPageCapacity();
        long cbCapServer = configuration.getServerCapacity();
        if (cbCapServer > 0L && nNotifyPostFull != 0 && cbCapPage > (cbCapPageDyn = (int)Math.min(Integer.MAX_VALUE, cbCapServer / 2L / (long)this.getLocalPartitionCount()))) {
            cbCapPage = Math.max(1, cbCapPageDyn);
        }
        if ((page = this.ensurePage(nChannel, entry)) == null || page.isSealed()) {
            return new OfferProcessor.Result(OfferProcessor.Result.Status.PageSealed, 0, 0);
        }
        if (page.getTail() == -1 && (result = this.onStartOfPage(nChannel, lPage, page, nNotifyPostFull, listElements.size(), cbCapServer, cbCapPage)) != null) {
            return result;
        }
        BackingMapContext ctxContent = this.getBackingMapContext(PagedTopicCaches.Names.CONTENT);
        long cMillisExpiry = configuration.getElementExpiryMillis();
        int cbPage = page.getByteSize();
        int nTail = page.getTail();
        OfferProcessor.Result.Status status = OfferProcessor.Result.Status.Success;
        int cAccepted = 0;
        Iterator<Binary> iter = listElements.iterator();
        while (iter.hasNext() && cbPage < cbCapPage) {
            Binary binElement = iter.next();
            Binary binKey = Position.toBinary(this.f_nPartition, nChannel, lPage, ++nTail);
            BinaryEntry binElementEntry = (BinaryEntry)ctxContent.getBackingMapEntry(binKey);
            cbPage += binElement.length();
            binElementEntry.updateBinaryValue(binElement);
            if (cMillisExpiry > 0L) {
                binElementEntry.expire(cMillisExpiry);
            }
            ++cAccepted;
        }
        page.setTail(nTail);
        if (cbPage >= cbCapPage || fSealPage) {
            page.setSealed(true);
            status = OfferProcessor.Result.Status.PageSealed;
            cbRemainingCapacity = cbCapPage;
        } else {
            cbRemainingCapacity = cbCapPage - cbPage;
        }
        page.setByteSize(cbPage);
        this.notifyAll(page.resetInsertionNotifiers());
        entry.setValue(page);
        return new OfferProcessor.Result(status, cAccepted, cbRemainingCapacity);
    }

    protected Usage enlistUsage(int nChannel) {
        Usage usage;
        BinaryEntry<Usage.Key, Usage> entry = this.enlistBackingMapEntry(PagedTopicCaches.Names.USAGE, this.toBinaryKey(new Usage.Key(this.getPartition(), nChannel)));
        Usage usage2 = usage = entry == null ? null : (Usage)entry.getValue();
        if (usage == null) {
            usage = new Usage();
        }
        entry.setValue(usage);
        return usage;
    }

    protected Usage peekUsage(int nChannel) {
        BinaryEntry<Usage.Key, Usage> entry = this.peekBackingMapEntry(PagedTopicCaches.Names.USAGE, this.toBinaryKey(new Usage.Key(this.getPartition(), nChannel)));
        return entry == null ? this.enlistUsage(nChannel) : (Usage)entry.getValue();
    }

    protected Page ensurePage(int nChannel, BinaryEntry<Page.Key, Page> entry) {
        Usage usage;
        if (entry.isPresent()) {
            return (Page)entry.getValue();
        }
        long lPage = ((Page.Key)entry.getKey()).getPageId();
        if (lPage <= (usage = this.enlistUsage(nChannel)).getPartitionMax()) {
            return null;
        }
        Page page = new Page();
        long lTailPrev = usage.getPartitionTail();
        usage.setPartitionTail(lPage);
        usage.setPartitionMax(lPage);
        if (lTailPrev == -1L) {
            usage.setPartitionHead(lPage);
        } else {
            page.adjustReferenceCount(1);
            this.enlistPage(nChannel, lTailPrev).setNextPartitionPage(lPage);
        }
        page.adjustReferenceCount(usage.resetWaitingSubscriberCount());
        entry.setValue(page);
        return page;
    }

    protected void cleanupSubscriberRegistrations() {
        int cChannel = this.getChannelCount();
        for (int nChannel = 0; nChannel < cChannel; ++nChannel) {
            Page page;
            int[] anNotifiers;
            Usage usage = this.enlistUsage(nChannel);
            long lTail = usage.getPartitionTail();
            if (lTail == -1L || (anNotifiers = (page = this.enlistPage(nChannel, lTail)).getInsertionNotifiers()) == null || anNotifiers.length < 2) continue;
            int[] anNew = new int[anNotifiers.length - 2];
            int of = ThreadLocalRandom.current().nextInt(anNotifiers.length - 1);
            System.arraycopy(anNotifiers, 0, anNew, 0, of);
            System.arraycopy(anNotifiers, of + 2, anNew, of, anNew.length - of);
            this.notifyAll(new int[]{anNotifiers[of], anNotifiers[of + 1]});
            page.setInsertionNotifies(anNew);
        }
    }

    protected void cleanupNonDurableSubscribers(Collection<SubscriberGroupId> colAnon) {
        if (colAnon == null || colAnon.isEmpty()) {
            return;
        }
        HashMap<Long, ArrayList<SubscriberGroupId>> mapDead = new HashMap<Long, ArrayList<SubscriberGroupId>>();
        for (SubscriberGroupId subscriberGroupId : colAnon) {
            Long ldtMember = subscriberGroupId.getMemberTimestamp();
            ArrayList<SubscriberGroupId> listPeer = (ArrayList<SubscriberGroupId>)mapDead.get(ldtMember);
            if (listPeer == null) {
                listPeer = new ArrayList<SubscriberGroupId>();
                mapDead.put(ldtMember, listPeer);
            }
            listPeer.add(subscriberGroupId);
        }
        for (Member member : this.f_ctxManager.getCacheService().getInfo().getServiceMembers()) {
            mapDead.remove(member.getTimestamp());
        }
        if (!mapDead.isEmpty()) {
            for (List list : mapDead.values()) {
                for (SubscriberGroupId subscriberGroupId : list) {
                    this.removeSubscription(subscriberGroupId);
                }
            }
        }
    }

    public int getPartition() {
        return this.f_nPartition;
    }

    public int getPartitionCount() {
        return ((PartitionedService)((Object)this.f_ctxManager.getCacheService())).getPartitionCount();
    }

    public int getChannelCount() {
        return PagedTopicCaches.getChannelCount(this.getPartitionCount());
    }

    public int getLocalPartitionCount() {
        PartitionedService service = (PartitionedService)((Object)this.f_ctxManager.getCacheService());
        return service.getOwnedPartitions(service.getCluster().getLocalMember()).cardinality();
    }

    public long getStorageBytes() {
        ObservableMap mapBack = this.getBackingMapContext(PagedTopicCaches.Names.CONTENT).getBackingMap();
        if (mapBack instanceof ConfigurableCacheMap) {
            ConfigurableCacheMap cacheBack = (ConfigurableCacheMap)mapBack;
            return (long)cacheBack.getUnits() * (long)cacheBack.getUnitFactor();
        }
        throw new UnsupportedOperationException();
    }

    protected Page peekPage(int nChannel, long lPageId) {
        BinaryEntry<Page.Key, Page> entry = this.peekBackingMapEntry(PagedTopicCaches.Names.PAGES, this.toBinaryKey(new Page.Key(nChannel, lPageId)));
        return entry == null ? null : (Page)entry.getValue();
    }

    protected BinaryEntry<Page.Key, Page> enlistPageEntry(int nChannel, long lPage) {
        BinaryEntry entry = (BinaryEntry)this.getBackingMapContext(PagedTopicCaches.Names.PAGES).getBackingMapEntry(this.toBinaryKey(new Page.Key(nChannel, lPage)));
        Page page = (Page)entry.getValue();
        if (page != null) {
            entry.setValue(page);
        }
        return entry;
    }

    protected Page enlistPage(int nChannel, long lPage) {
        return (Page)this.enlistPageEntry(nChannel, lPage).getValue();
    }

    public boolean removePageIfNotRetainingElements(int nChannel, long lPage) {
        Configuration configuration = this.getTopicConfiguration();
        if (configuration.isRetainConsumed()) {
            return false;
        }
        return this.removePage(nChannel, lPage);
    }

    public boolean removePage(int nChannel, long lPage) {
        BinaryEntry<Page.Key, Page> entryPage = this.enlistPageEntry(nChannel, lPage);
        Page page = (Page)entryPage.getValue();
        if (page == null) {
            return false;
        }
        BackingMapContext ctxElem = this.getBackingMapContext(PagedTopicCaches.Names.CONTENT);
        for (int nPos = page.getTail(); nPos >= 0; --nPos) {
            ctxElem.getBackingMapEntry(Position.toBinary(this.f_nPartition, nChannel, lPage, nPos)).remove(false);
        }
        Usage usage = this.enlistUsage(nChannel);
        if (usage.getPartitionTail() == lPage) {
            usage.setPartitionHead(-1L);
            usage.setPartitionTail(-1L);
        } else {
            usage.setPartitionHead(page.getNextPartitionPage());
        }
        entryPage.remove(false);
        this.notifyAll(usage.resetRemovalNotifiers());
        return true;
    }

    public void notifyAll(int[] anNotify) {
        if (anNotify != null) {
            BackingMapContext ctxNotify = this.getBackingMapContext(PagedTopicCaches.Names.NOTIFICATIONS);
            int nPart = this.getPartition();
            for (int nNotify : anNotify) {
                ctxNotify.getBackingMapEntry(this.toBinaryKey(new NotificationKey(nPart, nNotify))).remove(false);
            }
        }
    }

    public void removeSubscription(SubscriberGroupId subscriberGroupId) {
        BackingMapContext ctxSubscriptions = this.getBackingMapContext(PagedTopicCaches.Names.SUBSCRIPTIONS);
        int c = this.getChannelCount();
        for (int nChannel = 0; nChannel < c; ++nChannel) {
            long lPage;
            Page page;
            BinaryEntry entrySub = (BinaryEntry)ctxSubscriptions.getBackingMapEntry(this.toBinaryKey(new Subscription.Key(this.getPartition(), nChannel, subscriberGroupId)));
            Subscription subscription = (Subscription)entrySub.getValue();
            if (subscription == null) {
                return;
            }
            Usage usage = this.enlistUsage(nChannel);
            entrySub.remove(false);
            if (subscriberGroupId.getMemberTimestamp() != 0L) {
                usage.removeAnonymousSubscriber(subscriberGroupId);
            }
            Page page2 = page = (lPage = subscription.getPage()) == -1L ? null : this.enlistPage(nChannel, lPage);
            if (subscription.getPosition() == Integer.MAX_VALUE || page == null) {
                lPage = page == null ? usage.getPartitionHead() : page.getNextPartitionPage();
                if (lPage == -1L) {
                    usage.adjustWaitingSubscriberCount(-1);
                    page = null;
                } else {
                    page = this.enlistPage(nChannel, lPage);
                }
            }
            while (page != null && page.adjustReferenceCount(-1) == 0) {
                this.removePageIfNotRetainingElements(nChannel, lPage);
                lPage = page.getNextPartitionPage();
                page = lPage == -1L ? null : this.enlistPage(nChannel, lPage);
            }
        }
    }

    public long[] ensureSubscription(SubscriberGroupId subscriberGroupId, int nPhase, long[] alSubscriptionHeadGlobal, Filter filter, Function fnConvert) {
        BackingMapContext ctxSubscriptions = this.getBackingMapContext(PagedTopicCaches.Names.SUBSCRIPTIONS);
        Configuration configuration = this.getTopicConfiguration();
        long[] alResult = new long[this.getChannelCount()];
        switch (nPhase) {
            case 0: {
                this.cleanupSubscriberRegistrations();
                break;
            }
            case 1: {
                this.cleanupNonDurableSubscribers(this.enlistUsage(0).getAnonymousSubscribers());
                break;
            }
        }
        for (int nChannel = 0; nChannel < alResult.length; ++nChannel) {
            long lPage;
            BinaryEntry entrySub = (BinaryEntry)ctxSubscriptions.getBackingMapEntry(this.toBinaryKey(new Subscription.Key(this.getPartition(), nChannel, subscriberGroupId)));
            Subscription subscription = (Subscription)entrySub.getValue();
            Usage usage = this.enlistUsage(nChannel);
            if (nPhase == 0) {
                if (subscription == null || subscription.getSubscriptionHead() == -1L) {
                    return null;
                }
                if (!Base.equals(subscription.getFilter(), filter)) {
                    subscription.setFilter(filter);
                    entrySub.setValue(subscription);
                }
                if (!Base.equals(subscription.getConverter(), fnConvert)) {
                    subscription.setConverter(fnConvert);
                    entrySub.setValue(subscription);
                }
                alResult[nChannel] = subscription.getPosition() == Integer.MAX_VALUE ? -1L : subscription.getPage();
                continue;
            }
            if (nPhase == 1 && subscription == null) {
                subscription = new Subscription();
                if (subscriberGroupId.getMemberTimestamp() != 0L) {
                    this.enlistUsage(nChannel);
                    usage.addAnonymousSubscriber(subscriberGroupId);
                }
                long l = lPage = configuration.isRetainConsumed() ? usage.getPartitionHead() : usage.getPartitionTail();
                if (lPage == -1L) {
                    usage.adjustWaitingSubscriberCount(1);
                    lPage = usage.getPartitionMax();
                    subscription.setPage(lPage);
                    if (lPage != -1L) {
                        subscription.setPosition(Integer.MAX_VALUE);
                    }
                } else {
                    this.enlistPage(nChannel, lPage).adjustReferenceCount(1);
                    subscription.setPage(lPage);
                }
                subscription.setFilter(filter);
                subscription.setConverter(fnConvert);
                entrySub.setValue(subscription);
                alResult[nChannel] = lPage;
                continue;
            }
            if (nPhase == 2 && subscription.getSubscriptionHead() == -1L) {
                lPage = subscription.getPage();
                Page page = lPage == -1L ? null : this.enlistPage(nChannel, lPage);
                long lHead = usage.getPartitionHead();
                if (page == null && lHead != -1L) {
                    lPage = lHead;
                    page = this.enlistPage(nChannel, lPage);
                    subscription.setPage(lPage);
                    subscription.setPosition(0);
                }
                while (lPage < alSubscriptionHeadGlobal[nChannel] && page != null) {
                    long lPageNext = page.getNextPartitionPage();
                    if (page.adjustReferenceCount(-1) == 0) {
                        this.removePageIfNotRetainingElements(nChannel, lPage);
                    }
                    if (lPageNext == -1L) {
                        page = null;
                        usage.adjustWaitingSubscriberCount(1);
                        subscription.setPosition(Integer.MAX_VALUE);
                        continue;
                    }
                    lPage = lPageNext;
                    page = this.enlistPage(nChannel, lPage);
                    subscription.setPage(lPage);
                    page.adjustReferenceCount(1);
                }
                if (lPage == alSubscriptionHeadGlobal[nChannel] && page != null) {
                    int nPos = configuration.isRetainConsumed() ? 0 : page.getTail() + 1;
                    subscription.setPosition(nPos);
                }
                subscription.setSubscriptionHead(alSubscriptionHeadGlobal[nChannel]);
                entrySub.setValue(subscription);
                continue;
            }
            alResult[nChannel] = subscription.getPosition() == Integer.MAX_VALUE ? -1L : subscription.getPage();
        }
        return alResult;
    }

    public PollProcessor.Result pollFromPageHead(BinaryEntry<Subscription.Key, Subscription> entrySubscription, long lPage, int cReqValues, int nNotifierId) {
        int nPos;
        Subscription.Key keySubscription = (Subscription.Key)entrySubscription.getKey();
        Subscription subscription = (Subscription)entrySubscription.getValue();
        int nChannel = keySubscription.getChannelId();
        if (subscription == null) {
            return new PollProcessor.Result(-2, 0, null);
        }
        Page page = this.peekPage(nChannel, lPage);
        long lPageThis = subscription.getPage();
        if (lPage == lPageThis) {
            nPos = subscription.getPosition();
            if (lPage == -1L || nPos == Integer.MAX_VALUE) {
                return new PollProcessor.Result(-1, Integer.MAX_VALUE, null);
            }
        } else {
            if (lPage < lPageThis) {
                return new PollProcessor.Result(-1, Integer.MAX_VALUE, null);
            }
            if (page == null) {
                page = this.ensurePage(nChannel, this.enlistPageEntry(nChannel, lPage));
            }
            nPos = 0;
            subscription.setPage(lPage);
            subscription.setPosition(nPos);
        }
        entrySubscription.setValue(subscription);
        int nPosTail = page.getTail();
        BackingMapContext ctxElements = this.getBackingMapContext(PagedTopicCaches.Names.CONTENT);
        ArrayList<Binary> listValues = new ArrayList<Binary>(Math.min(cReqValues, nPosTail - nPos + 1));
        Filter filter = subscription.getFilter();
        Function fnConvert = subscription.getConverter();
        int cbResult = 0;
        long cbLimit = this.getTopicConfiguration().getMaxBatchSizeBytes();
        while (cReqValues > 0 && nPos <= nPosTail && (long)cbResult < cbLimit) {
            Binary binValue;
            Binary binPosKey = Position.toBinary(this.f_nPartition, nChannel, lPage, nPos);
            BinaryEntry entryElement = (BinaryEntry)ctxElements.getReadOnlyEntry(binPosKey);
            Binary binary = binValue = entryElement == null ? null : entryElement.getBinaryValue();
            if (binValue != null && (filter == null || InvocableMapHelper.evaluateEntry(filter, entryElement))) {
                if (fnConvert != null) {
                    Object oValue = this.getValueFromInternalConverter().convert(binValue);
                    Object oConverted = fnConvert.apply(oValue);
                    binValue = oConverted == null ? null : this.getValueToInternalConverter().convert(oConverted);
                }
                if (binValue != null) {
                    listValues.add(binValue);
                    cbResult += binValue.length();
                    --cReqValues;
                }
            }
            ++nPos;
        }
        if (nPos > nPosTail && page.isSealed()) {
            page = this.enlistPage(nChannel, lPage);
            long lPageNext = page.getNextPartitionPage();
            if (page.adjustReferenceCount(-1) == 0) {
                this.removePageIfNotRetainingElements(nChannel, lPage);
            }
            if (lPageNext == -1L) {
                this.enlistUsage(nChannel).adjustWaitingSubscriberCount(1);
                subscription.setPosition(Integer.MAX_VALUE);
            } else {
                subscription.setPage(lPageNext);
                subscription.setPosition(0);
                if (page.isSubscribed()) {
                    this.enlistPage(nChannel, lPageNext).adjustReferenceCount(1);
                }
            }
            return new PollProcessor.Result(-1, nPos, listValues);
        }
        subscription.setPosition(nPos);
        if (nPos > nPosTail) {
            this.requestInsertionNotification(this.enlistPage(nChannel, lPage), nNotifierId, nChannel);
        }
        return new PollProcessor.Result(nPosTail - nPos + 1, nPos, listValues);
    }

    protected void requestInsertionNotification(Page page, int nNotifyPostEmpty, int nChannel) {
        page.addInsertionNotifier(nNotifyPostEmpty);
        BinaryEntry<NotificationKey, int[]> entry = this.enlistBackingMapEntry(PagedTopicCaches.Names.NOTIFICATIONS, this.toBinaryKey(new NotificationKey(this.getPartition(), nNotifyPostEmpty)));
        if (entry != null) {
            entry.setValue(Arrays.binaryInsert((int[])entry.getValue(), nChannel));
        }
    }

    protected void requestRemovalNotification(int nNotifyPostFull, int nChannel) {
        int c = this.getChannelCount();
        for (int i = 0; i < c; ++i) {
            Usage usage = this.enlistUsage(i);
            if (usage.getPartitionHead() == -1L) continue;
            usage.addRemovalNotifier(nNotifyPostFull);
            BinaryEntry<NotificationKey, int[]> entry = this.enlistBackingMapEntry(PagedTopicCaches.Names.NOTIFICATIONS, this.toBinaryKey(new NotificationKey(this.getPartition(), nNotifyPostFull)));
            if (entry == null) continue;
            entry.setValue(Arrays.binaryInsert((int[])entry.getValue(), nChannel));
            entry.expire(PUBLISHER_NOTIFICATION_EXPIRY_MILLIS);
        }
    }

    public Configuration getTopicConfiguration() {
        CacheService service = this.f_ctxManager.getCacheService();
        return service.getResourceRegistry().getResource(Configuration.class, this.f_sName);
    }

    protected <K, V> BinaryEntry<K, V> enlistBackingMapEntry(PagedTopicCaches.Names<K, V> cacheName, Binary binaryKey) {
        BackingMapContext context = this.getBackingMapContext(cacheName);
        if (context == null) {
            return null;
        }
        return (BinaryEntry)context.getBackingMapEntry(binaryKey);
    }

    protected <K, V> BinaryEntry<K, V> peekBackingMapEntry(PagedTopicCaches.Names<K, V> cacheName, Binary binaryKey) {
        return (BinaryEntry)this.getBackingMapContext(cacheName).getReadOnlyEntry(binaryKey);
    }

    protected BackingMapContext getBackingMapContext(PagedTopicCaches.Names cacheName) {
        String sCacheName = cacheName.cacheNameForTopicName(this.f_sName);
        BackingMapContext ctx = this.f_ctxManager.getBackingMapContext(sCacheName);
        if (ctx == null) {
            throw new MapNotFoundException(sCacheName);
        }
        return ctx;
    }

    protected <F> Converter<F, Binary> getKeyToInternalConverter() {
        return this.f_ctxManager.getKeyToInternalConverter();
    }

    public Binary toBinaryKey(Object o) {
        return (Binary)this.f_ctxManager.getKeyToInternalConverter().convert(o);
    }

    protected <F> Converter<Binary, F> getValueFromInternalConverter() {
        return this.f_ctxManager.getValueFromInternalConverter();
    }

    protected <F> Converter<F, Binary> getValueToInternalConverter() {
        return this.f_ctxManager.getValueToInternalConverter();
    }
}

