/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged;

import com.oracle.coherence.common.base.Converter;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.util.MemorySize;
import com.oracle.coherence.common.util.Options;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.net.DebouncedFlowControl;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.internal.net.topic.impl.paged.BatchingOperationsQueue;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.internal.net.topic.impl.paged.agent.OfferProcessor;
import com.tangosol.internal.net.topic.impl.paged.agent.TailAdvancer;
import com.tangosol.internal.net.topic.impl.paged.agent.TopicInitialiseProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.NotificationKey;
import com.tangosol.internal.net.topic.impl.paged.model.Page;
import com.tangosol.internal.net.topic.impl.paged.model.Usage;
import com.tangosol.io.Serializer;
import com.tangosol.net.FlowControl;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.net.topic.Publisher;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.HashHelper;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.SparseArray;
import com.tangosol.util.filter.InKeySetFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;

public class PagedTopicPublisher<V>
implements Publisher<V>,
MapListenerSupport.SynchronousListener<NotificationKey, int[]> {
    private static final Void VOID = null;
    public static final long CLOSE_TIMEOUT_SECS = TimeUnit.MILLISECONDS.toSeconds(Base.parseTime(Config.getProperty("coherence.topic.publisher.close.timeout", "30s"), 1000));
    private PagedTopicCaches m_caches;
    private final String f_sTopicName;
    private final Options<Publisher.Option> f_options;
    private final Converter<V, Binary> f_convValueToBinary;
    private final int f_nNotifyPostFull;
    private final Publisher.OrderBy<V> f_funcOrder;
    private final FlowControl f_flowcontrol;
    protected final Channel[] f_aChannel;
    private long m_cOffers;
    private long m_cOffersLast;
    private long m_cAccepted;
    private long m_cAcceptedLast;
    private long m_cMisses;
    private long m_cMissesLast;
    private long m_cWait;
    private long m_cWaitsLast;
    private long m_cNotify;
    private long m_cNotifyLast;
    private final BitSet f_setOfferedChannel;
    private final NamedCacheDeactivationListener f_listenerDeactivation = new DeactivationListener();
    private final List<Runnable> f_listOnCloseActions = new ArrayList<Runnable>();

    public PagedTopicPublisher(PagedTopicCaches pagedTopicCaches, Publisher.Option<? super V> ... options) {
        this(pagedTopicCaches, (BatchingOperationsQueue<Void>)null, options);
    }

    protected PagedTopicPublisher(PagedTopicCaches pagedTopicCaches, BatchingOperationsQueue<Void> elementQueue, Publisher.Option<? super V> ... options) {
        this.m_caches = Objects.requireNonNull(pagedTopicCaches, "The PagedTopicCaches parameter cannot be null");
        this.registerDeactivationListener();
        Serializer serializer = pagedTopicCaches.getSerializer();
        this.f_convValueToBinary = value -> ExternalizableHelper.toBinary(value, serializer);
        this.f_sTopicName = pagedTopicCaches.getTopicName();
        this.f_options = Options.from(Publisher.Option.class, options);
        this.f_nNotifyPostFull = this.f_options.contains((Publisher.Option)((Object)Publisher.FailOnFull.class)) ? 0 : pagedTopicCaches.newNotifierId();
        this.f_funcOrder = this.computeOrderByOption(this.f_options);
        int cParts = ((PartitionedService)((Object)this.m_caches.getCacheService())).getPartitionCount();
        long cbBatch = this.m_caches.getConfiguration().getMaxBatchSizeBytes();
        int cChannel = pagedTopicCaches.getChannelCount();
        this.f_aChannel = new Channel[cChannel];
        this.f_setOfferedChannel = new BitSet(cChannel);
        DebouncedFlowControl backlog = new DebouncedFlowControl(cbBatch * 2L, cbBatch * 3L, l -> new MemorySize(Math.abs(l)).toString());
        this.f_flowcontrol = backlog;
        for (int nChannel = 0; nChannel < cChannel; ++nChannel) {
            Channel channel = this.f_aChannel[nChannel] = new Channel();
            channel.batchingQueue = elementQueue == null ? new BatchingOperationsQueue(c -> this.addQueuedElements(channel, (int)c), 1, backlog) : elementQueue;
            int nPart = Math.abs(HashHelper.hash(this.f_sTopicName.hashCode(), nChannel) % cParts);
            channel.keyUsageSync = new Usage.Key(nPart, nChannel);
        }
        if (this.f_nNotifyPostFull != 0) {
            pagedTopicCaches.Notifications.addMapListener((MapListener<NotificationKey, int[]>)this, new InKeySetFilter(null, pagedTopicCaches.getPartitionNotifierSet(this.f_nNotifyPostFull)), false);
        }
    }

    public boolean isActive() {
        return this.f_aChannel[0].batchingQueue.isActive();
    }

    @Override
    public CompletableFuture<Void> send(V value) {
        this.ensureActive();
        Channel channel = this.f_aChannel[Base.mod(this.f_funcOrder.getOrderId(value), this.f_aChannel.length)];
        return channel.batchingQueue.add(this.f_convValueToBinary.convert(value));
    }

    @Override
    public FlowControl getFlowControl() {
        return this.f_flowcontrol;
    }

    @Override
    public CompletableFuture<Void> flush() {
        return this.flushInternal(FlushMode.FLUSH);
    }

    @Override
    public synchronized void close() {
        if (this.isActive()) {
            this.closeInternal(false);
        }
    }

    @Override
    public void onClose(Runnable action) {
        this.f_listOnCloseActions.add(action);
    }

    public String getName() {
        return this.f_sTopicName;
    }

    Publisher.OrderBy getOrderByOption() {
        return this.f_funcOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagedTopicPublisher that = (PagedTopicPublisher)o;
        return this.m_caches.equals(that.m_caches);
    }

    public int hashCode() {
        return this.m_caches.hashCode();
    }

    public String toString() {
        PagedTopicCaches caches = this.m_caches;
        if (caches == null) {
            return this.getClass().getSimpleName() + "(inactive)";
        }
        long cOffersNow = this.m_cOffers;
        long cAcceptedNow = this.m_cAccepted;
        long cMissesNow = this.m_cMisses;
        long cWaitNow = this.m_cWait;
        long cNotifyNow = this.m_cNotify;
        long cOffers = cOffersNow - this.m_cOffersLast;
        long cAccepted = cAcceptedNow - this.m_cAcceptedLast;
        long cMisses = cMissesNow - this.m_cMissesLast;
        long cWait = cWaitNow - this.m_cWaitsLast;
        long cNotify = cNotifyNow - this.m_cNotifyLast;
        this.m_cOffersLast = cOffersNow;
        this.m_cAcceptedLast = cAcceptedNow;
        this.m_cMissesLast = cMissesNow;
        this.m_cWaitsLast = cWaitNow;
        this.m_cNotifyLast = cNotifyNow;
        int cChannels = this.f_setOfferedChannel.cardinality();
        String sChannels = this.f_setOfferedChannel.toString();
        this.f_setOfferedChannel.clear();
        return this.getClass().getSimpleName() + "(topic=" + caches.getTopicName() + ", orderBy=" + this.f_funcOrder + ", backlog=" + this.f_flowcontrol + ", channels=" + sChannels + cChannels + ", batchSize=" + cAccepted / Math.max(1L, cOffers - cMisses) + ", hitRate=" + (cOffers - cMisses) * 100L / Math.max(1L, cOffers) + "%, waitNotifyRate=" + cWait * 100L / Math.max(1L, cOffers) + "/" + cNotify * 100L / Math.max(1L, cOffers) + "%)";
    }

    private Publisher.OrderBy computeOrderByOption(Options options) {
        Iterator<Publisher.OrderBy> iter = options.getInstancesOf(Publisher.OrderBy.class).iterator();
        return iter.hasNext() ? iter.next() : Publisher.OrderBy.thread();
    }

    private void ensureActive() {
        if (!this.isActive()) {
            throw new IllegalStateException("This publisher is no longer active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void closeInternal(boolean fDestroyed) {
        if (this.m_caches == null) {
            return;
        }
        try {
            if (!fDestroyed && this.f_nNotifyPostFull != 0) {
                this.unregisterDeactivationListener();
                PagedTopicCaches caches = this.m_caches;
                caches.Notifications.removeMapListener((MapListener<NotificationKey, int[]>)this, new InKeySetFilter(null, caches.getPartitionNotifierSet(this.f_nNotifyPostFull)));
            }
            for (Channel channel : this.f_aChannel) {
                channel.batchingQueue.close();
            }
            try {
                this.flushInternal(fDestroyed ? FlushMode.FLUSH_DESTROY : FlushMode.FLUSH).get(CLOSE_TIMEOUT_SECS, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                this.flushInternal(FlushMode.FLUSH_CLOSE_EXCEPTIONALLY).join();
                Logger.warn("Publisher.close: timeout after waiting " + CLOSE_TIMEOUT_SECS + " seconds for completion with flush.join(), forcing complete exceptionally");
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        finally {
            this.m_caches = null;
            this.f_listOnCloseActions.forEach(action -> {
                try {
                    action.run();
                }
                catch (Throwable t) {
                    Logger.fine(this.getClass().getName() + ".close(): handled onClose exception: " + t.getClass().getCanonicalName() + ": " + t.getMessage());
                }
            });
        }
    }

    private CompletableFuture<Void> flushInternal(FlushMode mode) {
        String sDescription = null;
        switch (mode) {
            case FLUSH_DESTROY: {
                sDescription = "Topic " + this.f_sTopicName + " was destroyed";
            }
            case FLUSH_CLOSE_EXCEPTIONALLY: {
                if (sDescription == null) {
                    sDescription = "Force Close of Publisher " + this.hashCode() + " for topic " + this.f_sTopicName;
                }
                RequestIncompleteException error = new RequestIncompleteException(sDescription);
                Arrays.stream(this.f_aChannel).forEach(channel -> channel.batchingQueue.handleError(error, BatchingOperationsQueue.OnErrorAction.CompleteWithException));
                return CompletableFuture.completedFuture(null);
            }
        }
        CompletableFuture[] aFuture = new CompletableFuture[this.f_aChannel.length];
        for (int i = 0; i < aFuture.length; ++i) {
            aFuture[i] = this.f_aChannel[i].batchingQueue.flush();
        }
        return CompletableFuture.allOf(aFuture);
    }

    protected void addQueuedElements(Channel channel, int cbMaxElements) {
        if (channel.batchingQueue.fillCurrentBatch(cbMaxElements)) {
            ((CompletableFuture)this.ensurePageId(channel).thenAccept(_void -> this.addInternal(channel, channel.lTail))).handle(this::handleError);
        }
    }

    protected void addInternal(Channel channel, long lPageId) {
        List<Binary> listBinary = channel.batchingQueue.getCurrentBatchValues();
        if (listBinary.isEmpty()) {
            return;
        }
        Page.Key keyPage = new Page.Key(channel.keyUsageSync.getChannelId(), lPageId);
        int nPart = ((PartitionedService)((Object)this.m_caches.getCacheService())).getKeyPartitioningStrategy().getKeyPartition(keyPage);
        PagedTopicCaches caches = this.m_caches;
        InvocableMapHelper.invokeAsync(caches.Pages, keyPage, caches.getUnitOfOrder(nPart), new OfferProcessor(listBinary, this.f_nNotifyPostFull, false), (result, e) -> {
            if (e == null) {
                this.handleOfferCompletion((OfferProcessor.Result)result, channel, lPageId);
            } else {
                this.handleError(null, (Throwable)e);
            }
        });
    }

    protected void handleOfferCompletion(OfferProcessor.Result result, Channel channel, long lPageId) {
        LongArray<Throwable> aErrors = result.getErrors();
        int cAccepted = result.getAcceptedCount();
        int nChannel = channel.keyUsageSync.getChannelId();
        ++this.m_cOffers;
        this.m_cAccepted += (long)cAccepted;
        if (cAccepted == 0) {
            ++this.m_cMisses;
        }
        this.f_setOfferedChannel.set(nChannel);
        if (this.f_nNotifyPostFull == 0 && result.getStatus() == OfferProcessor.Result.Status.TopicFull) {
            int ceBatch = channel.batchingQueue.getCurrentBatch().size();
            IllegalStateException e = new IllegalStateException("the topic is at capacity");
            if (aErrors == null) {
                aErrors = new SparseArray<Throwable>();
            }
            while (cAccepted < ceBatch) {
                ++cAccepted;
                aErrors.add(e);
            }
        }
        channel.batchingQueue.completeElements(cAccepted, aErrors);
        this.handleIndividualErrors(aErrors);
        if (this.isActive()) {
            switch (result.getStatus()) {
                case PageSealed: {
                    ((CompletableFuture)this.moveToNextPage(channel, lPageId).thenRun(() -> this.addQueuedElements(channel, result.getPageCapacity()))).handle(this::handleError);
                    break;
                }
                case TopicFull: {
                    if (this.f_nNotifyPostFull != 0) {
                        channel.batchingQueue.pause();
                        break;
                    }
                }
                default: {
                    this.addQueuedElements(channel, result.getPageCapacity());
                }
            }
        }
    }

    protected void handleIndividualErrors(LongArray<Throwable> aErrors) {
        if (aErrors == null || aErrors.isEmpty()) {
            return;
        }
        Publisher.OnFailure onFailure = this.f_options.get(Publisher.OnFailure.class);
        switch (onFailure) {
            case Stop: {
                Throwable throwable = aErrors.get(aErrors.getFirstIndex());
                this.handleError(VOID, throwable);
                break;
            }
        }
    }

    protected CompletableFuture<Long> ensurePageId(Channel channel) {
        if (channel.futurePageId == null) {
            return this.initializePageId(channel);
        }
        return channel.futurePageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Long> initializePageId(Channel channel) {
        Channel channel2 = channel;
        synchronized (channel2) {
            if (channel.futurePageId == null) {
                channel.futurePageId = InvocableMapHelper.invokeAsync(this.m_caches.Usages, channel.keyUsageSync, this.m_caches.getUnitOfOrder(channel.keyUsageSync.getPartitionId()), new TopicInitialiseProcessor(), new BiConsumer[0]);
            }
            return channel.futurePageId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Long> moveToNextPage(Channel channel, long lPage) {
        long lPageCurrent = channel.lTail;
        if (lPageCurrent > lPage) {
            return CompletableFuture.completedFuture(lPageCurrent);
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            lPageCurrent = channel.lTail;
            if (lPageCurrent > lPage) {
                return CompletableFuture.completedFuture(lPageCurrent);
            }
            CompletableFuture<Long> futureResult = channel.futureMovePage;
            if (futureResult == null) {
                channel.futureMovePage = futureResult = InvocableMapHelper.invokeAsync(this.m_caches.Usages, channel.keyUsageSync, this.m_caches.getUnitOfOrder(channel.keyUsageSync.getPartitionId()), new TailAdvancer(lPage + 1L), (result, e) -> {
                    if (e == null) {
                        this.updatePageId(channel, (long)result);
                    } else {
                        this.handleError((Object)result, (Throwable)e);
                    }
                });
            }
            return futureResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePageId(Channel channel, long lPageNew) {
        if (channel.lTail < lPageNew) {
            Channel channel2 = channel;
            synchronized (channel2) {
                if (channel.lTail < lPageNew) {
                    channel.lTail = lPageNew;
                }
            }
        }
        channel.futureMovePage = null;
    }

    protected <R> R handleError(R result, Throwable throwable) {
        if (throwable != null) {
            for (Channel channel : this.f_aChannel) {
                channel.batchingQueue.handleError(throwable, BatchingOperationsQueue.OnErrorAction.Cancel);
            }
            this.closeInternal(false);
        }
        return result;
    }

    @Override
    public void entryInserted(MapEvent<NotificationKey, int[]> evt) {
    }

    @Override
    public void entryUpdated(MapEvent<NotificationKey, int[]> evt) {
    }

    @Override
    public void entryDeleted(MapEvent<NotificationKey, int[]> evt) {
        ++this.m_cNotify;
        for (int nChannel : evt.getOldValue()) {
            Channel channel = this.f_aChannel[nChannel];
            if (!channel.batchingQueue.resume()) continue;
            ++this.m_cWait;
            this.addQueuedElements(this.f_aChannel[nChannel], 1);
        }
    }

    protected void registerDeactivationListener() {
        try {
            NamedCacheDeactivationListener listener = this.f_listenerDeactivation;
            if (listener != null) {
                this.m_caches.Data.addMapListener(listener);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void unregisterDeactivationListener() {
        try {
            NamedCacheDeactivationListener listener = this.f_listenerDeactivation;
            if (listener != null) {
                this.m_caches.Data.removeMapListener(listener);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    static enum FlushMode {
        FLUSH,
        FLUSH_DESTROY,
        FLUSH_CLOSE_EXCEPTIONALLY;

    }

    protected class DeactivationListener
    extends AbstractMapListener
    implements NamedCacheDeactivationListener {
        protected DeactivationListener() {
        }

        @Override
        public void entryDeleted(MapEvent evt) {
            Logger.fine("Detected destroy of topic " + PagedTopicPublisher.this.f_sTopicName + ", closing publisher " + PagedTopicPublisher.this);
            PagedTopicPublisher.this.closeInternal(true);
        }
    }

    protected static class Channel {
        Usage.Key keyUsageSync;
        BatchingOperationsQueue<Void> batchingQueue;
        volatile long lTail = -1L;
        volatile CompletableFuture<Long> futurePageId;
        CompletableFuture<Long> futureMovePage;

        protected Channel() {
        }
    }
}

