/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.model;

import com.oracle.coherence.common.collections.Arrays;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.partition.KeyPartitioningStrategy;
import com.tangosol.util.HashHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public class Usage
extends AbstractEvolvable
implements EvolvablePortableObject {
    public static final int DATA_VERSION = 1;
    private long m_lTailPublication = -1L;
    private long m_lHead = -1L;
    private long m_lTail = -1L;
    private long m_lMax = -1L;
    private Collection<SubscriberGroupId> m_colAnonymousSubscribers;
    private int m_cWaitingSubscribers;
    private int[] m_anNotifyOnRemove;

    public long getPublicationTail() {
        return this.m_lTailPublication;
    }

    public void setPublicationTail(long lPage) {
        this.m_lTailPublication = lPage;
    }

    public long getPartitionHead() {
        return this.m_lHead;
    }

    public void setPartitionHead(long lPage) {
        this.m_lHead = lPage;
    }

    public long getPartitionTail() {
        return this.m_lTail;
    }

    public void setPartitionTail(long lPage) {
        this.m_lTail = lPage;
    }

    public void setPartitionMax(long lPage) {
        this.m_lMax = lPage;
    }

    public long getPartitionMax() {
        return this.m_lMax;
    }

    public Collection<SubscriberGroupId> getAnonymousSubscribers() {
        return this.m_colAnonymousSubscribers;
    }

    public void addAnonymousSubscriber(SubscriberGroupId subAnon) {
        Collection<SubscriberGroupId> col = this.m_colAnonymousSubscribers;
        if (!(col instanceof HashSet)) {
            col = col == null ? new HashSet<SubscriberGroupId>() : new HashSet<SubscriberGroupId>(col);
            this.m_colAnonymousSubscribers = col;
        }
        col.add(subAnon);
    }

    public void removeAnonymousSubscriber(SubscriberGroupId anon) {
        Collection<SubscriberGroupId> col = this.m_colAnonymousSubscribers;
        if (col == null) {
            return;
        }
        if (!(col instanceof HashSet)) {
            this.m_colAnonymousSubscribers = col = new HashSet<SubscriberGroupId>(col);
        }
        col.remove(anon);
    }

    public int adjustWaitingSubscriberCount(int cAdjust) {
        return this.m_cWaitingSubscribers += cAdjust;
    }

    public int resetWaitingSubscriberCount() {
        int c = this.m_cWaitingSubscribers;
        this.m_cWaitingSubscribers = 0;
        return c;
    }

    public void addRemovalNotifier(int nNotifierId) {
        this.m_anNotifyOnRemove = Arrays.binaryInsert(this.m_anNotifyOnRemove, nNotifierId);
    }

    public int[] resetRemovalNotifiers() {
        int[] anNotify = this.m_anNotifyOnRemove;
        this.m_anNotifyOnRemove = null;
        return anNotify;
    }

    @Override
    public int getImplVersion() {
        return 1;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_lTailPublication = in.readLong(0);
        this.m_lHead = in.readLong(1);
        this.m_lTail = in.readLong(2);
        this.m_lMax = in.readLong(3);
        this.m_colAnonymousSubscribers = (Collection)in.readObject(4);
        this.m_cWaitingSubscribers = in.readInt(5);
        this.m_anNotifyOnRemove = (int[])in.readObject(6);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_lTailPublication);
        out.writeLong(1, this.m_lHead);
        out.writeLong(2, this.m_lTail);
        out.writeLong(3, this.m_lMax);
        out.writeObject(4, this.m_colAnonymousSubscribers);
        out.writeInt(5, this.m_cWaitingSubscribers);
        out.writeIntArray(6, this.m_anNotifyOnRemove);
    }

    public String toString() {
        int[] anRemove = this.m_anNotifyOnRemove;
        return this.getClass().getSimpleName() + "(globalTail=" + this.m_lTailPublication + ", head=" + this.m_lHead + ", tail=" + this.m_lTail + ", maxPage=" + this.m_lMax + ", waitingPubs=" + (anRemove == null ? 0 : anRemove.length) + ", waitingSubs=" + this.m_cWaitingSubscribers + ", anonSubs=" + this.m_colAnonymousSubscribers + ")";
    }

    public static class Key
    implements KeyPartitioningStrategy.PartitionAwareKey,
    PortableObject {
        private int m_nPartition;
        private int m_nChannel;

        public Key() {
        }

        public Key(int nPartition, int nChannel) {
            this.m_nPartition = nPartition;
            this.m_nChannel = nChannel;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_nPartition = in.readInt(0);
            this.m_nChannel = in.readInt(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeInt(0, this.m_nPartition);
            out.writeInt(1, this.m_nChannel);
        }

        public int hashCode() {
            return HashHelper.hash(this.m_nPartition, this.m_nChannel);
        }

        public String toString() {
            return this.getClass().getName() + "(partition=" + this.m_nPartition + ", channel=" + this.m_nChannel + ")";
        }

        public boolean equals(Object oThat) {
            if (oThat instanceof Key) {
                Key that = (Key)oThat;
                return that.m_nPartition == this.m_nPartition && that.m_nChannel == this.m_nChannel;
            }
            return false;
        }

        public int getChannelId() {
            return this.m_nChannel;
        }

        @Override
        public int getPartitionId() {
            return this.m_nPartition;
        }
    }
}

