/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.bind.tuple;

import com.tangosol.internal.sleepycat.bind.tuple.TupleBinding;
import com.tangosol.internal.sleepycat.bind.tuple.TupleInput;
import com.tangosol.internal.sleepycat.bind.tuple.TupleOutput;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;

public class LongBinding
extends TupleBinding<Long> {
    private static final int LONG_SIZE = 8;

    @Override
    public Long entryToObject(TupleInput input) {
        return input.readLong();
    }

    @Override
    public void objectToEntry(Long object, TupleOutput output) {
        output.writeLong(object);
    }

    @Override
    protected TupleOutput getTupleOutput(Long object) {
        return LongBinding.sizedOutput();
    }

    public static long entryToLong(DatabaseEntry entry) {
        return LongBinding.entryToInput(entry).readLong();
    }

    public static void longToEntry(long val, DatabaseEntry entry) {
        LongBinding.outputToEntry(LongBinding.sizedOutput().writeLong(val), entry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[8]);
    }
}

