/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je;

import com.tangosol.internal.sleepycat.je.Cursor;
import com.tangosol.internal.sleepycat.je.CursorConfig;
import com.tangosol.internal.sleepycat.je.DatabaseConfig;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.DatabaseStats;
import com.tangosol.internal.sleepycat.je.DbInternal;
import com.tangosol.internal.sleepycat.je.DeleteConstraintException;
import com.tangosol.internal.sleepycat.je.DiskOrderedCursor;
import com.tangosol.internal.sleepycat.je.DiskOrderedCursorConfig;
import com.tangosol.internal.sleepycat.je.Environment;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.ForwardCursor;
import com.tangosol.internal.sleepycat.je.JoinConfig;
import com.tangosol.internal.sleepycat.je.JoinCursor;
import com.tangosol.internal.sleepycat.je.LockConflictException;
import com.tangosol.internal.sleepycat.je.LockMode;
import com.tangosol.internal.sleepycat.je.OperationFailureException;
import com.tangosol.internal.sleepycat.je.OperationStatus;
import com.tangosol.internal.sleepycat.je.PreloadConfig;
import com.tangosol.internal.sleepycat.je.PreloadStats;
import com.tangosol.internal.sleepycat.je.SecondaryAssociation;
import com.tangosol.internal.sleepycat.je.SecondaryDatabase;
import com.tangosol.internal.sleepycat.je.SecondaryIntegrityException;
import com.tangosol.internal.sleepycat.je.Sequence;
import com.tangosol.internal.sleepycat.je.SequenceConfig;
import com.tangosol.internal.sleepycat.je.SequenceExistsException;
import com.tangosol.internal.sleepycat.je.SequenceNotFoundException;
import com.tangosol.internal.sleepycat.je.StatsConfig;
import com.tangosol.internal.sleepycat.je.ThreadInterruptedException;
import com.tangosol.internal.sleepycat.je.Transaction;
import com.tangosol.internal.sleepycat.je.VerifyConfig;
import com.tangosol.internal.sleepycat.je.dbi.CursorImpl;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.DbiStatDefinition;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.dbi.GetMode;
import com.tangosol.internal.sleepycat.je.dbi.PutMode;
import com.tangosol.internal.sleepycat.je.dbi.TriggerManager;
import com.tangosol.internal.sleepycat.je.txn.HandleLocker;
import com.tangosol.internal.sleepycat.je.txn.Locker;
import com.tangosol.internal.sleepycat.je.txn.LockerFactory;
import com.tangosol.internal.sleepycat.je.utilint.AtomicLongStat;
import com.tangosol.internal.sleepycat.je.utilint.DatabaseUtil;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Database
implements Closeable {
    private volatile DbState state;
    private OperationFailureException preemptedCause;
    Environment envHandle;
    private DatabaseImpl databaseImpl;
    DatabaseConfig configuration;
    private boolean isWritable;
    private final AtomicInteger openCursors = new AtomicInteger();
    private HandleLocker handleLocker;
    SecondaryAssociation secAssoc;
    Collection<SecondaryDatabase> simpleAssocSecondaries;
    Collection<SecondaryDatabase> foreignKeySecondaries;
    private AtomicLongStat deleteStat;
    private AtomicLongStat getStat;
    private AtomicLongStat getSearchBothStat;
    private AtomicLongStat putStat;
    private AtomicLongStat putNoDupDataStat;
    private AtomicLongStat putNoOverwriteStat;
    private AtomicLongStat removeSequenceStat;
    final Logger logger;

    Database(Environment env) {
        this.envHandle = env;
        this.handleLocker = null;
        this.logger = this.envHandle.getEnvironmentImpl().getLogger();
    }

    DatabaseImpl initNew(Environment env, Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        dbConfig.validateForNewDb();
        this.init(env, dbConfig);
        EnvironmentImpl environmentImpl = DbInternal.getEnvironmentImpl(this.envHandle);
        this.databaseImpl = environmentImpl.getDbTree().createDb(locker, databaseName, dbConfig, this.handleLocker);
        this.databaseImpl.addReferringHandle(this);
        return this.databaseImpl;
    }

    void initExisting(Environment env, Locker locker, DatabaseImpl dbImpl, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        this.validateConfigAgainstExistingDb(locker, databaseName, dbConfig, dbImpl);
        this.init(env, dbConfig);
        this.databaseImpl = dbImpl;
        dbImpl.addReferringHandle(this);
    }

    private void init(Environment env, DatabaseConfig config) {
        assert (this.handleLocker != null);
        this.envHandle = env;
        this.configuration = config.cloneConfig();
        this.isWritable = !this.configuration.getReadOnly();
        this.setupThroughputStats(env.getEnvironmentImpl());
        this.secAssoc = this.makeSecondaryAssociation();
        this.state = DbState.OPEN;
    }

    private void setupThroughputStats(EnvironmentImpl envImpl) {
        this.deleteStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_DELETE);
        this.getStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_GET);
        this.getSearchBothStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_GETSEARCHBOTH);
        this.putStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_PUT);
        this.putNoDupDataStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_PUTNODUPDATA);
        this.putNoOverwriteStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_PUTNOOVERWRITE);
        this.removeSequenceStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_REMOVESEQUENCE);
    }

    SecondaryAssociation makeSecondaryAssociation() {
        this.foreignKeySecondaries = new CopyOnWriteArraySet<SecondaryDatabase>();
        if (this.configuration.getSecondaryAssociation() != null) {
            if (this.configuration.getSortedDuplicates()) {
                throw new IllegalArgumentException("Duplicates not allowed for a primary database");
            }
            this.simpleAssocSecondaries = Collections.emptySet();
            return this.configuration.getSecondaryAssociation();
        }
        this.simpleAssocSecondaries = new CopyOnWriteArraySet<SecondaryDatabase>();
        return new SecondaryAssociation(){

            @Override
            public boolean isEmpty() {
                return Database.this.simpleAssocSecondaries.isEmpty();
            }

            @Override
            public Database getPrimary(DatabaseEntry primaryKey) {
                return Database.this;
            }

            @Override
            public Collection<SecondaryDatabase> getSecondaries(DatabaseEntry primaryKey) {
                return Database.this.simpleAssocSecondaries;
            }
        };
    }

    void removeReferringAssociations() {
        this.envHandle.removeReferringHandle(this);
    }

    private void validateConfigAgainstExistingDb(Locker locker, String databaseName, DatabaseConfig config, DatabaseImpl dbImpl) throws DatabaseException {
        int newNodeMaxEntries;
        if (!config.getUseExistingConfig()) {
            this.validatePropertyMatches("sortedDuplicates", dbImpl.getSortedDuplicates(), config.getSortedDuplicates());
            this.validatePropertyMatches("temporary", dbImpl.isTemporary(), config.getTemporary());
            if (this.envHandle.getEnvironmentImpl().isReplicated()) {
                this.validatePropertyMatches("replicated", dbImpl.isReplicated(), config.getReplicated());
            }
        }
        if (dbImpl.hasOpenHandles()) {
            if (!config.getUseExistingConfig()) {
                this.validatePropertyMatches("transactional", dbImpl.isTransactional(), config.getTransactional());
                this.validatePropertyMatches("deferredWrite", dbImpl.isDurableDeferredWrite(), config.getDeferredWrite());
            }
        } else {
            dbImpl.setTransactional(config.getTransactional());
            dbImpl.setDeferredWrite(config.getDeferredWrite());
        }
        if (config.getUseExistingConfig()) {
            return;
        }
        boolean dbImplModified = false;
        if (config.getOverrideBtreeComparator()) {
            dbImplModified |= dbImpl.setBtreeComparator(config.getBtreeComparator(), config.getBtreeComparatorByClassName());
        }
        if (config.getOverrideDuplicateComparator()) {
            dbImplModified |= dbImpl.setDuplicateComparator(config.getDuplicateComparator(), config.getDuplicateComparatorByClassName());
        }
        dbImplModified |= dbImpl.setTriggers(locker, databaseName, config.getTriggers(), config.getOverrideTriggers());
        boolean newKeyPrefixing = config.getKeyPrefixing();
        if (newKeyPrefixing != dbImpl.getKeyPrefixing()) {
            dbImplModified = true;
            if (newKeyPrefixing) {
                dbImpl.setKeyPrefixing();
            } else {
                dbImpl.clearKeyPrefixing();
            }
        }
        if ((newNodeMaxEntries = config.getNodeMaxEntries()) != 0 && newNodeMaxEntries != dbImpl.getNodeMaxTreeEntries()) {
            dbImplModified = true;
            dbImpl.setNodeMaxTreeEntries(newNodeMaxEntries);
        }
        EnvironmentImpl envImpl = this.envHandle.getEnvironmentImpl();
        if (dbImplModified && !envImpl.isReadOnly()) {
            try {
                envImpl.getDbTree().updateNameLN(locker, dbImpl.getName(), null);
            }
            catch (LockConflictException e) {
                throw new IllegalStateException("DatabaseConfig properties may not be updated when the database is already open; first close other open handles for this database.", e);
            }
            envImpl.getDbTree().modifyDbRoot(dbImpl);
        }
        dbImpl.setCacheMode(config.getCacheMode());
        dbImpl.setCacheModeStrategy(config.getCacheModeStrategy());
    }

    private void validatePropertyMatches(String propName, boolean existingValue, boolean newValue) throws IllegalArgumentException {
        if (newValue != existingValue) {
            throw new IllegalArgumentException("You can't open a Database with a " + propName + " configuration of " + newValue + " if the underlying database was created with a " + propName + " setting of " + existingValue + '.');
        }
    }

    @Override
    public void close() throws DatabaseException {
        try {
            this.closeInternal(true, true, DbState.CLOSED, null);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    private void closeNoSync() throws DatabaseException {
        try {
            this.closeInternal(false, true, DbState.CLOSED, null);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    synchronized void setPreempted(String dbName, String msg) {
        OperationFailureException preemptedException = null;
        if (this.databaseImpl != null) {
            preemptedException = this.databaseImpl.getEnv().createDatabasePreemptedException(msg, dbName, this);
        }
        this.closeInternal(false, false, DbState.PREEMPTED, preemptedException);
    }

    synchronized void invalidate() {
        this.closeInternal(false, false, DbState.INVALID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean doSyncDw, boolean deleteTempDb, DbState newState, OperationFailureException preemptedException) throws DatabaseException {
        EnvironmentImpl envImpl = this.envHandle.getEnvironmentImpl();
        if (envImpl != null) {
            try {
                envImpl.getSecondaryAssociationLock().writeLock().lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(envImpl, (Throwable)e);
            }
        }
        try {
            this.closeInternalWork(doSyncDw, deleteTempDb, newState, preemptedException);
        }
        finally {
            if (envImpl != null) {
                envImpl.getSecondaryAssociationLock().writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternalWork(boolean doSyncDw, boolean deleteTempDb, DbState newState, OperationFailureException preemptedException) throws DatabaseException {
        StringBuilder handleRefErrors = new StringBuilder();
        RuntimeException triggerException = null;
        DatabaseImpl dbClosed = null;
        Database database = this;
        synchronized (database) {
            if (this.state != DbState.OPEN) {
                return;
            }
            this.checkEnv();
            this.state = newState;
            this.preemptedCause = preemptedException;
            if (newState == DbState.CLOSED) {
                if (this.openCursors.get() != 0) {
                    handleRefErrors.append(" ").append(this.openCursors.get()).append(" open cursors.");
                }
                if (this.simpleAssocSecondaries != null && this.simpleAssocSecondaries.size() > 0) {
                    handleRefErrors.append(" ").append(this.simpleAssocSecondaries.size()).append(" associated SecondaryDatabases.");
                }
                if (this.foreignKeySecondaries != null && this.foreignKeySecondaries.size() > 0) {
                    handleRefErrors.append(" ").append(this.foreignKeySecondaries.size()).append(" associated foreign key SecondaryDatabases.");
                }
            }
            this.trace(Level.FINEST, "Database.close: ", null, null);
            this.removeReferringAssociations();
            if (this.databaseImpl != null) {
                dbClosed = this.databaseImpl;
                this.databaseImpl.removeReferringHandle(this);
                this.envHandle.getEnvironmentImpl().getDbTree().releaseDb(this.databaseImpl);
                this.databaseImpl = null;
                if (this.handleLocker != null) {
                    if (newState == DbState.PREEMPTED) {
                        this.handleLocker.setOnlyAbortable(preemptedException);
                    }
                    if (newState == DbState.CLOSED) {
                        if (this.isWritable() && dbClosed.noteWriteHandleClose() == 0) {
                            try {
                                TriggerManager.runCloseTriggers(this.handleLocker, dbClosed);
                            }
                            catch (RuntimeException e) {
                                triggerException = e;
                            }
                        }
                        this.handleLocker.operationEnd(true);
                    } else {
                        this.handleLocker.operationEnd(false);
                    }
                    this.handleLocker = null;
                }
            }
        }
        if (dbClosed != null) {
            dbClosed.handleClosed(doSyncDw, deleteTempDb);
        }
        if (handleRefErrors.length() > 0) {
            throw new IllegalStateException("Database closed while still referenced by other handles." + handleRefErrors.toString());
        }
        if (triggerException != null) {
            throw triggerException;
        }
    }

    public void sync() throws DatabaseException, UnsupportedOperationException {
        this.checkEnv();
        this.checkOpen("Can't call Database.sync:");
        this.trace(Level.FINEST, "Database.sync", null, null, null, null);
        this.databaseImpl.sync(true);
    }

    public Sequence openSequence(Transaction txn, DatabaseEntry key, SequenceConfig config) throws SequenceNotFoundException, SequenceExistsException {
        try {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            this.checkOpen("Can't call Database.openSequence:");
            this.trace(Level.FINEST, "Database.openSequence", txn, key, null, null);
            return new Sequence(this, txn, key, config);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    public void removeSequence(Transaction txn, DatabaseEntry key) throws DatabaseException {
        this.removeSequenceStat.increment();
        try {
            this.delete(txn, key);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    public Cursor openCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException, IllegalArgumentException {
        try {
            CursorConfig useConfig;
            this.checkEnv();
            this.checkOpen("Can't open a cursor");
            CursorConfig cursorConfig2 = useConfig = cursorConfig == null ? CursorConfig.DEFAULT : cursorConfig;
            if (useConfig.getReadUncommitted() && useConfig.getReadCommitted()) {
                throw new IllegalArgumentException("Only one may be specified: ReadCommitted or ReadUncommitted");
            }
            this.trace(Level.FINEST, "Database.openCursor", txn, cursorConfig);
            Cursor ret = this.newDbcInstance(txn, useConfig);
            return ret;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    public DiskOrderedCursor openCursor(DiskOrderedCursorConfig cursorConfig) throws DatabaseException, IllegalArgumentException {
        try {
            this.checkEnv();
            this.checkOpen("Can't open a cursor");
            DiskOrderedCursorConfig useConfig = cursorConfig == null ? DiskOrderedCursorConfig.DEFAULT : cursorConfig;
            this.trace(Level.FINEST, "Database.openForwardCursor", null, cursorConfig);
            DiskOrderedCursor ret = new DiskOrderedCursor(this, useConfig);
            return ret;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    Cursor newDbcInstance(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return new Cursor(this, txn, cursorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateSecondaries(Transaction txn, DatabaseEntry key, DatabaseEntry data) {
        try {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForNullDbt(data, "true", true);
            this.checkOpen("Can't call populateSecondaries:");
            this.trace(Level.FINEST, "populateSecondaries", null, key, data, null);
            Collection<SecondaryDatabase> secondaries = this.secAssoc.getSecondaries(key);
            Locker locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.databaseImpl.isInternalDb(), this.isTransactional(), this.databaseImpl.isReplicated());
            boolean success = false;
            try {
                for (SecondaryDatabase secDb : secondaries) {
                    if (!secDb.isIncrementalPopulationEnabled()) continue;
                    secDb.updateSecondary(locker, null, key, null, data);
                }
                success = true;
            }
            finally {
                locker.operationEnd(success);
            }
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean populateSecondaries(DatabaseEntry key, int batchSize) {
        try {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", false);
            if (batchSize <= 0) {
                throw new IllegalArgumentException("batchSize must be positive");
            }
            this.checkOpen("Can't call populateSecondaries:");
            this.trace(Level.FINEST, "populateSecondaries", null, key, null, null);
            Locker locker = LockerFactory.getWritableLocker(this.envHandle, null, this.databaseImpl.isInternalDb(), this.isTransactional(), this.databaseImpl.isReplicated());
            try {
                boolean bl;
                Cursor cursor = new Cursor(this, locker, null);
                try {
                    bl = this.populateSecondariesInternal(cursor, locker, key, batchSize);
                }
                catch (Throwable throwable) {
                    cursor.close();
                    throw throwable;
                }
                cursor.close();
                return bl;
            }
            finally {
                locker.operationEnd(true);
            }
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    private boolean populateSecondariesInternal(Cursor cursor, Locker locker, DatabaseEntry key, int batchSize) {
        LockMode scanMode = LockMode.READ_UNCOMMITTED_ALL;
        OperationStatus searchStatus = key.getData() == null ? cursor.position(key, Cursor.NO_RETURN_DATA, scanMode, true) : cursor.search(key, Cursor.NO_RETURN_DATA, scanMode, CursorImpl.SearchMode.SET_RANGE);
        DatabaseEntry data = new DatabaseEntry();
        int nProcessed = 0;
        while (searchStatus == OperationStatus.SUCCESS) {
            if (nProcessed >= batchSize) {
                return true;
            }
            ++nProcessed;
            Collection<SecondaryDatabase> secondaries = this.secAssoc.getSecondaries(key);
            boolean anySecondaries = false;
            for (SecondaryDatabase secDb : secondaries) {
                if (!secDb.isIncrementalPopulationEnabled()) continue;
                anySecondaries = true;
                break;
            }
            if (anySecondaries && cursor.getCurrent(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                for (SecondaryDatabase secDb : secondaries) {
                    if (!secDb.isIncrementalPopulationEnabled()) continue;
                    secDb.updateSecondary(locker, null, key, null, data);
                }
            }
            searchStatus = cursor.retrieveNext(key, Cursor.NO_RETURN_DATA, scanMode, GetMode.NEXT);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus delete(Transaction txn, DatabaseEntry key) throws DeleteConstraintException, LockConflictException, DatabaseException, UnsupportedOperationException, IllegalArgumentException {
        OperationStatus operationStatus;
        block6: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            this.checkOpen("Can't call Database.delete:");
            this.trace(Level.FINEST, "Database.delete", txn, key, null, null);
            this.deleteStat.increment();
            OperationStatus commitStatus = OperationStatus.NOTFOUND;
            Locker locker = null;
            try {
                locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.databaseImpl.isInternalDb(), this.isTransactional(), this.databaseImpl.isReplicated());
                operationStatus = commitStatus = this.deleteInternal(locker, key);
                if (locker == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
                catch (Error E) {
                    DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
            }
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    /*
     * Exception decompiling
     */
    OperationStatus deleteInternal(Locker locker, DatabaseEntry key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws LockConflictException, DatabaseException, IllegalArgumentException {
        OperationStatus operationStatus;
        OperationStatus commitStatus;
        Locker locker;
        block9: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForNullDbt(data, "data", false);
            this.checkOpen("Can't call Database.get:");
            this.trace(Level.FINEST, "Database.get", txn, key, null, lockMode);
            this.getStat.increment();
            CursorConfig cursorConfig = CursorConfig.DEFAULT;
            if (lockMode == LockMode.READ_COMMITTED) {
                cursorConfig = CursorConfig.READ_COMMITTED;
                lockMode = null;
            }
            this.checkLockModeWithoutTxn(txn, lockMode);
            locker = null;
            Cursor cursor = null;
            commitStatus = null;
            try {
                locker = LockerFactory.getReadableLocker(this, txn, cursorConfig.getReadCommitted());
                cursor = new Cursor(this, locker, cursorConfig);
                cursor.setNonSticky(true);
                operationStatus = commitStatus = cursor.search(key, data, lockMode, CursorImpl.SearchMode.SET);
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
                catch (Error E) {
                    DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws LockConflictException, DatabaseException, IllegalArgumentException {
        OperationStatus operationStatus;
        OperationStatus commitStatus;
        Locker locker;
        block9: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForNullDbt(data, "data", true);
            this.checkOpen("Can't call Database.getSearchBoth:");
            this.trace(Level.FINEST, "Database.getSearchBoth", txn, key, data, lockMode);
            this.getSearchBothStat.increment();
            CursorConfig cursorConfig = CursorConfig.DEFAULT;
            if (lockMode == LockMode.READ_COMMITTED) {
                cursorConfig = CursorConfig.READ_COMMITTED;
                lockMode = null;
            }
            this.checkLockModeWithoutTxn(txn, lockMode);
            locker = null;
            Cursor cursor = null;
            commitStatus = null;
            try {
                locker = LockerFactory.getReadableLocker(this, txn, cursorConfig.getReadCommitted());
                cursor = new Cursor(this, locker, cursorConfig);
                cursor.setNonSticky(true);
                operationStatus = commitStatus = cursor.search(key, data, lockMode, CursorImpl.SearchMode.BOTH);
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
                catch (Error E) {
                    DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkOpen("Can't call Database.put");
        this.trace(Level.FINEST, "Database.put", txn, key, data, null);
        this.putStat.increment();
        return this.putInternal(txn, key, data, PutMode.OVERWRITE);
    }

    public OperationStatus putNoOverwrite(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkOpen("Can't call Database.putNoOverWrite");
        this.trace(Level.FINEST, "Database.putNoOverwrite", txn, key, data, null);
        this.putNoOverwriteStat.increment();
        return this.putInternal(txn, key, data, PutMode.NO_OVERWRITE);
    }

    public OperationStatus putNoDupData(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkOpen("Can't call Database.putNoDupData");
        if (!this.databaseImpl.getSortedDuplicates()) {
            throw new UnsupportedOperationException("Database is not configured for duplicate data.");
        }
        this.trace(Level.FINEST, "Database.putNoDupData", txn, key, data, null);
        this.putNoDupDataStat.increment();
        return this.putInternal(txn, key, data, PutMode.NO_DUP_DATA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus putInternal(Transaction txn, DatabaseEntry key, DatabaseEntry data, PutMode putMode) throws DatabaseException {
        OperationStatus operationStatus;
        OperationStatus commitStatus;
        Locker locker;
        block8: {
            locker = null;
            Cursor cursor = null;
            commitStatus = OperationStatus.KEYEXIST;
            try {
                locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.databaseImpl.isInternalDb(), this.isTransactional(), this.databaseImpl.isReplicated());
                cursor = new Cursor(this, locker, null);
                cursor.setNonSticky(true);
                operationStatus = commitStatus = cursor.putInternal(key, data, putMode);
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
                catch (Error E) {
                    DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    public JoinCursor join(Cursor[] cursors, JoinConfig config) throws DatabaseException, IllegalArgumentException {
        try {
            this.checkEnv();
            this.checkOpen("Can't call Database.join");
            DatabaseUtil.checkForNullParam(cursors, "cursors");
            if (cursors.length == 0) {
                throw new IllegalArgumentException("At least one cursor is required.");
            }
            Locker locker = cursors[0].getCursorImpl().getLocker();
            if (!locker.isTransactional()) {
                EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
                for (int i = 1; i < cursors.length; ++i) {
                    Locker locker2 = cursors[i].getCursorImpl().getLocker();
                    if (locker2.isTransactional()) {
                        throw new IllegalArgumentException("All cursors must use the same transaction.");
                    }
                    EnvironmentImpl env2 = cursors[i].getDatabaseImpl().getEnv();
                    if (env == env2) continue;
                    throw new IllegalArgumentException("All cursors must use the same environment.");
                }
                locker = null;
            } else {
                for (int i = 1; i < cursors.length; ++i) {
                    Locker locker2 = cursors[i].getCursorImpl().getLocker();
                    if (locker.getTxnLocker() == locker2.getTxnLocker()) continue;
                    throw new IllegalArgumentException("All cursors must use the same transaction.");
                }
            }
            return new JoinCursor(locker, this, cursors, config);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    public void preload(long maxBytes) throws DatabaseException {
        this.checkEnv();
        this.checkOpen("Can't call Database.preload");
        PreloadConfig config = new PreloadConfig();
        config.setMaxBytes(maxBytes);
        this.databaseImpl.preload(config);
    }

    public void preload(long maxBytes, long maxMillisecs) throws DatabaseException {
        this.checkEnv();
        this.checkOpen("Can't call Database.preload");
        PreloadConfig config = new PreloadConfig();
        config.setMaxBytes(maxBytes);
        config.setMaxMillisecs(maxMillisecs);
        this.databaseImpl.preload(config);
    }

    public PreloadStats preload(PreloadConfig config) throws DatabaseException {
        this.checkEnv();
        this.checkOpen("Can't call Database.preload");
        PreloadConfig useConfig = config == null ? new PreloadConfig() : config;
        return this.databaseImpl.preload(useConfig);
    }

    public long count() throws DatabaseException {
        this.checkEnv();
        this.checkOpen("Can't call Database.count");
        return this.databaseImpl.count(0L);
    }

    public long count(long memoryLimit) throws DatabaseException {
        this.checkEnv();
        this.checkOpen("Can't call Database.count");
        return this.databaseImpl.count(memoryLimit);
    }

    public DatabaseStats getStats(StatsConfig config) throws DatabaseException {
        StatsConfig useConfig;
        this.checkEnv();
        this.checkOpen("Can't call Database.stat");
        StatsConfig statsConfig = useConfig = config == null ? StatsConfig.DEFAULT : config;
        if (this.databaseImpl != null) {
            return this.databaseImpl.stat(useConfig);
        }
        return null;
    }

    public DatabaseStats verify(VerifyConfig config) throws DatabaseException {
        try {
            this.checkEnv();
            this.checkOpen("Can't call Database.verify");
            VerifyConfig useConfig = config == null ? VerifyConfig.DEFAULT : config;
            DatabaseStats stats = this.databaseImpl.getEmptyStats();
            this.databaseImpl.verify(useConfig, stats);
            return stats;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    public String getDatabaseName() throws DatabaseException {
        try {
            this.checkEnv();
            if (this.databaseImpl != null) {
                return this.databaseImpl.getName();
            }
            return null;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    String getDebugName() {
        if (this.databaseImpl != null) {
            return this.databaseImpl.getDebugName();
        }
        return null;
    }

    public DatabaseConfig getConfig() {
        try {
            return DatabaseConfig.combineConfig(this.databaseImpl, this.configuration);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    boolean isTransactional() {
        return this.databaseImpl.isTransactional();
    }

    public Environment getEnvironment() {
        return this.envHandle;
    }

    public List<SecondaryDatabase> getSecondaryDatabases() {
        return new ArrayList<SecondaryDatabase>(this.simpleAssocSecondaries);
    }

    public int compareKeys(DatabaseEntry entry1, DatabaseEntry entry2) {
        return this.doCompareKeys(entry1, entry2, false);
    }

    public int compareDuplicates(DatabaseEntry entry1, DatabaseEntry entry2) {
        return this.doCompareKeys(entry1, entry2, true);
    }

    private int doCompareKeys(DatabaseEntry entry1, DatabaseEntry entry2, boolean duplicates) {
        try {
            this.checkEnv();
            this.checkOpen("Can't compare keys/duplicates");
            DatabaseUtil.checkForNullDbt(entry1, "entry1", true);
            DatabaseUtil.checkForNullDbt(entry2, "entry2", true);
            DatabaseUtil.checkForPartialKey(entry1);
            DatabaseUtil.checkForPartialKey(entry2);
            return this.databaseImpl.compareEntries(entry1, entry2, duplicates);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    boolean isWritable() {
        return this.isWritable;
    }

    DatabaseImpl getDatabaseImpl() {
        return this.databaseImpl;
    }

    HandleLocker initHandleLocker(EnvironmentImpl envImpl, Locker openDbLocker) {
        this.handleLocker = HandleLocker.createHandleLocker(envImpl, openDbLocker);
        return this.handleLocker;
    }

    void removeCursor(ForwardCursor ignore) throws DatabaseException {
        if (this.state != DbState.PREEMPTED) {
            this.checkOpen("Database was closed while still in use:");
        }
        this.openCursors.getAndDecrement();
    }

    void addCursor(ForwardCursor ignore) throws DatabaseException {
        this.checkOpen("Database was closed while still in use:");
        this.openCursors.getAndIncrement();
    }

    void checkOpen(String msg) {
        switch (this.state) {
            case OPEN: {
                break;
            }
            case CLOSED: {
                throw new IllegalStateException(msg + " Database was closed.");
            }
            case INVALID: {
                throw new IllegalStateException(msg + " The Transaction used to open the Database was aborted.");
            }
            case PREEMPTED: {
                throw this.preemptedCause.wrapSelf(msg);
            }
            default: {
                assert (false) : this.state;
                break;
            }
        }
    }

    void checkEnv() throws EnvironmentFailureException {
        this.envHandle.checkHandleIsValid();
        this.envHandle.checkEnv();
    }

    void checkLockModeWithoutTxn(Transaction userTxn, LockMode lockMode) {
        if (userTxn == null && LockMode.RMW.equals((Object)lockMode)) {
            throw new IllegalArgumentException((Object)((Object)lockMode) + " is meaningless and can not be specified " + "when a null (autocommit) transaction is used. There " + "will never be a follow on operation which will promote " + "the lock to WRITE.");
        }
    }

    void trace(Level level, String methodName, Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            if (txn != null) {
                sb.append(" txnId=").append(txn.getId());
            }
            sb.append(" key=").append(key.dumpData());
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.envHandle.getEnvironmentImpl(), level, sb.toString());
        }
    }

    void trace(Level level, String methodName, Transaction txn, Object config) throws DatabaseException {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            sb.append(" name=" + this.getDebugName());
            if (txn != null) {
                sb.append(" txnId=").append(txn.getId());
            }
            if (config != null) {
                sb.append(" config=").append(config);
            }
            LoggerUtils.logMsg(this.logger, this.envHandle.getEnvironmentImpl(), level, sb.toString());
        }
    }

    boolean hasSecondaryOrForeignKeyAssociations() {
        return !this.secAssoc.isEmpty() || !this.foreignKeySecondaries.isEmpty();
    }

    SecondaryIntegrityException secondaryRefersToMissingPrimaryKey(Locker locker, DatabaseEntry secKey, DatabaseEntry priKey) throws DatabaseException {
        return new SecondaryIntegrityException(locker, "Secondary refers to a missing key in the primary database", this.getDebugName(), secKey, priKey);
    }

    static enum DbState {
        OPEN,
        CLOSED,
        INVALID,
        PREEMPTED;

    }
}

