/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je;

import com.tangosol.internal.sleepycat.je.CheckpointConfig;
import com.tangosol.internal.sleepycat.je.Database;
import com.tangosol.internal.sleepycat.je.DatabaseConfig;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.DatabaseExistsException;
import com.tangosol.internal.sleepycat.je.DatabaseNotFoundException;
import com.tangosol.internal.sleepycat.je.DbInternal;
import com.tangosol.internal.sleepycat.je.EnvironmentConfig;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.EnvironmentLockedException;
import com.tangosol.internal.sleepycat.je.EnvironmentMutableConfig;
import com.tangosol.internal.sleepycat.je.EnvironmentNotFoundException;
import com.tangosol.internal.sleepycat.je.EnvironmentStats;
import com.tangosol.internal.sleepycat.je.LockStats;
import com.tangosol.internal.sleepycat.je.PreloadConfig;
import com.tangosol.internal.sleepycat.je.PreloadStats;
import com.tangosol.internal.sleepycat.je.SecondaryConfig;
import com.tangosol.internal.sleepycat.je.SecondaryDatabase;
import com.tangosol.internal.sleepycat.je.StatsConfig;
import com.tangosol.internal.sleepycat.je.ThreadInterruptedException;
import com.tangosol.internal.sleepycat.je.Transaction;
import com.tangosol.internal.sleepycat.je.TransactionConfig;
import com.tangosol.internal.sleepycat.je.TransactionStats;
import com.tangosol.internal.sleepycat.je.VerifyConfig;
import com.tangosol.internal.sleepycat.je.VersionMismatchException;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.DbConfigManager;
import com.tangosol.internal.sleepycat.je.dbi.DbEnvPool;
import com.tangosol.internal.sleepycat.je.dbi.DbTree;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.dbi.RepConfigProxy;
import com.tangosol.internal.sleepycat.je.dbi.StartupTracker;
import com.tangosol.internal.sleepycat.je.dbi.TriggerManager;
import com.tangosol.internal.sleepycat.je.txn.HandleLocker;
import com.tangosol.internal.sleepycat.je.txn.Locker;
import com.tangosol.internal.sleepycat.je.txn.LockerFactory;
import com.tangosol.internal.sleepycat.je.txn.Txn;
import com.tangosol.internal.sleepycat.je.utilint.DatabaseUtil;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import com.tangosol.internal.sleepycat.je.utilint.Pair;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.transaction.xa.Xid;

public class Environment
implements Closeable {
    protected EnvironmentImpl envImpl;
    private TransactionConfig defaultTxnConfig;
    private EnvironmentMutableConfig handleConfig;
    private final EnvironmentConfig appliedFinalConfig;
    private final Map<Database, Database> referringDbs;
    private final Map<Transaction, Transaction> referringDbTxns;
    public static final String CLEANER_NAME = "Cleaner";
    public static final String INCOMP_NAME = "INCompressor";
    public static final String CHECKPOINTER_NAME = "Checkpointer";
    public static final String STATCAPTURE_NAME = "StatCapture";

    public Environment(File envHome, EnvironmentConfig configuration) throws EnvironmentNotFoundException, EnvironmentLockedException, VersionMismatchException, DatabaseException, IllegalArgumentException {
        this(envHome, configuration, true, null, null);
    }

    protected Environment(File envHome, EnvironmentConfig configuration, RepConfigProxy repConfigProxy, EnvironmentImpl envImplParam) {
        this(envHome, configuration, true, repConfigProxy, envImplParam);
    }

    Environment(File envHome) {
        this(envHome, null, false, null, null);
    }

    protected Environment(File envHome, EnvironmentConfig envConfig, boolean openIfNeeded, RepConfigProxy repConfigProxy, EnvironmentImpl envImplParam) {
        assert (openIfNeeded || envConfig == null || envImplParam != null);
        this.envImpl = null;
        this.referringDbs = new ConcurrentHashMap<Database, Database>();
        this.referringDbTxns = new ConcurrentHashMap<Transaction, Transaction>();
        DatabaseUtil.checkForNullParam(envHome, "envHome");
        this.appliedFinalConfig = this.setupHandleConfig(envHome, envConfig, repConfigProxy);
        this.envImpl = envImplParam != null ? envImplParam : this.makeEnvironmentImpl(envHome, envConfig, openIfNeeded, repConfigProxy);
    }

    protected EnvironmentImpl makeEnvironmentImpl(File envHome, EnvironmentConfig envConfig, boolean openIfNeeded, RepConfigProxy repConfigProxy) {
        this.envImpl = DbEnvPool.getInstance().getEnvironment(envHome, this.appliedFinalConfig, envConfig != null, openIfNeeded, this.setupRepConfig(envHome, repConfigProxy, envConfig));
        if (this.envImpl != null) {
            this.envImpl.registerMBean(this);
        }
        return this.envImpl;
    }

    private EnvironmentConfig setupHandleConfig(File envHome, EnvironmentConfig envConfig, RepConfigProxy repConfig) throws IllegalArgumentException {
        EnvironmentConfig baseConfig = envConfig == null ? EnvironmentConfig.DEFAULT : envConfig;
        EnvironmentConfig useConfig = baseConfig.clone();
        if (useConfig.getLoadPropertyFile()) {
            DbConfigManager.applyFileConfig(envHome, DbInternal.getProps(useConfig), false);
        }
        this.copyToHandleConfig(useConfig, useConfig, repConfig);
        return useConfig;
    }

    protected RepConfigProxy setupRepConfig(File envHome, RepConfigProxy repConfigProxy, EnvironmentConfig envConfig) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws DatabaseException {
        if (this.envImpl == null) {
            return;
        }
        if (!this.envImpl.isValid()) {
            try {
                this.envImpl.closeAfterInvalid();
            }
            finally {
                this.envImpl = null;
            }
            return;
        }
        StringBuilder errors = new StringBuilder();
        try {
            this.checkForCloseErrors(errors);
            try {
                this.envImpl.close();
            }
            catch (RuntimeException e) {
                if (!this.envImpl.isValid()) {
                    throw e;
                }
                errors.append("\nWhile closing Environment encountered exception: ");
                errors.append(e).append("\n");
            }
            if (errors.length() > 0) {
                throw new IllegalStateException(errors.toString());
            }
        }
        finally {
            this.envImpl = null;
        }
    }

    synchronized void closeInternalHandle() {
        StringBuilder errors = new StringBuilder();
        this.checkForCloseErrors(errors);
        if (errors.length() > 0) {
            throw new IllegalStateException(errors.toString());
        }
    }

    private void checkForCloseErrors(StringBuilder errors) {
        this.checkOpenDbs(errors);
        this.checkOpenTxns(errors);
        if (!this.isInternalHandle()) {
            this.checkOpenXATransactions(errors);
        }
    }

    private void checkOpenXATransactions(StringBuilder errors) {
        Xid[] openXids = this.envImpl.getTxnManager().XARecover();
        if (openXids != null && openXids.length > 0) {
            errors.append("There ");
            int nXATxns = openXids.length;
            if (nXATxns == 1) {
                errors.append("is 1 existing XA transaction opened");
                errors.append(" in the Environment.\n");
                errors.append("It");
            } else {
                errors.append("are ");
                errors.append(nXATxns);
                errors.append(" existing transactions opened in");
                errors.append(" the Environment.\n");
                errors.append("They");
            }
            errors.append(" will be left open ...\n");
        }
    }

    private void checkOpenTxns(StringBuilder errors) {
        int nTxns;
        int n = nTxns = this.referringDbTxns == null ? 0 : this.referringDbTxns.size();
        if (nTxns == 0) {
            return;
        }
        errors.append("There ");
        if (nTxns == 1) {
            errors.append("is 1 existing transaction opened");
            errors.append(" against the Environment.\n");
        } else {
            errors.append("are ");
            errors.append(nTxns);
            errors.append(" existing transactions opened against");
            errors.append(" the Environment.\n");
        }
        errors.append("Aborting open transactions ...\n");
        for (Transaction txn : this.referringDbTxns.keySet()) {
            try {
                errors.append("aborting " + txn);
                txn.abort();
            }
            catch (RuntimeException e) {
                if (!this.envImpl.isValid()) {
                    throw e;
                }
                errors.append("\nWhile aborting transaction ");
                errors.append(txn.getId());
                errors.append(" encountered exception: ");
                errors.append(e).append("\n");
            }
        }
    }

    private void checkOpenDbs(StringBuilder errors) {
        if (this.referringDbs.isEmpty()) {
            return;
        }
        int nOpenUserDbs = 0;
        for (Database db : this.referringDbs.keySet()) {
            String dbName = "";
            try {
                dbName = db.getDebugName();
                if (!db.getDatabaseImpl().isInternalDb()) {
                    ++nOpenUserDbs;
                    errors.append("Unclosed Database: ");
                    errors.append(dbName).append("\n");
                }
                db.close();
            }
            catch (RuntimeException e) {
                if (!this.envImpl.isValid()) {
                    throw e;
                }
                errors.append("\nWhile closing Database ");
                errors.append(dbName);
                errors.append(" encountered exception: ");
                errors.append(LoggerUtils.getStackTrace(e)).append("\n");
            }
        }
        if (nOpenUserDbs > 0) {
            errors.append("Databases left open: ");
            errors.append(nOpenUserDbs).append("\n");
        }
    }

    public synchronized Database openDatabase(Transaction txn, String databaseName, DatabaseConfig dbConfig) throws DatabaseNotFoundException, DatabaseExistsException, IllegalArgumentException, IllegalStateException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            if (dbConfig == null) {
                dbConfig = DatabaseConfig.DEFAULT;
            }
            Database db = new Database(this);
            this.setupDatabase(txn, db, databaseName, dbConfig, false);
            return db;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    synchronized Database openInternalDatabase(Transaction txn, String databaseName, DatabaseConfig dbConfig) throws DatabaseNotFoundException, DatabaseExistsException {
        assert (DbTree.isReservedDbName(databaseName)) : databaseName;
        Database db = new Database(this);
        this.setupDatabase(txn, db, databaseName, dbConfig, true);
        return db;
    }

    public synchronized SecondaryDatabase openSecondaryDatabase(Transaction txn, String databaseName, Database primaryDatabase, SecondaryConfig dbConfig) throws DatabaseNotFoundException, DatabaseExistsException, DatabaseException, IllegalArgumentException, IllegalStateException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            this.envImpl.getSecondaryAssociationLock().writeLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(this.envImpl, (Throwable)e);
        }
        try {
            if (dbConfig == null) {
                dbConfig = SecondaryConfig.DEFAULT;
            }
            SecondaryDatabase db = new SecondaryDatabase(this, dbConfig, primaryDatabase);
            this.setupDatabase(txn, db, databaseName, dbConfig, false);
            SecondaryDatabase secondaryDatabase = db;
            return secondaryDatabase;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
        finally {
            this.envImpl.getSecondaryAssociationLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDatabase(Transaction txn, Database newDb, String databaseName, DatabaseConfig dbConfig, boolean isInternalDb) throws DatabaseNotFoundException, DatabaseExistsException {
        Locker locker;
        boolean operationOk;
        block10: {
            block11: {
                this.checkEnv();
                DatabaseUtil.checkForNullParam(databaseName, "databaseName");
                LoggerUtils.envLogMsg(Level.FINEST, this.envImpl, "Environment.open:  name=" + databaseName + " dbConfig=" + dbConfig);
                boolean autoTxnIsReplicated = dbConfig.getReplicated() && this.envImpl.isReplicated();
                dbConfig.validateOnDbOpen(databaseName, autoTxnIsReplicated);
                this.validateDbConfigAgainstEnv(dbConfig, databaseName, isInternalDb);
                this.envImpl.criticalEviction(false);
                DatabaseImpl database = null;
                operationOk = false;
                HandleLocker handleLocker = null;
                locker = LockerFactory.getWritableLocker(this, txn, isInternalDb, dbConfig.getTransactional(), autoTxnIsReplicated, null);
                try {
                    boolean firstWriteHandle;
                    boolean databaseExists;
                    handleLocker = newDb.initHandleLocker(this.envImpl, locker);
                    database = this.envImpl.getDbTree().getDb(locker, databaseName, handleLocker);
                    boolean dbCreated = false;
                    boolean bl = databaseExists = database != null && !database.isDeleted();
                    if (databaseExists) {
                        if (dbConfig.getAllowCreate() && dbConfig.getExclusiveCreate()) {
                            throw new DatabaseExistsException("Database " + databaseName + " already exists");
                        }
                        newDb.initExisting(this, locker, database, databaseName, dbConfig);
                    } else {
                        this.envImpl.getDbTree().releaseDb(database);
                        database = null;
                        if (!isInternalDb && DbTree.isReservedDbName(databaseName)) {
                            throw new IllegalArgumentException(databaseName + " is a reserved database name.");
                        }
                        if (!dbConfig.getAllowCreate()) {
                            throw new DatabaseNotFoundException("Database " + databaseName + " not found.");
                        }
                        database = newDb.initNew(this, locker, databaseName, dbConfig);
                        dbCreated = true;
                    }
                    operationOk = true;
                    this.addReferringHandle(newDb);
                    locker.addOpenedDatabase(newDb);
                    boolean bl2 = firstWriteHandle = newDb.isWritable() && newDb.getDatabaseImpl().noteWriteHandleOpen() == 1;
                    if (dbCreated || firstWriteHandle) {
                        TriggerManager.runOpenTriggers(locker, newDb, dbCreated);
                    }
                    if (operationOk) break block10;
                    this.envImpl.getDbTree().releaseDb(database);
                    if (handleLocker == null) break block11;
                }
                catch (Throwable throwable) {
                    if (!operationOk) {
                        this.envImpl.getDbTree().releaseDb(database);
                        if (handleLocker != null) {
                            handleLocker.operationEnd(false);
                        }
                        newDb.removeReferringAssociations();
                    }
                    locker.operationEnd(operationOk);
                    throw throwable;
                }
                handleLocker.operationEnd(false);
            }
            newDb.removeReferringAssociations();
        }
        locker.operationEnd(operationOk);
    }

    private void validateDbConfigAgainstEnv(DatabaseConfig dbConfig, String databaseName, boolean isInternalDb) throws IllegalArgumentException {
        if (this.envImpl.isReplicated() && dbConfig.getReplicated() && !dbConfig.getReadOnly() && !dbConfig.getTransactional()) {
            throw new IllegalArgumentException("Read/Write Database instances for replicated database " + databaseName + " must be transactional.");
        }
        if (!isInternalDb && dbConfig.getTransactional() && !this.envImpl.isTransactional()) {
            throw new IllegalArgumentException("Attempted to open Database " + databaseName + " transactionally, but parent Environment is" + " not transactional");
        }
        if (this.envImpl.isReadOnly() && !dbConfig.getReadOnly()) {
            throw new IllegalArgumentException("Attempted to open Database " + databaseName + " as writable but parent Environment is read only ");
        }
    }

    public void removeDatabase(Transaction txn, final String databaseName) throws DatabaseNotFoundException {
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        new DbNameOperation<Void>(txn, databaseName){

            @Override
            Pair<DatabaseImpl, Void> runWork(Locker locker) throws DatabaseNotFoundException, DbTree.NeedRepLockerException {
                DatabaseImpl dbImpl = this.dbTree.dbRemove(locker, databaseName, null);
                return new Pair<DatabaseImpl, Object>(dbImpl, null);
            }

            @Override
            void runTriggers(Locker locker, DatabaseImpl dbImpl) {
                TriggerManager.runRemoveTriggers(locker, dbImpl);
            }
        }.run();
    }

    public void renameDatabase(Transaction txn, final String databaseName, final String newName) throws DatabaseNotFoundException {
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        DatabaseUtil.checkForNullParam(newName, "newName");
        new DbNameOperation<Void>(txn, databaseName){

            @Override
            Pair<DatabaseImpl, Void> runWork(Locker locker) throws DatabaseNotFoundException, DbTree.NeedRepLockerException {
                DatabaseImpl dbImpl = this.dbTree.dbRename(locker, databaseName, newName);
                return new Pair<DatabaseImpl, Object>(dbImpl, null);
            }

            @Override
            void runTriggers(Locker locker, DatabaseImpl dbImpl) {
                TriggerManager.runRenameTriggers(locker, dbImpl, newName);
            }
        }.run();
    }

    public long truncateDatabase(Transaction txn, final String databaseName, final boolean returnCount) throws DatabaseNotFoundException {
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        return (Long)new DbNameOperation<Long>(txn, databaseName){

            @Override
            Pair<DatabaseImpl, Long> runWork(Locker locker) throws DatabaseNotFoundException, DbTree.NeedRepLockerException {
                DbTree.TruncateDbResult result = this.dbTree.truncate(locker, databaseName, returnCount);
                return new Pair<DatabaseImpl, Long>(result.newDb, result.recordCount);
            }

            @Override
            void runTriggers(Locker locker, DatabaseImpl dbImpl) {
                TriggerManager.runTruncateTriggers(locker, dbImpl);
            }
        }.run();
    }

    long getMemoryUsage() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        return this.envImpl.getMemoryBudget().getCacheMemoryUsage();
    }

    public File getHome() throws DatabaseException {
        this.checkHandleIsValid();
        return this.envImpl.getEnvironmentHome();
    }

    TransactionConfig getDefaultTxnConfig() {
        return this.defaultTxnConfig;
    }

    private void copyToHandleConfig(EnvironmentMutableConfig useConfig, EnvironmentConfig initStaticConfig, RepConfigProxy initRepConfig) {
        EnvironmentMutableConfig newHandleConfig = new EnvironmentMutableConfig();
        useConfig.copyHandlePropsTo(newHandleConfig);
        this.handleConfig = newHandleConfig;
        TransactionConfig newTxnConfig = TransactionConfig.DEFAULT.clone();
        newTxnConfig.setNoSync(this.handleConfig.getTxnNoSync());
        newTxnConfig.setWriteNoSync(this.handleConfig.getTxnWriteNoSync());
        newTxnConfig.setDurability(this.handleConfig.getDurability());
        if (initStaticConfig != null) {
            newTxnConfig.setSerializableIsolation(initStaticConfig.getTxnSerializableIsolation());
            newTxnConfig.setReadCommitted(initStaticConfig.getTxnReadCommitted());
        } else {
            newTxnConfig.setSerializableIsolation(this.defaultTxnConfig.getSerializableIsolation());
            newTxnConfig.setReadCommitted(this.defaultTxnConfig.getReadCommitted());
            newTxnConfig.setConsistencyPolicy(this.defaultTxnConfig.getConsistencyPolicy());
        }
        if (initRepConfig != null) {
            newTxnConfig.setConsistencyPolicy(initRepConfig.getConsistencyPolicy());
        }
        this.defaultTxnConfig = newTxnConfig;
    }

    public Transaction beginTransaction(Transaction parent, TransactionConfig txnConfig) throws DatabaseException, IllegalArgumentException {
        try {
            return this.beginTransactionInternal(parent, txnConfig, false);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    Transaction beginInternalTransaction(TransactionConfig txnConfig) {
        return this.beginTransactionInternal(null, txnConfig, true);
    }

    private Transaction beginTransactionInternal(Transaction parent, TransactionConfig txnConfig, boolean isInternalTxn) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        if (parent != null) {
            throw new IllegalArgumentException("Parent txn is non-null. Nested transactions are not supported.");
        }
        if (!isInternalTxn && !this.envImpl.isTransactional()) {
            throw new UnsupportedOperationException("Transactions can not be used in a non-transactional environment");
        }
        this.checkTxnConfig(txnConfig);
        TransactionConfig useConfig = null;
        if (txnConfig == null) {
            useConfig = this.defaultTxnConfig;
        } else {
            if (!(!this.defaultTxnConfig.getNoSync() && !this.defaultTxnConfig.getWriteNoSync() || txnConfig.getNoSync() || txnConfig.getSync() || txnConfig.getWriteNoSync())) {
                useConfig = txnConfig.clone();
                if (this.defaultTxnConfig.getWriteNoSync()) {
                    useConfig.setWriteNoSync(true);
                } else {
                    useConfig.setNoSync(true);
                }
            }
            if (this.defaultTxnConfig.getDurability() != null && txnConfig.getDurability() == null) {
                if (useConfig == null) {
                    useConfig = txnConfig.clone();
                }
                useConfig.setDurability(this.defaultTxnConfig.getDurability());
            }
            if (this.defaultTxnConfig.getConsistencyPolicy() != null && txnConfig.getConsistencyPolicy() == null) {
                if (useConfig == null) {
                    useConfig = txnConfig.clone();
                }
                useConfig.setConsistencyPolicy(this.defaultTxnConfig.getConsistencyPolicy());
            }
            if (!(txnConfig.getSerializableIsolation() || txnConfig.getReadCommitted() || txnConfig.getReadUncommitted())) {
                if (this.defaultTxnConfig.getSerializableIsolation()) {
                    if (useConfig == null) {
                        useConfig = txnConfig.clone();
                    }
                    useConfig.setSerializableIsolation(true);
                } else if (this.defaultTxnConfig.getReadCommitted()) {
                    if (useConfig == null) {
                        useConfig = txnConfig.clone();
                    }
                    useConfig.setReadCommitted(true);
                }
            }
            if (useConfig == null) {
                useConfig = txnConfig;
            }
        }
        Txn internalTxn = this.envImpl.txnBegin(parent, useConfig);
        Transaction txn = new Transaction(this, internalTxn);
        this.addReferringHandle(txn);
        return txn;
    }

    private void checkTxnConfig(TransactionConfig txnConfig) throws IllegalArgumentException {
        if (txnConfig == null) {
            return;
        }
        if (txnConfig.getSerializableIsolation() && txnConfig.getReadUncommitted() || txnConfig.getSerializableIsolation() && txnConfig.getReadCommitted() || txnConfig.getReadUncommitted() && txnConfig.getReadCommitted()) {
            throw new IllegalArgumentException("Only one may be specified: SerializableIsolation, ReadCommitted or ReadUncommitted");
        }
        if (txnConfig.getDurability() != null && (this.defaultTxnConfig.getSync() || this.defaultTxnConfig.getNoSync() || this.defaultTxnConfig.getWriteNoSync())) {
            throw new IllegalArgumentException("Mixed use of deprecated durability API for the Environment with the new durability API for TransactionConfig.setDurability()");
        }
        if (this.defaultTxnConfig.getDurability() != null && (txnConfig.getSync() || txnConfig.getNoSync() || txnConfig.getWriteNoSync())) {
            throw new IllegalArgumentException("Mixed use of new durability API for the Environment with the deprecated durability API for TransactionConfig.");
        }
    }

    public void checkpoint(CheckpointConfig ckptConfig) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            CheckpointConfig useConfig = ckptConfig == null ? CheckpointConfig.DEFAULT : ckptConfig;
            this.envImpl.invokeCheckpoint(useConfig, "api");
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void sync() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            CheckpointConfig config = new CheckpointConfig();
            config.setForce(true);
            config.setMinimizeRecoveryTime(true);
            this.envImpl.invokeCheckpoint(config, "sync");
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void flushLog(boolean fsync) {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            this.envImpl.flushLog(fsync);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public int cleanLog() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            return this.envImpl.invokeCleaner();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void evictMemory() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            this.envImpl.invokeEvictor();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void compress() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            this.envImpl.invokeCompressor();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public PreloadStats preload(Database[] databases, PreloadConfig config) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            DatabaseUtil.checkForZeroLengthArrayParam(databases, "databases");
            PreloadConfig useConfig = config == null ? new PreloadConfig() : config;
            int nDbs = databases.length;
            DatabaseImpl[] dbImpls = new DatabaseImpl[nDbs];
            for (int i = 0; i < nDbs; ++i) {
                dbImpls[i] = DbInternal.getDatabaseImpl(databases[i]);
            }
            return this.envImpl.preload(dbImpls, useConfig);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public EnvironmentConfig getConfig() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            EnvironmentConfig config = this.envImpl.cloneConfig();
            this.handleConfig.copyHandlePropsTo(config);
            config.fillInEnvironmentGeneratedProps(this.envImpl);
            return config;
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public synchronized void setMutableConfig(EnvironmentMutableConfig mutableConfig) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            DatabaseUtil.checkForNullParam(mutableConfig, "mutableConfig");
            this.envImpl.setMutableConfig(mutableConfig);
            this.copyToHandleConfig(mutableConfig, null, null);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public EnvironmentMutableConfig getMutableConfig() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            EnvironmentMutableConfig config = this.envImpl.cloneMutableConfig();
            this.handleConfig.copyHandlePropsTo(config);
            config.fillInEnvironmentGeneratedProps(this.envImpl);
            return config;
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public EnvironmentStats getStats(StatsConfig config) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            StatsConfig useConfig;
            StatsConfig statsConfig = useConfig = config == null ? StatsConfig.DEFAULT : config;
            if (this.envImpl != null) {
                return this.envImpl.loadStats(useConfig);
            }
            return new EnvironmentStats();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public LockStats getLockStats(StatsConfig config) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            StatsConfig useConfig = config == null ? StatsConfig.DEFAULT : config;
            return this.envImpl.lockStat(useConfig);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public TransactionStats getTransactionStats(StatsConfig config) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            StatsConfig useConfig = config == null ? StatsConfig.DEFAULT : config;
            return this.envImpl.txnStat(useConfig);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public List<String> getDatabaseNames() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            return this.envImpl.getDbTree().getDbNames();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            VerifyConfig useConfig = config == null ? VerifyConfig.DEFAULT : config;
            return this.envImpl.verify(useConfig, out);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public Transaction getThreadTransaction() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            return this.envImpl.getTxnManager().getTxnForThread();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void setThreadTransaction(Transaction txn) {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            this.envImpl.getTxnManager().setTxnForThread(txn);
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    public boolean isValid() {
        return this.envImpl != null && this.envImpl.isValid();
    }

    public void printStartupInfo(PrintStream out) {
        this.envImpl.getStartupTracker().displayStats(out, StartupTracker.Phase.TOTAL_ENV_OPEN);
    }

    private void addReferringHandle(Database db) {
        this.referringDbs.put(db, db);
    }

    private void addReferringHandle(Transaction txn) {
        this.referringDbTxns.put(txn, txn);
    }

    void removeReferringHandle(Database db) {
        this.referringDbs.remove(db);
    }

    void removeReferringHandle(Transaction txn) {
        this.referringDbTxns.remove(txn);
    }

    public void checkHandleIsValid() {
        if (this.envImpl == null) {
            throw new IllegalStateException("Attempt to use non-open Environment object().");
        }
    }

    EnvironmentImpl getEnvironmentImpl() {
        this.checkHandleIsValid();
        return this.envImpl;
    }

    protected boolean isInternalHandle() {
        return false;
    }

    protected void checkEnv() throws DatabaseException, EnvironmentFailureException {
        if (this.envImpl == null) {
            return;
        }
        this.envImpl.checkIfInvalid();
        this.envImpl.checkNotClosed();
    }

    private void checkWritable() {
        if (this.envImpl.isReadOnly()) {
            throw new UnsupportedOperationException("Environment is Read-Only.");
        }
    }

    private abstract class DbNameOperation<R> {
        private final Transaction txn;
        private final String databaseName;
        final DbTree dbTree;

        DbNameOperation(Transaction txn, String databaseName) {
            this.txn = txn;
            this.databaseName = databaseName;
            Environment.this.checkHandleIsValid();
            Environment.this.checkEnv();
            Environment.this.checkWritable();
            this.dbTree = Environment.this.envImpl.getDbTree();
        }

        abstract Pair<DatabaseImpl, R> runWork(Locker var1) throws DatabaseNotFoundException, DbTree.NeedRepLockerException;

        abstract void runTriggers(Locker var1, DatabaseImpl var2);

        R run() throws DatabaseNotFoundException {
            try {
                return this.runOnce(this.getWritableLocker(false));
            }
            catch (DbTree.NeedRepLockerException e) {
                try {
                    return this.runOnce(this.getWritableLocker(true));
                }
                catch (DbTree.NeedRepLockerException e2) {
                    throw EnvironmentFailureException.unexpectedException(Environment.this.envImpl, (Exception)e);
                }
            }
        }

        private R runOnce(Locker locker) throws DatabaseNotFoundException, DbTree.NeedRepLockerException {
            boolean success = false;
            try {
                Pair<DatabaseImpl, R> results = this.runWork(locker);
                DatabaseImpl dbImpl = results.first();
                if (dbImpl == null) {
                    throw EnvironmentFailureException.unexpectedState(Environment.this.envImpl);
                }
                success = true;
                this.runTriggers(locker, dbImpl);
                R r = results.second();
                return r;
            }
            catch (Error E) {
                Environment.this.envImpl.invalidate(E);
                throw E;
            }
            finally {
                locker.operationEnd(success);
            }
        }

        private Locker getWritableLocker(boolean autoTxnIsReplicated) {
            return LockerFactory.getWritableLocker(Environment.this, this.txn, false, Environment.this.envImpl.isTransactional(), autoTxnIsReplicated);
        }
    }
}

