/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.cleaner;

import com.tangosol.internal.sleepycat.je.cleaner.UtilizationCalculator;
import com.tangosol.internal.sleepycat.je.log.LogUtils;
import com.tangosol.internal.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class CleanerLogSummary
implements Loggable {
    private final List<UtilizationCalculator.AverageSize> recentAvgLNSizes;
    private long endFileNumAtLastAdjustment;
    private int initialAdjustments;

    public CleanerLogSummary(List<UtilizationCalculator.AverageSize> recentAvgLNSizes, long endFileNumAtLastAdjustment, int initialAdjustments) {
        this.recentAvgLNSizes = recentAvgLNSizes;
        this.endFileNumAtLastAdjustment = endFileNumAtLastAdjustment;
        this.initialAdjustments = initialAdjustments;
    }

    public CleanerLogSummary() {
        this.recentAvgLNSizes = new ArrayList<UtilizationCalculator.AverageSize>();
        this.endFileNumAtLastAdjustment = -1L;
        this.initialAdjustments = 0;
    }

    List<UtilizationCalculator.AverageSize> getRecentAvgLNSizes() {
        return this.recentAvgLNSizes;
    }

    long getEndFileNumAtLastAdjustment() {
        return this.endFileNumAtLastAdjustment;
    }

    int getInitialAdjustments() {
        return this.initialAdjustments;
    }

    @Override
    public int getLogSize() {
        int size = LogUtils.getPackedLongLogSize(this.endFileNumAtLastAdjustment) + LogUtils.getPackedIntLogSize(this.initialAdjustments) + LogUtils.getPackedIntLogSize(this.recentAvgLNSizes.size());
        for (UtilizationCalculator.AverageSize avg : this.recentAvgLNSizes) {
            size += LogUtils.getPackedIntLogSize(avg.size);
            size += LogUtils.getPackedIntLogSize(avg.count);
            size += LogUtils.getPackedIntLogSize(avg.estSize);
            size += LogUtils.getPackedIntLogSize(avg.estCount);
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writePackedLong(logBuffer, this.endFileNumAtLastAdjustment);
        LogUtils.writePackedInt(logBuffer, this.initialAdjustments);
        LogUtils.writePackedInt(logBuffer, this.recentAvgLNSizes.size());
        for (UtilizationCalculator.AverageSize avg : this.recentAvgLNSizes) {
            LogUtils.writePackedInt(logBuffer, avg.size);
            LogUtils.writePackedInt(logBuffer, avg.count);
            LogUtils.writePackedInt(logBuffer, avg.estSize);
            LogUtils.writePackedInt(logBuffer, avg.estCount);
        }
    }

    @Override
    public void readFromLog(ByteBuffer logBuffer, int entryVersion) {
        this.endFileNumAtLastAdjustment = LogUtils.readPackedLong(logBuffer);
        this.initialAdjustments = LogUtils.readPackedInt(logBuffer);
        int nAvgLNSizes = LogUtils.readPackedInt(logBuffer);
        for (int i = 0; i < nAvgLNSizes; ++i) {
            int size = LogUtils.readPackedInt(logBuffer);
            int count = LogUtils.readPackedInt(logBuffer);
            int estSize = LogUtils.readPackedInt(logBuffer);
            int estCount = LogUtils.readPackedInt(logBuffer);
            this.recentAvgLNSizes.add(new UtilizationCalculator.AverageSize(size, count, estSize, estCount));
        }
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CleanerLogSummary)) {
            return false;
        }
        CleanerLogSummary o = (CleanerLogSummary)other;
        if (this.endFileNumAtLastAdjustment != o.endFileNumAtLastAdjustment) {
            return false;
        }
        if (this.initialAdjustments != o.initialAdjustments) {
            return false;
        }
        return this.recentAvgLNSizes.equals(o.recentAvgLNSizes);
    }

    public int hashCode() {
        return (int)(this.endFileNumAtLastAdjustment + (long)this.initialAdjustments);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<CleanerLogSummary endFileNumAtLastAdjustment=\"0x").append(Long.toHexString(this.endFileNumAtLastAdjustment));
        sb.append("\" initialAdjustments=\"").append(this.initialAdjustments);
        sb.append("\" recentLNSizesAndCounts=\"");
        for (UtilizationCalculator.AverageSize avg : this.recentAvgLNSizes) {
            sb.append("Cor:");
            sb.append(avg.size);
            sb.append('/');
            sb.append(avg.count);
            sb.append("-Est:");
            sb.append(avg.estSize);
            sb.append('/');
            sb.append(avg.estCount);
            sb.append(' ');
        }
        sb.append("\">");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dumpLog(sb, false);
        return sb.toString();
    }
}

