/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.dbi;

import java.nio.ByteBuffer;

public class Operation {
    public static final Operation PUT = new Operation(1, "PUT");
    public static final Operation NO_OVERWRITE = new Operation(2, "NO_OVERWRITE");
    public static final Operation PLACEHOLDER = new Operation(3, "PLACEHOLDER");
    private static final Operation[] ALL_OPS = new Operation[]{PUT, NO_OVERWRITE, PLACEHOLDER};
    private static final byte MAX_OP = 3;
    private static final byte MIN_OP = 1;
    private byte op;
    private String name;

    public Operation() {
    }

    private Operation(byte op, String name) {
        this.op = op;
        this.name = name;
    }

    public int getContentSize() {
        return 1;
    }

    public void writeToBuffer(ByteBuffer buffer) {
        buffer.put(this.op);
    }

    public static Operation readFromBuffer(ByteBuffer buffer) {
        byte opNum = buffer.get();
        if (opNum >= 1 && opNum <= 3) {
            return ALL_OPS[opNum - 1];
        }
        return new Operation(opNum, "UNKNOWN " + opNum);
    }

    public String toString() {
        return this.name;
    }
}

