/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.dbi;

import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.log.LogUtils;
import com.tangosol.internal.sleepycat.je.trigger.Trigger;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class TriggerUtils {
    static int logSize(byte[][] triggerBytes) {
        if (triggerBytes == null) {
            return LogUtils.getPackedIntLogSize(0);
        }
        int size = LogUtils.getPackedIntLogSize(triggerBytes.length);
        for (byte[] trigger : triggerBytes) {
            size += LogUtils.getByteArrayLogSize(trigger);
        }
        return size;
    }

    static void writeTriggers(ByteBuffer logBuffer, byte[][] triggerBytes) {
        if (triggerBytes == null) {
            LogUtils.writePackedInt(logBuffer, 0);
        } else {
            LogUtils.writePackedInt(logBuffer, triggerBytes.length);
            for (byte[] triggerByte : triggerBytes) {
                LogUtils.writeByteArray(logBuffer, triggerByte);
            }
        }
    }

    static byte[][] readTriggers(ByteBuffer logBuffer, int entryVersion) {
        int triggerCount = LogUtils.readPackedInt(logBuffer);
        if (triggerCount == 0) {
            return null;
        }
        byte[][] triggerBytes = new byte[triggerCount][];
        for (int i = 0; i < triggerBytes.length; ++i) {
            triggerBytes[i] = LogUtils.readByteArray(logBuffer, false);
        }
        return triggerBytes;
    }

    static LinkedList<Trigger> unmarshallTriggers(String dbName, byte[][] triggerBytes, ClassLoader loader) {
        if (triggerBytes == null) {
            return null;
        }
        LinkedList<Trigger> triggers = new LinkedList<Trigger>();
        for (int i = 0; i < triggerBytes.length; ++i) {
            Trigger trigger = (Trigger)DatabaseImpl.bytesToObject(triggerBytes[i], "trigger:" + i, loader);
            trigger.setDatabaseName(dbName);
            triggers.add(trigger);
        }
        return triggers;
    }

    static void dumpTriggers(StringBuilder sb, byte[][] triggerBytes, List<Trigger> triggers) {
        if (triggerBytes == null || triggerBytes.length == 0) {
            return;
        }
        if (triggers != null && triggers.size() != 0) {
            for (Trigger trigger : triggers) {
                sb.append("<trigger name=\"" + trigger.getName() + "\"" + " database name=\"" + (trigger.getDatabaseName() == null ? "null" : trigger.getDatabaseName()) + "\"" + " className=\"" + trigger.getClass().getName() + "\">");
            }
        } else {
            for (int i = 0; i < triggerBytes.length; ++i) {
                sb.append("<trigger name=\"?" + i + "\"" + " className=\"" + "?" + "\">");
            }
        }
    }
}

