/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.incomp;

import com.tangosol.internal.sleepycat.je.CacheMode;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.StatsConfig;
import com.tangosol.internal.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.tangosol.internal.sleepycat.je.config.EnvironmentParams;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseId;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.DbTree;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.incomp.INCompStatDefinition;
import com.tangosol.internal.sleepycat.je.latch.LatchSupport;
import com.tangosol.internal.sleepycat.je.tree.BIN;
import com.tangosol.internal.sleepycat.je.tree.BINReference;
import com.tangosol.internal.sleepycat.je.tree.CursorsExistException;
import com.tangosol.internal.sleepycat.je.tree.IN;
import com.tangosol.internal.sleepycat.je.tree.NodeNotEmptyException;
import com.tangosol.internal.sleepycat.je.tree.Tree;
import com.tangosol.internal.sleepycat.je.utilint.DaemonThread;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import com.tangosol.internal.sleepycat.je.utilint.LongStat;
import com.tangosol.internal.sleepycat.je.utilint.StatGroup;
import com.tangosol.internal.sleepycat.je.utilint.TestHook;
import com.tangosol.internal.sleepycat.je.utilint.TestHookExecute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class INCompressor
extends DaemonThread {
    private static final boolean DEBUG = false;
    private EnvironmentImpl env;
    private final long lockTimeout;
    private StatGroup stats;
    private LongStat splitBins;
    private LongStat dbClosedBins;
    private LongStat cursorsBins;
    private LongStat nonEmptyBins;
    private LongStat processedBins;
    private LongStat compQueueSize;
    private int splitBinsThisRun = 0;
    private int dbClosedBinsThisRun = 0;
    private int cursorsBinsThisRun = 0;
    private int nonEmptyBinsThisRun = 0;
    private int processedBinsThisRun = 0;
    private int lazyProcessed = 0;
    private int wokenUp = 0;
    private Map<Long, BINReference> binRefQueue;
    private final Object binRefQueueSync;
    private TestHook beforeFlushTrackerHook;

    public INCompressor(EnvironmentImpl env, long waitTime, String name) {
        super(waitTime, name, env);
        this.env = env;
        this.lockTimeout = env.getConfigManager().getDuration(EnvironmentParams.COMPRESSOR_LOCK_TIMEOUT);
        this.binRefQueue = new HashMap<Long, BINReference>();
        this.binRefQueueSync = new Object();
        this.stats = new StatGroup("Node Compression", "Removal and compression of internal btree nodes.");
        this.splitBins = new LongStat(this.stats, INCompStatDefinition.INCOMP_SPLIT_BINS);
        this.dbClosedBins = new LongStat(this.stats, INCompStatDefinition.INCOMP_DBCLOSED_BINS);
        this.cursorsBins = new LongStat(this.stats, INCompStatDefinition.INCOMP_CURSORS_BINS);
        this.nonEmptyBins = new LongStat(this.stats, INCompStatDefinition.INCOMP_NON_EMPTY_BINS);
        this.processedBins = new LongStat(this.stats, INCompStatDefinition.INCOMP_PROCESSED_BINS);
        this.compQueueSize = new LongStat(this.stats, INCompStatDefinition.INCOMP_QUEUE_SIZE);
    }

    public synchronized void clearEnv() {
        this.env = null;
    }

    public void setBeforeFlushTrackerHook(TestHook hook) {
        this.beforeFlushTrackerHook = hook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void verifyCursors() throws DatabaseException {
        if (this.env.isClosed()) {
            return;
        }
        ArrayList<BINReference> queueSnapshot = null;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            queueSnapshot = new ArrayList<BINReference>(this.binRefQueue.values());
        }
        DbTree dbTree = this.env.getDbTree();
        HashMap<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
        try {
            for (BINReference binRef : queueSnapshot) {
                DatabaseImpl db = dbTree.getDb(binRef.getDatabaseId(), this.lockTimeout, dbCache);
                BIN bin = this.searchForBIN(db, binRef);
                if (bin == null) continue;
                bin.verifyCursors();
                bin.releaseLatch();
            }
        }
        finally {
            dbTree.releaseDbs(dbCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBinRefQueueSize() {
        int size = 0;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            size = this.binRefQueue.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinToQueue(BIN bin, boolean doWakeup) {
        Object object = this.binRefQueueSync;
        synchronized (object) {
            this.addBinToQueueAlreadyLatched(bin);
        }
        if (doWakeup) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinRefToQueue(BINReference binRef, boolean doWakeup) {
        Object object = this.binRefQueueSync;
        synchronized (object) {
            this.addBinRefToQueueAlreadyLatched(binRef);
        }
        if (doWakeup) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMultipleBinRefsToQueue(Collection<BINReference> binRefs, boolean doWakeup) {
        Object object = this.binRefQueueSync;
        synchronized (object) {
            for (BINReference binRef : binRefs) {
                this.addBinRefToQueueAlreadyLatched(binRef);
            }
        }
        if (doWakeup) {
            this.wakeup();
        }
    }

    private void addBinRefToQueueAlreadyLatched(BINReference binRef) {
        Long node = binRef.getNodeId();
        if (this.binRefQueue.containsKey(node)) {
            return;
        }
        this.binRefQueue.put(node, binRef);
    }

    private void addBinToQueueAlreadyLatched(BIN bin) {
        Long node = bin.getNodeId();
        if (this.binRefQueue.containsKey(node)) {
            return;
        }
        this.binRefQueue.put(node, bin.createReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(long nodeId) {
        Object object = this.binRefQueueSync;
        synchronized (object) {
            return this.binRefQueue.containsKey(nodeId);
        }
    }

    public StatGroup loadStats(StatsConfig config) {
        this.compQueueSize.set(Long.valueOf(this.getBinRefQueueSize()));
        if (config.getClear()) {
            this.lazyProcessed = 0;
            this.wokenUp = 0;
        }
        return this.stats.cloneGroup(config.getClear());
    }

    @Override
    protected long nDeadlockRetries() {
        return this.env.getConfigManager().getInt(EnvironmentParams.COMPRESSOR_RETRY);
    }

    @Override
    public synchronized void onWakeup() throws DatabaseException {
        if (this.env.isClosed()) {
            return;
        }
        ++this.wokenUp;
        this.doCompress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doCompress() throws DatabaseException {
        Map<Long, BINReference> queueSnapshot = null;
        int binQueueSize = 0;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            binQueueSize = this.binRefQueue.size();
            if (binQueueSize > 0) {
                queueSnapshot = this.binRefQueue;
                this.binRefQueue = new HashMap<Long, BINReference>();
            }
        }
        if (binQueueSize > 0) {
            this.resetPerRunCounters();
            LoggerUtils.fine(this.logger, this.envImpl, "InCompress.doCompress called, queue size: " + binQueueSize);
            if (LatchSupport.TRACK_LATCHES) {
                LatchSupport.expectBtreeLatchesHeld(0);
            }
            LocalUtilizationTracker localTracker = new LocalUtilizationTracker(this.env);
            HashMap<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
            DbTree dbTree = this.env.getDbTree();
            BINSearch binSearch = new BINSearch();
            try {
                Iterator<BINReference> it = queueSnapshot.values().iterator();
                while (it.hasNext()) {
                    if (this.env.isClosed()) {
                        return;
                    }
                    BINReference binRef = it.next();
                    if (!this.findDBAndBIN(binSearch, binRef, dbTree, dbCache)) continue;
                    this.compressBin(binSearch.db, binSearch.bin, binRef, localTracker);
                }
                assert (TestHookExecute.doHookIfSet(this.beforeFlushTrackerHook));
                this.env.getUtilizationProfile().flushLocalTracker(localTracker);
            }
            finally {
                dbTree.releaseDbs(dbCache);
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(0);
                }
                this.accumulatePerRunCounters();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressBin(DatabaseImpl db, BIN bin, BINReference binRef, LocalUtilizationTracker localTracker) {
        byte[] idKey = bin.getIdentifierKey();
        boolean empty = bin.getNEntries() == 0;
        try {
            if (!empty) {
                if (bin.shouldLogDelta()) {
                    return;
                }
                if (bin.nCursors() > 0) {
                    this.addBinRefToQueue(binRef, false);
                    ++this.cursorsBinsThisRun;
                    return;
                }
                if (!bin.compress(localTracker)) {
                    this.addBinRefToQueue(binRef, false);
                    return;
                }
                empty = bin.getNEntries() == 0;
            }
        }
        finally {
            bin.releaseLatch();
        }
        if (empty) {
            this.pruneBIN(db, binRef, idKey, localTracker);
        }
    }

    private void pruneBIN(DatabaseImpl dbImpl, BINReference binRef, byte[] idKey, LocalUtilizationTracker localTracker) {
        try {
            Tree tree = dbImpl.getTree();
            tree.delete(idKey, localTracker);
            ++this.processedBinsThisRun;
        }
        catch (NodeNotEmptyException NNEE) {
            ++this.nonEmptyBinsThisRun;
        }
        catch (CursorsExistException e) {
            this.addBinRefToQueue(binRef, false);
            ++this.cursorsBinsThisRun;
        }
    }

    public BIN searchForBIN(DatabaseImpl db, BINReference binRef) {
        return db.getTree().search(binRef.getKey(), CacheMode.UNCHANGED);
    }

    private void resetPerRunCounters() {
        this.splitBinsThisRun = 0;
        this.dbClosedBinsThisRun = 0;
        this.cursorsBinsThisRun = 0;
        this.nonEmptyBinsThisRun = 0;
        this.processedBinsThisRun = 0;
    }

    private void accumulatePerRunCounters() {
        this.splitBins.add(this.splitBinsThisRun);
        this.dbClosedBins.add(this.dbClosedBinsThisRun);
        this.cursorsBins.add(this.cursorsBinsThisRun);
        this.nonEmptyBins.add(this.nonEmptyBinsThisRun);
        this.processedBins.add(this.processedBinsThisRun);
    }

    public void lazyCompress(IN in) {
        if (!in.isCompressible()) {
            return;
        }
        BIN bin = (BIN)in;
        assert (bin.isLatchExclusiveOwner());
        if (bin.nCursors() > 0) {
            return;
        }
        if (bin.compress(null) && bin.getNEntries() == 0) {
            this.addBinToQueue(bin, false);
        }
        ++this.lazyProcessed;
    }

    private boolean findDBAndBIN(BINSearch binSearch, BINReference binRef, DbTree dbTree, Map<DatabaseId, DatabaseImpl> dbCache) throws DatabaseException {
        binSearch.db = dbTree.getDb(binRef.getDatabaseId(), this.lockTimeout, dbCache);
        if (binSearch.db == null || binSearch.db.isDeleted()) {
            ++this.dbClosedBinsThisRun;
            return false;
        }
        this.env.daemonEviction(true);
        binSearch.bin = this.searchForBIN(binSearch.db, binRef);
        if (binSearch.bin == null || binSearch.bin.getNodeId() != binRef.getNodeId()) {
            if (binSearch.bin != null) {
                binSearch.bin.releaseLatch();
            }
            ++this.splitBinsThisRun;
            return false;
        }
        return true;
    }

    private static class BINSearch {
        public DatabaseImpl db;
        public BIN bin;

        private BINSearch() {
        }
    }
}

