/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.recovery;

import com.tangosol.internal.sleepycat.je.dbi.DatabaseId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class LevelRecorder {
    private Map<DatabaseId, LevelInfo> dbLevels = new HashMap<DatabaseId, LevelInfo>();

    LevelRecorder() {
    }

    void record(DatabaseId dbId, int level) {
        LevelInfo info = this.dbLevels.get(dbId);
        if (info == null) {
            info = new LevelInfo();
            this.dbLevels.put(dbId, info);
        }
        info.recordLevel(level);
    }

    Set<DatabaseId> getDbsWithDifferentLevels() {
        HashSet<DatabaseId> reprocessDbs = new HashSet<DatabaseId>();
        for (Map.Entry<DatabaseId, LevelInfo> oneEntry : this.dbLevels.entrySet()) {
            LevelInfo levelInfo = oneEntry.getValue();
            if (!levelInfo.getDifferenceSeen()) continue;
            reprocessDbs.add(oneEntry.getKey());
        }
        return reprocessDbs;
    }

    private static class LevelInfo {
        private int highest = Integer.MIN_VALUE;
        private int lowest = Integer.MAX_VALUE;
        private boolean differenceSeen = false;

        private LevelInfo() {
        }

        void recordLevel(int level) {
            if (!this.differenceSeen) {
                if (level < this.lowest) {
                    this.lowest = level;
                }
                if (level > this.highest) {
                    this.highest = level;
                }
                this.differenceSeen = this.highest > this.lowest;
            }
        }

        boolean getDifferenceSeen() {
            return this.differenceSeen;
        }
    }
}

